
#ifndef _ADW_COMPAT_H
#define _ADW_COMPAT_H

/**
 * SECTION:adw-compat
 * @title: Adwaita Compatibility
 * @short_description: Compatibility layer for libadwaita code
 *
 * This header provides compatibility definitions to allow code written for
 * libadwaita to work with libadapta with minimal changes. Simply include
 * this header before including adapta.h in your code.
 *
 * Example:
 * ```c
 * #include <libadapta-1/adw-compat.h>
 * #include <libadapta-1/adapta.h>
 *
 * // Now use Adwaita class names and function names
 * AdwApplicationWindow *window = ADW_APPLICATION_WINDOW(adw_application_window_new(app));
 * ```
 */

/* General namespace mapping */
#define Adw Adap

/* Map libAdwaita (Adw) types to libAdapta (Adap) types */
#define AdwAboutDialog AdapAboutDialog
#define AdwAboutWindow AdapAboutWindow
#define AdwActionRow AdapActionRow
#define AdwActionRowClass AdapActionRowClass
#define AdwAlertDialog AdapAlertDialog
#define AdwAnimation AdapAnimation
#define AdwAnimationTarget AdapAnimationTarget
#define AdwApplication AdapApplication
#define AdwApplicationWindow AdapApplicationWindow
#define AdwAvatar AdapAvatar
#define AdwBackButton AdapBackButton
#define AdwBanner AdapBanner
#define AdwBin AdapBin
#define AdwBottomSheet AdapBottomSheet
#define AdwBreakpoint AdapBreakpoint
#define AdwBreakpointBin AdapBreakpointBin
#define AdwBreakpointCondition AdapBreakpointCondition
#define AdwButtonContent AdapButtonContent
#define AdwCarousel AdapCarousel
#define AdwCarouselIndicatorDots AdapCarouselIndicatorDots
#define AdwCarouselIndicatorLines AdapCarouselIndicatorLines
#define AdwClamp AdapClamp
#define AdwClampLayout AdapClampLayout
#define AdwClampScrollable AdapClampScrollable
#define AdwComboRow AdapComboRow
#define AdwComboRowClass AdapComboRowClass
#define AdwDemoPageAbout AdapDemoPageAbout
#define AdwDemoPageAnimations AdapDemoPageAnimations
#define AdwDemoPageAvatar AdapDemoPageAvatar
#define AdwDemoPageBanners AdapDemoPageBanners
#define AdwDemoPageButtons AdapDemoPageButtons
#define AdwDemoPageCarousel AdapDemoPageCarousel
#define AdwDemoPageClamp AdapDemoPageClamp
#define AdwDemoPageDialogs AdapDemoPageDialogs
#define AdwDemoPageLists AdapDemoPageLists
#define AdwDemoPageNavigationView AdapDemoPageNavigationView
#define AdwDemoPageSplitViews AdapDemoPageSplitViews
#define AdwDemoPageStyles AdapDemoPageStyles
#define AdwDemoPageTabView AdapDemoPageTabView
#define AdwDemoPageToasts AdapDemoPageToasts
#define AdwDemoPageViewSwitcher AdapDemoPageViewSwitcher
#define AdwDemoPageWelcome AdapDemoPageWelcome
#define AdwDemoPreferencesWindow AdapDemoPreferencesWindow
#define AdwDemoWindow AdapDemoWindow
#define AdwDialog AdapDialog
#define AdwDialogHost AdapDialogHost
#define AdwEntryRow AdapEntryRow
#define AdwEntryRowClass AdapEntryRowClass
#define AdwEnumListItem AdapEnumListItem
#define AdwEnumListModel AdapEnumListModel
#define AdwExpanderRow AdapExpanderRow
#define AdwExpanderRowClass AdapExpanderRowClass
#define AdwFadingLabel AdapFadingLabel
#define AdwFlap AdapFlap
#define AdwFloatingSheet AdapFloatingSheet
#define AdwGizmo AdapGizmo
#define AdwHeaderBar AdapHeaderBar
#define AdwIndicatorBin AdapIndicatorBin
#define AdwInspectorPage AdapInspectorPage
#define AdwLeaflet AdapLeaflet
#define AdwLeafletPage AdapLeafletPage
#define AdwMessageDialog AdapMessageDialog
#define AdwNavigationPage AdapNavigationPage
#define AdwNavigationSplitView AdapNavigationSplitView
#define AdwNavigationSplitViewDemoWindow AdapNavigationSplitViewDemoWindow
#define AdwNavigationView AdapNavigationView
#define AdwNavigationViewDemoWindow AdapNavigationViewDemoWindow
#define AdwOverlaySplitView AdapOverlaySplitView
#define AdwOverlaySplitViewDemoWindow AdapOverlaySplitViewDemoWindow
#define AdwPasswordEntryRow AdapPasswordEntryRow
#define AdwPreferencesDialog AdapPreferencesDialog
#define AdwPreferencesDialogClass AdapPreferencesDialogClass
#define AdwPreferencesGroup AdapPreferencesGroup
#define AdwPreferencesGroupClass AdapPreferencesGroupClass
#define AdwPreferencesPage AdapPreferencesPage
#define AdwPreferencesPageClass AdapPreferencesPageClass
#define AdwPreferencesRow AdapPreferencesRow
#define AdwPreferencesRowClass AdapPreferencesRowClass
#define AdwPreferencesWindow AdapPreferencesWindow
#define AdwPreferencesWindowClass AdapPreferencesWindowClass
#define AdwPropertyAnimationTarget AdapPropertyAnimationTarget
#define AdwSettings AdapSettings
#define AdwSettingsImpl AdapSettingsImpl
#define AdwSettingsImplGSettings AdapSettingsImplGSettings
#define AdwSettingsImplLegacy AdapSettingsImplLegacy
#define AdwSettingsImplMacOS AdapSettingsImplMacOS
#define AdwSettingsImplPortal AdapSettingsImplPortal
#define AdwSettingsImplWin32 AdapSettingsImplWin32
#define AdwShadowHelper AdapShadowHelper
#define AdwSheetControls AdapSheetControls
#define AdwSpinRow AdapSpinRow
#define AdwSplitButton AdapSplitButton
#define AdwSpringAnimation AdapSpringAnimation
#define AdwSpringParams AdapSpringParams
#define AdwSqueezer AdapSqueezer
#define AdwSqueezerPage AdapSqueezerPage
#define AdwStatusPage AdapStatusPage
#define AdwStyleDemoWindow AdapStyleDemoWindow
#define AdwStyleManager AdapStyleManager
#define AdwSwipeTracker AdapSwipeTracker
#define AdwSwipeable AdapSwipeable
#define AdwSwitchRow AdapSwitchRow
#define AdwTab AdapTab
#define AdwTabBar AdapTabBar
#define AdwTabBox AdapTabBox
#define AdwTabButton AdapTabButton
#define AdwTabGrid AdapTabGrid
#define AdwTabOverview AdapTabOverview
#define AdwTabPage AdapTabPage
#define AdwTabThumbnail AdapTabThumbnail
#define AdwTabView AdapTabView
#define AdwTabViewDemoPage AdapTabViewDemoPage
#define AdwTabViewDemoWindow AdapTabViewDemoWindow
#define AdwTimedAnimation AdapTimedAnimation
#define AdwToast AdapToast
#define AdwToastOverlay AdapToastOverlay
#define AdwToastWidget AdapToastWidget
#define AdwToolbarView AdapToolbarView
#define AdwViewStack AdapViewStack
#define AdwViewStackPage AdapViewStackPage
#define AdwViewStackPages AdapViewStackPages
#define AdwViewSwitcher AdapViewSwitcher
#define AdwViewSwitcherBar AdapViewSwitcherBar
#define AdwViewSwitcherButton AdapViewSwitcherButton
#define AdwViewSwitcherDemoWindow AdapViewSwitcherDemoWindow
#define AdwViewSwitcherTitle AdapViewSwitcherTitle
#define AdwWindow AdapWindow
#define AdwWindowTitle AdapWindowTitle

/* Map libAdwaita (Adw) type casting macros to libAdapta (Adap) type casting macros */
#define ADW_ABOUT_DIALOG(obj) ADAP_ABOUT_DIALOG(obj)
#define ADW_ABOUT_WINDOW(obj) ADAP_ABOUT_WINDOW(obj)
#define ADW_ACTION_ROW(obj) ADAP_ACTION_ROW(obj)
#define ADW_ALERT_DIALOG(obj) ADAP_ALERT_DIALOG(obj)
#define ADW_ANIMATION(obj) ADAP_ANIMATION(obj)
#define ADW_APPLICATION(obj) ADAP_APPLICATION(obj)
#define ADW_APPLICATION_WINDOW(obj) ADAP_APPLICATION_WINDOW(obj)
#define ADW_AVATAR(obj) ADAP_AVATAR(obj)
#define ADW_BACK_BUTTON(obj) ADAP_BACK_BUTTON(obj)
#define ADW_BANNER(obj) ADAP_BANNER(obj)
#define ADW_BIN(obj) ADAP_BIN(obj)
#define ADW_BOTTOM_SHEET(obj) ADAP_BOTTOM_SHEET(obj)
#define ADW_BREAKPOINT(obj) ADAP_BREAKPOINT(obj)
#define ADW_BREAKPOINT_BIN(obj) ADAP_BREAKPOINT_BIN(obj)
#define ADW_BUTTON_CONTENT(obj) ADAP_BUTTON_CONTENT(obj)
#define ADW_CAROUSEL(obj) ADAP_CAROUSEL(obj)
#define ADW_CAROUSEL_INDICATOR_DOTS(obj) ADAP_CAROUSEL_INDICATOR_DOTS(obj)
#define ADW_CAROUSEL_INDICATOR_LINES(obj) ADAP_CAROUSEL_INDICATOR_LINES(obj)
#define ADW_CLAMP(obj) ADAP_CLAMP(obj)
#define ADW_CLAMP_LAYOUT(obj) ADAP_CLAMP_LAYOUT(obj)
#define ADW_CLAMP_SCROLLABLE(obj) ADAP_CLAMP_SCROLLABLE(obj)
#define ADW_COMBO_ROW(obj) ADAP_COMBO_ROW(obj)
#define ADW_DEMO_PAGE_ABOUT(obj) ADAP_DEMO_PAGE_ABOUT(obj)
#define ADW_DEMO_PAGE_ANIMATIONS(obj) ADAP_DEMO_PAGE_ANIMATIONS(obj)
#define ADW_DEMO_PAGE_AVATAR(obj) ADAP_DEMO_PAGE_AVATAR(obj)
#define ADW_DEMO_PAGE_BANNERS(obj) ADAP_DEMO_PAGE_BANNERS(obj)
#define ADW_DEMO_PAGE_BUTTONS(obj) ADAP_DEMO_PAGE_BUTTONS(obj)
#define ADW_DEMO_PAGE_CAROUSEL(obj) ADAP_DEMO_PAGE_CAROUSEL(obj)
#define ADW_DEMO_PAGE_CLAMP(obj) ADAP_DEMO_PAGE_CLAMP(obj)
#define ADW_DEMO_PAGE_DIALOGS(obj) ADAP_DEMO_PAGE_DIALOGS(obj)
#define ADW_DEMO_PAGE_LISTS(obj) ADAP_DEMO_PAGE_LISTS(obj)
#define ADW_DEMO_PAGE_NAVIGATION_VIEW(obj) ADAP_DEMO_PAGE_NAVIGATION_VIEW(obj)
#define ADW_DEMO_PAGE_SPLIT_VIEWS(obj) ADAP_DEMO_PAGE_SPLIT_VIEWS(obj)
#define ADW_DEMO_PAGE_STYLES(obj) ADAP_DEMO_PAGE_STYLES(obj)
#define ADW_DEMO_PAGE_TAB_VIEW(obj) ADAP_DEMO_PAGE_TAB_VIEW(obj)
#define ADW_DEMO_PAGE_TOASTS(obj) ADAP_DEMO_PAGE_TOASTS(obj)
#define ADW_DEMO_PAGE_VIEW_SWITCHER(obj) ADAP_DEMO_PAGE_VIEW_SWITCHER(obj)
#define ADW_DEMO_PAGE_WELCOME(obj) ADAP_DEMO_PAGE_WELCOME(obj)
#define ADW_DEMO_PREFERENCES_WINDOW(obj) ADAP_DEMO_PREFERENCES_WINDOW(obj)
#define ADW_DEMO_WINDOW(obj) ADAP_DEMO_WINDOW(obj)
#define ADW_DIALOG(obj) ADAP_DIALOG(obj)
#define ADW_DIALOG_HOST(obj) ADAP_DIALOG_HOST(obj)
#define ADW_ENTRY_ROW(obj) ADAP_ENTRY_ROW(obj)
#define ADW_ENUM_LIST_ITEM(obj) ADAP_ENUM_LIST_ITEM(obj)
#define ADW_ENUM_LIST_MODEL(obj) ADAP_ENUM_LIST_MODEL(obj)
#define ADW_EXPANDER_ROW(obj) ADAP_EXPANDER_ROW(obj)
#define ADW_FADING_LABEL(obj) ADAP_FADING_LABEL(obj)
#define ADW_FLAP(obj) ADAP_FLAP(obj)
#define ADW_FLOATING_SHEET(obj) ADAP_FLOATING_SHEET(obj)
#define ADW_GIZMO(obj) ADAP_GIZMO(obj)
#define ADW_HEADER_BAR(obj) ADAP_HEADER_BAR(obj)
#define ADW_INDICATOR_BIN(obj) ADAP_INDICATOR_BIN(obj)
#define ADW_INSPECTOR_PAGE(obj) ADAP_INSPECTOR_PAGE(obj)
#define ADW_LEAFLET(obj) ADAP_LEAFLET(obj)
#define ADW_LEAFLET_PAGE(obj) ADAP_LEAFLET_PAGE(obj)
#define ADW_MESSAGE_DIALOG(obj) ADAP_MESSAGE_DIALOG(obj)
#define ADW_NAVIGATION_PAGE(obj) ADAP_NAVIGATION_PAGE(obj)
#define ADW_NAVIGATION_SPLIT_VIEW(obj) ADAP_NAVIGATION_SPLIT_VIEW(obj)
#define ADW_NAVIGATION_SPLIT_VIEW_DEMO_WINDOW(obj) ADAP_NAVIGATION_SPLIT_VIEW_DEMO_WINDOW(obj)
#define ADW_NAVIGATION_VIEW(obj) ADAP_NAVIGATION_VIEW(obj)
#define ADW_NAVIGATION_VIEW_DEMO_WINDOW(obj) ADAP_NAVIGATION_VIEW_DEMO_WINDOW(obj)
#define ADW_OVERLAY_SPLIT_VIEW(obj) ADAP_OVERLAY_SPLIT_VIEW(obj)
#define ADW_OVERLAY_SPLIT_VIEW_DEMO_WINDOW(obj) ADAP_OVERLAY_SPLIT_VIEW_DEMO_WINDOW(obj)
#define ADW_PASSWORD_ENTRY_ROW(obj) ADAP_PASSWORD_ENTRY_ROW(obj)
#define ADW_PREFERENCES_DIALOG(obj) ADAP_PREFERENCES_DIALOG(obj)
#define ADW_PREFERENCES_GROUP(obj) ADAP_PREFERENCES_GROUP(obj)
#define ADW_PREFERENCES_PAGE(obj) ADAP_PREFERENCES_PAGE(obj)
#define ADW_PREFERENCES_ROW(obj) ADAP_PREFERENCES_ROW(obj)
#define ADW_PREFERENCES_WINDOW(obj) ADAP_PREFERENCES_WINDOW(obj)
#define ADW_SETTINGS(obj) ADAP_SETTINGS(obj)
#define ADW_SETTINGS_IMPL(obj) ADAP_SETTINGS_IMPL(obj)
#define ADW_SETTINGS_IMPL_GSETTINGS(obj) ADAP_SETTINGS_IMPL_GSETTINGS(obj)
#define ADW_SETTINGS_IMPL_LEGACY(obj) ADAP_SETTINGS_IMPL_LEGACY(obj)
#define ADW_SETTINGS_IMPL_MACOS(obj) ADAP_SETTINGS_IMPL_MACOS(obj)
#define ADW_SETTINGS_IMPL_PORTAL(obj) ADAP_SETTINGS_IMPL_PORTAL(obj)
#define ADW_SETTINGS_IMPL_WIN(obj) ADAP_SETTINGS_IMPL_WIN(obj)
#define ADW_SHADOW_HELPER(obj) ADAP_SHADOW_HELPER(obj)
#define ADW_SHEET_CONTROLS(obj) ADAP_SHEET_CONTROLS(obj)
#define ADW_SPIN_ROW(obj) ADAP_SPIN_ROW(obj)
#define ADW_SPLIT_BUTTON(obj) ADAP_SPLIT_BUTTON(obj)
#define ADW_SQUEEZER(obj) ADAP_SQUEEZER(obj)
#define ADW_SQUEEZER_PAGE(obj) ADAP_SQUEEZER_PAGE(obj)
#define ADW_STATUS_PAGE(obj) ADAP_STATUS_PAGE(obj)
#define ADW_STYLE_DEMO_WINDOW(obj) ADAP_STYLE_DEMO_WINDOW(obj)
#define ADW_STYLE_MANAGER(obj) ADAP_STYLE_MANAGER(obj)
#define ADW_SWIPE_TRACKER(obj) ADAP_SWIPE_TRACKER(obj)
#define ADW_SWITCH_ROW(obj) ADAP_SWITCH_ROW(obj)
#define ADW_TAB(obj) ADAP_TAB(obj)
#define ADW_TAB_BAR(obj) ADAP_TAB_BAR(obj)
#define ADW_TAB_BOX(obj) ADAP_TAB_BOX(obj)
#define ADW_TAB_BUTTON(obj) ADAP_TAB_BUTTON(obj)
#define ADW_TAB_GRID(obj) ADAP_TAB_GRID(obj)
#define ADW_TAB_OVERVIEW(obj) ADAP_TAB_OVERVIEW(obj)
#define ADW_TAB_PAGE(obj) ADAP_TAB_PAGE(obj)
#define ADW_TAB_THUMBNAIL(obj) ADAP_TAB_THUMBNAIL(obj)
#define ADW_TAB_VIEW(obj) ADAP_TAB_VIEW(obj)
#define ADW_TAB_VIEW_DEMO_PAGE(obj) ADAP_TAB_VIEW_DEMO_PAGE(obj)
#define ADW_TAB_VIEW_DEMO_WINDOW(obj) ADAP_TAB_VIEW_DEMO_WINDOW(obj)
#define ADW_TOAST(obj) ADAP_TOAST(obj)
#define ADW_TOAST_OVERLAY(obj) ADAP_TOAST_OVERLAY(obj)
#define ADW_TOAST_WIDGET(obj) ADAP_TOAST_WIDGET(obj)
#define ADW_TOOLBAR_VIEW(obj) ADAP_TOOLBAR_VIEW(obj)
#define ADW_TYPE_ABOUT_DIALOG(obj) ADAP_TYPE_ABOUT_DIALOG(obj)
#define ADW_TYPE_ABOUT_WINDOW(obj) ADAP_TYPE_ABOUT_WINDOW(obj)
#define ADW_TYPE_ACTION_ROW(obj) ADAP_TYPE_ACTION_ROW(obj)
#define ADW_TYPE_ALERT_DIALOG(obj) ADAP_TYPE_ALERT_DIALOG(obj)
#define ADW_TYPE_ANIMATION(obj) ADAP_TYPE_ANIMATION(obj)
#define ADW_TYPE_ANIMATION_TARGET(obj) ADAP_TYPE_ANIMATION_TARGET(obj)
#define ADW_TYPE_APPLICATION(obj) ADAP_TYPE_APPLICATION(obj)
#define ADW_TYPE_APPLICATION_WINDOW(obj) ADAP_TYPE_APPLICATION_WINDOW(obj)
#define ADW_TYPE_AVATAR(obj) ADAP_TYPE_AVATAR(obj)
#define ADW_TYPE_BACK_BUTTON(obj) ADAP_TYPE_BACK_BUTTON(obj)
#define ADW_TYPE_BANNER(obj) ADAP_TYPE_BANNER(obj)
#define ADW_TYPE_BIN(obj) ADAP_TYPE_BIN(obj)
#define ADW_TYPE_BOTTOM_SHEET(obj) ADAP_TYPE_BOTTOM_SHEET(obj)
#define ADW_TYPE_BREAKPOINT(obj) ADAP_TYPE_BREAKPOINT(obj)
#define ADW_TYPE_BREAKPOINT_BIN(obj) ADAP_TYPE_BREAKPOINT_BIN(obj)
#define ADW_TYPE_BREAKPOINT_CONDITION(obj) ADAP_TYPE_BREAKPOINT_CONDITION(obj)
#define ADW_TYPE_BUTTON_CONTENT(obj) ADAP_TYPE_BUTTON_CONTENT(obj)
#define ADW_TYPE_CALLBACK_ANIMATION_TARGET(obj) ADAP_TYPE_CALLBACK_ANIMATION_TARGET(obj)
#define ADW_TYPE_CAROUSEL(obj) ADAP_TYPE_CAROUSEL(obj)
#define ADW_TYPE_CAROUSEL_INDICATOR_DOTS(obj) ADAP_TYPE_CAROUSEL_INDICATOR_DOTS(obj)
#define ADW_TYPE_CAROUSEL_INDICATOR_LINES(obj) ADAP_TYPE_CAROUSEL_INDICATOR_LINES(obj)
#define ADW_TYPE_CLAMP(obj) ADAP_TYPE_CLAMP(obj)
#define ADW_TYPE_CLAMP_LAYOUT(obj) ADAP_TYPE_CLAMP_LAYOUT(obj)
#define ADW_TYPE_CLAMP_SCROLLABLE(obj) ADAP_TYPE_CLAMP_SCROLLABLE(obj)
#define ADW_TYPE_COMBO_ROW(obj) ADAP_TYPE_COMBO_ROW(obj)
#define ADW_TYPE_DEMO_PAGE_ABOUT(obj) ADAP_TYPE_DEMO_PAGE_ABOUT(obj)
#define ADW_TYPE_DEMO_PAGE_ANIMATIONS(obj) ADAP_TYPE_DEMO_PAGE_ANIMATIONS(obj)
#define ADW_TYPE_DEMO_PAGE_AVATAR(obj) ADAP_TYPE_DEMO_PAGE_AVATAR(obj)
#define ADW_TYPE_DEMO_PAGE_BANNERS(obj) ADAP_TYPE_DEMO_PAGE_BANNERS(obj)
#define ADW_TYPE_DEMO_PAGE_BUTTONS(obj) ADAP_TYPE_DEMO_PAGE_BUTTONS(obj)
#define ADW_TYPE_DEMO_PAGE_CAROUSEL(obj) ADAP_TYPE_DEMO_PAGE_CAROUSEL(obj)
#define ADW_TYPE_DEMO_PAGE_CLAMP(obj) ADAP_TYPE_DEMO_PAGE_CLAMP(obj)
#define ADW_TYPE_DEMO_PAGE_DIALOGS(obj) ADAP_TYPE_DEMO_PAGE_DIALOGS(obj)
#define ADW_TYPE_DEMO_PAGE_LISTS(obj) ADAP_TYPE_DEMO_PAGE_LISTS(obj)
#define ADW_TYPE_DEMO_PAGE_NAVIGATION_VIEW(obj) ADAP_TYPE_DEMO_PAGE_NAVIGATION_VIEW(obj)
#define ADW_TYPE_DEMO_PAGE_SPLIT_VIEWS(obj) ADAP_TYPE_DEMO_PAGE_SPLIT_VIEWS(obj)
#define ADW_TYPE_DEMO_PAGE_STYLES(obj) ADAP_TYPE_DEMO_PAGE_STYLES(obj)
#define ADW_TYPE_DEMO_PAGE_TAB_VIEW(obj) ADAP_TYPE_DEMO_PAGE_TAB_VIEW(obj)
#define ADW_TYPE_DEMO_PAGE_TOASTS(obj) ADAP_TYPE_DEMO_PAGE_TOASTS(obj)
#define ADW_TYPE_DEMO_PAGE_VIEW_SWITCHER(obj) ADAP_TYPE_DEMO_PAGE_VIEW_SWITCHER(obj)
#define ADW_TYPE_DEMO_PAGE_WELCOME(obj) ADAP_TYPE_DEMO_PAGE_WELCOME(obj)
#define ADW_TYPE_DEMO_PREFERENCES_WINDOW(obj) ADAP_TYPE_DEMO_PREFERENCES_WINDOW(obj)
#define ADW_TYPE_DEMO_WINDOW(obj) ADAP_TYPE_DEMO_WINDOW(obj)
#define ADW_TYPE_DIALOG(obj) ADAP_TYPE_DIALOG(obj)
#define ADW_TYPE_DIALOG_HOST(obj) ADAP_TYPE_DIALOG_HOST(obj)
#define ADW_TYPE_ENTRY_ROW(obj) ADAP_TYPE_ENTRY_ROW(obj)
#define ADW_TYPE_ENUM_LIST_ITEM(obj) ADAP_TYPE_ENUM_LIST_ITEM(obj)
#define ADW_TYPE_ENUM_LIST_MODEL(obj) ADAP_TYPE_ENUM_LIST_MODEL(obj)
#define ADW_TYPE_EXPANDER_ROW(obj) ADAP_TYPE_EXPANDER_ROW(obj)
#define ADW_TYPE_FADING_LABEL(obj) ADAP_TYPE_FADING_LABEL(obj)
#define ADW_TYPE_FLAP(obj) ADAP_TYPE_FLAP(obj)
#define ADW_TYPE_FLOATING_SHEET(obj) ADAP_TYPE_FLOATING_SHEET(obj)
#define ADW_TYPE_GIZMO(obj) ADAP_TYPE_GIZMO(obj)
#define ADW_TYPE_HEADER_BAR(obj) ADAP_TYPE_HEADER_BAR(obj)
#define ADW_TYPE_INDICATOR_BIN(obj) ADAP_TYPE_INDICATOR_BIN(obj)
#define ADW_TYPE_INSPECTOR_PAGE(obj) ADAP_TYPE_INSPECTOR_PAGE(obj)
#define ADW_TYPE_LEAFLET(obj) ADAP_TYPE_LEAFLET(obj)
#define ADW_TYPE_LEAFLET_PAGE(obj) ADAP_TYPE_LEAFLET_PAGE(obj)
#define ADW_TYPE_MESSAGE_DIALOG(obj) ADAP_TYPE_MESSAGE_DIALOG(obj)
#define ADW_TYPE_NAVIGATION_PAGE(obj) ADAP_TYPE_NAVIGATION_PAGE(obj)
#define ADW_TYPE_NAVIGATION_SPLIT_VIEW(obj) ADAP_TYPE_NAVIGATION_SPLIT_VIEW(obj)
#define ADW_TYPE_NAVIGATION_SPLIT_VIEW_DEMO_WINDOW(obj) ADAP_TYPE_NAVIGATION_SPLIT_VIEW_DEMO_WINDOW(obj)
#define ADW_TYPE_NAVIGATION_VIEW(obj) ADAP_TYPE_NAVIGATION_VIEW(obj)
#define ADW_TYPE_NAVIGATION_VIEW_DEMO_WINDOW(obj) ADAP_TYPE_NAVIGATION_VIEW_DEMO_WINDOW(obj)
#define ADW_TYPE_OVERLAY_SPLIT_VIEW(obj) ADAP_TYPE_OVERLAY_SPLIT_VIEW(obj)
#define ADW_TYPE_OVERLAY_SPLIT_VIEW_DEMO_WINDOW(obj) ADAP_TYPE_OVERLAY_SPLIT_VIEW_DEMO_WINDOW(obj)
#define ADW_TYPE_PASSWORD_ENTRY_ROW(obj) ADAP_TYPE_PASSWORD_ENTRY_ROW(obj)
#define ADW_TYPE_PREFERENCES_DIALOG(obj) ADAP_TYPE_PREFERENCES_DIALOG(obj)
#define ADW_TYPE_PREFERENCES_GROUP(obj) ADAP_TYPE_PREFERENCES_GROUP(obj)
#define ADW_TYPE_PREFERENCES_PAGE(obj) ADAP_TYPE_PREFERENCES_PAGE(obj)
#define ADW_TYPE_PREFERENCES_ROW(obj) ADAP_TYPE_PREFERENCES_ROW(obj)
#define ADW_TYPE_PREFERENCES_WINDOW(obj) ADAP_TYPE_PREFERENCES_WINDOW(obj)
#define ADW_TYPE_PROPERTY_ANIMATION_TARGET(obj) ADAP_TYPE_PROPERTY_ANIMATION_TARGET(obj)
#define ADW_TYPE_SETTINGS(obj) ADAP_TYPE_SETTINGS(obj)
#define ADW_TYPE_SETTINGS_IMPL(obj) ADAP_TYPE_SETTINGS_IMPL(obj)
#define ADW_TYPE_SETTINGS_IMPL_GSETTINGS(obj) ADAP_TYPE_SETTINGS_IMPL_GSETTINGS(obj)
#define ADW_TYPE_SETTINGS_IMPL_LEGACY(obj) ADAP_TYPE_SETTINGS_IMPL_LEGACY(obj)
#define ADW_TYPE_SETTINGS_IMPL_MACOS(obj) ADAP_TYPE_SETTINGS_IMPL_MACOS(obj)
#define ADW_TYPE_SETTINGS_IMPL_PORTAL(obj) ADAP_TYPE_SETTINGS_IMPL_PORTAL(obj)
#define ADW_TYPE_SETTINGS_IMPL_WIN(obj) ADAP_TYPE_SETTINGS_IMPL_WIN(obj)
#define ADW_TYPE_SHADOW_HELPER(obj) ADAP_TYPE_SHADOW_HELPER(obj)
#define ADW_TYPE_SHEET_CONTROLS(obj) ADAP_TYPE_SHEET_CONTROLS(obj)
#define ADW_TYPE_SPIN_ROW(obj) ADAP_TYPE_SPIN_ROW(obj)
#define ADW_TYPE_SPLIT_BUTTON(obj) ADAP_TYPE_SPLIT_BUTTON(obj)
#define ADW_TYPE_SPRING_ANIMATION(obj) ADAP_TYPE_SPRING_ANIMATION(obj)
#define ADW_TYPE_SPRING_PARAMS(obj) ADAP_TYPE_SPRING_PARAMS(obj)
#define ADW_TYPE_SQUEEZER(obj) ADAP_TYPE_SQUEEZER(obj)
#define ADW_TYPE_SQUEEZER_PAGE(obj) ADAP_TYPE_SQUEEZER_PAGE(obj)
#define ADW_TYPE_STATUS_PAGE(obj) ADAP_TYPE_STATUS_PAGE(obj)
#define ADW_TYPE_STYLE_DEMO_WINDOW(obj) ADAP_TYPE_STYLE_DEMO_WINDOW(obj)
#define ADW_TYPE_STYLE_MANAGER(obj) ADAP_TYPE_STYLE_MANAGER(obj)
#define ADW_TYPE_SWIPEABLE(obj) ADAP_TYPE_SWIPEABLE(obj)
#define ADW_TYPE_SWIPE_TRACKER(obj) ADAP_TYPE_SWIPE_TRACKER(obj)
#define ADW_TYPE_SWITCH_ROW(obj) ADAP_TYPE_SWITCH_ROW(obj)
#define ADW_TYPE_TAB(obj) ADAP_TYPE_TAB(obj)
#define ADW_TYPE_TAB_BAR(obj) ADAP_TYPE_TAB_BAR(obj)
#define ADW_TYPE_TAB_BOX(obj) ADAP_TYPE_TAB_BOX(obj)
#define ADW_TYPE_TAB_BUTTON(obj) ADAP_TYPE_TAB_BUTTON(obj)
#define ADW_TYPE_TAB_GRID(obj) ADAP_TYPE_TAB_GRID(obj)
#define ADW_TYPE_TAB_OVERVIEW(obj) ADAP_TYPE_TAB_OVERVIEW(obj)
#define ADW_TYPE_TAB_PAGE(obj) ADAP_TYPE_TAB_PAGE(obj)
#define ADW_TYPE_TAB_THUMBNAIL(obj) ADAP_TYPE_TAB_THUMBNAIL(obj)
#define ADW_TYPE_TAB_VIEW(obj) ADAP_TYPE_TAB_VIEW(obj)
#define ADW_TYPE_TAB_VIEW_DEMO_PAGE(obj) ADAP_TYPE_TAB_VIEW_DEMO_PAGE(obj)
#define ADW_TYPE_TAB_VIEW_DEMO_WINDOW(obj) ADAP_TYPE_TAB_VIEW_DEMO_WINDOW(obj)
#define ADW_TYPE_TIMED_ANIMATION(obj) ADAP_TYPE_TIMED_ANIMATION(obj)
#define ADW_TYPE_TOAST(obj) ADAP_TYPE_TOAST(obj)
#define ADW_TYPE_TOAST_OVERLAY(obj) ADAP_TYPE_TOAST_OVERLAY(obj)
#define ADW_TYPE_TOAST_WIDGET(obj) ADAP_TYPE_TOAST_WIDGET(obj)
#define ADW_TYPE_TOOLBAR_VIEW(obj) ADAP_TYPE_TOOLBAR_VIEW(obj)
#define ADW_TYPE_VIEW_STACK(obj) ADAP_TYPE_VIEW_STACK(obj)
#define ADW_TYPE_VIEW_STACK_PAGE(obj) ADAP_TYPE_VIEW_STACK_PAGE(obj)
#define ADW_TYPE_VIEW_STACK_PAGES(obj) ADAP_TYPE_VIEW_STACK_PAGES(obj)
#define ADW_TYPE_VIEW_SWITCHER(obj) ADAP_TYPE_VIEW_SWITCHER(obj)
#define ADW_TYPE_VIEW_SWITCHER_BAR(obj) ADAP_TYPE_VIEW_SWITCHER_BAR(obj)
#define ADW_TYPE_VIEW_SWITCHER_BUTTON(obj) ADAP_TYPE_VIEW_SWITCHER_BUTTON(obj)
#define ADW_TYPE_VIEW_SWITCHER_DEMO_WINDOW(obj) ADAP_TYPE_VIEW_SWITCHER_DEMO_WINDOW(obj)
#define ADW_TYPE_VIEW_SWITCHER_TITLE(obj) ADAP_TYPE_VIEW_SWITCHER_TITLE(obj)
#define ADW_TYPE_WINDOW(obj) ADAP_TYPE_WINDOW(obj)
#define ADW_TYPE_WINDOW_TITLE(obj) ADAP_TYPE_WINDOW_TITLE(obj)
#define ADW_VIEW_STACK(obj) ADAP_VIEW_STACK(obj)
#define ADW_VIEW_STACK_PAGE(obj) ADAP_VIEW_STACK_PAGE(obj)
#define ADW_VIEW_STACK_PAGES(obj) ADAP_VIEW_STACK_PAGES(obj)
#define ADW_VIEW_SWITCHER(obj) ADAP_VIEW_SWITCHER(obj)
#define ADW_VIEW_SWITCHER_BAR(obj) ADAP_VIEW_SWITCHER_BAR(obj)
#define ADW_VIEW_SWITCHER_BUTTON(obj) ADAP_VIEW_SWITCHER_BUTTON(obj)
#define ADW_VIEW_SWITCHER_DEMO_WINDOW(obj) ADAP_VIEW_SWITCHER_DEMO_WINDOW(obj)
#define ADW_VIEW_SWITCHER_TITLE(obj) ADAP_VIEW_SWITCHER_TITLE(obj)
#define ADW_WINDOW(obj) ADAP_WINDOW(obj)
#define ADW_WINDOW_TITLE(obj) ADAP_WINDOW_TITLE(obj)

/* Map libAdwaita (Adw) constant macros to libAdapta (Adap) constant macros */
#define ADW_CRITICAL_CANNOT_REMOVE_CHILD ADAP_CRITICAL_CANNOT_REMOVE_CHILD
#define ADW_DURATION_INFINITE ADAP_DURATION_INFINITE
#define ADW_SWIPE_BORDER ADAP_SWIPE_BORDER

/* Map libAdwaita (Adw) functions to libAdapta (Adap) functions */
#define adw_about_dialog_add_acknowledgement_section adap_about_dialog_add_acknowledgement_section
#define adw_about_dialog_add_credit_section adap_about_dialog_add_credit_section
#define adw_about_dialog_add_legal_section adap_about_dialog_add_legal_section
#define adw_about_dialog_add_link adap_about_dialog_add_link
#define adw_about_dialog_get_application_icon adap_about_dialog_get_application_icon
#define adw_about_dialog_get_application_name adap_about_dialog_get_application_name
#define adw_about_dialog_get_artists adap_about_dialog_get_artists
#define adw_about_dialog_get_comments adap_about_dialog_get_comments
#define adw_about_dialog_get_copyright adap_about_dialog_get_copyright
#define adw_about_dialog_get_debug_info adap_about_dialog_get_debug_info
#define adw_about_dialog_get_debug_info_filename adap_about_dialog_get_debug_info_filename
#define adw_about_dialog_get_designers adap_about_dialog_get_designers
#define adw_about_dialog_get_developer_name adap_about_dialog_get_developer_name
#define adw_about_dialog_get_developers adap_about_dialog_get_developers
#define adw_about_dialog_get_documenters adap_about_dialog_get_documenters
#define adw_about_dialog_get_issue_url adap_about_dialog_get_issue_url
#define adw_about_dialog_get_license adap_about_dialog_get_license
#define adw_about_dialog_get_license_type adap_about_dialog_get_license_type
#define adw_about_dialog_get_release_notes adap_about_dialog_get_release_notes
#define adw_about_dialog_get_release_notes_version adap_about_dialog_get_release_notes_version
#define adw_about_dialog_get_support_url adap_about_dialog_get_support_url
#define adw_about_dialog_get_translator_credits adap_about_dialog_get_translator_credits
#define adw_about_dialog_get_type adap_about_dialog_get_type
#define adw_about_dialog_get_version adap_about_dialog_get_version
#define adw_about_dialog_get_website adap_about_dialog_get_website
#define adw_about_dialog_new adap_about_dialog_new
#define adw_about_dialog_new_from_appdata adap_about_dialog_new_from_appdata
#define adw_about_dialog_set_application_icon adap_about_dialog_set_application_icon
#define adw_about_dialog_set_application_name adap_about_dialog_set_application_name
#define adw_about_dialog_set_artists adap_about_dialog_set_artists
#define adw_about_dialog_set_comments adap_about_dialog_set_comments
#define adw_about_dialog_set_copyright adap_about_dialog_set_copyright
#define adw_about_dialog_set_debug_info adap_about_dialog_set_debug_info
#define adw_about_dialog_set_debug_info_filename adap_about_dialog_set_debug_info_filename
#define adw_about_dialog_set_designers adap_about_dialog_set_designers
#define adw_about_dialog_set_developer_name adap_about_dialog_set_developer_name
#define adw_about_dialog_set_developers adap_about_dialog_set_developers
#define adw_about_dialog_set_documenters adap_about_dialog_set_documenters
#define adw_about_dialog_set_issue_url adap_about_dialog_set_issue_url
#define adw_about_dialog_set_license adap_about_dialog_set_license
#define adw_about_dialog_set_license_type adap_about_dialog_set_license_type
#define adw_about_dialog_set_release_notes adap_about_dialog_set_release_notes
#define adw_about_dialog_set_release_notes_version adap_about_dialog_set_release_notes_version
#define adw_about_dialog_set_support_url adap_about_dialog_set_support_url
#define adw_about_dialog_set_translator_credits adap_about_dialog_set_translator_credits
#define adw_about_dialog_set_version adap_about_dialog_set_version
#define adw_about_dialog_set_website adap_about_dialog_set_website
#define adw_about_window_add_acknowledgement_section adap_about_window_add_acknowledgement_section
#define adw_about_window_add_credit_section adap_about_window_add_credit_section
#define adw_about_window_add_legal_section adap_about_window_add_legal_section
#define adw_about_window_add_link adap_about_window_add_link
#define adw_about_window_get_application_icon adap_about_window_get_application_icon
#define adw_about_window_get_application_name adap_about_window_get_application_name
#define adw_about_window_get_artists adap_about_window_get_artists
#define adw_about_window_get_comments adap_about_window_get_comments
#define adw_about_window_get_copyright adap_about_window_get_copyright
#define adw_about_window_get_debug_info adap_about_window_get_debug_info
#define adw_about_window_get_debug_info_filename adap_about_window_get_debug_info_filename
#define adw_about_window_get_designers adap_about_window_get_designers
#define adw_about_window_get_developer_name adap_about_window_get_developer_name
#define adw_about_window_get_developers adap_about_window_get_developers
#define adw_about_window_get_documenters adap_about_window_get_documenters
#define adw_about_window_get_issue_url adap_about_window_get_issue_url
#define adw_about_window_get_license adap_about_window_get_license
#define adw_about_window_get_license_type adap_about_window_get_license_type
#define adw_about_window_get_release_notes adap_about_window_get_release_notes
#define adw_about_window_get_release_notes_version adap_about_window_get_release_notes_version
#define adw_about_window_get_support_url adap_about_window_get_support_url
#define adw_about_window_get_translator_credits adap_about_window_get_translator_credits
#define adw_about_window_get_type adap_about_window_get_type
#define adw_about_window_get_version adap_about_window_get_version
#define adw_about_window_get_website adap_about_window_get_website
#define adw_about_window_new adap_about_window_new
#define adw_about_window_new_from_appdata adap_about_window_new_from_appdata
#define adw_about_window_set_application_icon adap_about_window_set_application_icon
#define adw_about_window_set_application_name adap_about_window_set_application_name
#define adw_about_window_set_artists adap_about_window_set_artists
#define adw_about_window_set_comments adap_about_window_set_comments
#define adw_about_window_set_copyright adap_about_window_set_copyright
#define adw_about_window_set_debug_info adap_about_window_set_debug_info
#define adw_about_window_set_debug_info_filename adap_about_window_set_debug_info_filename
#define adw_about_window_set_designers adap_about_window_set_designers
#define adw_about_window_set_developer_name adap_about_window_set_developer_name
#define adw_about_window_set_developers adap_about_window_set_developers
#define adw_about_window_set_documenters adap_about_window_set_documenters
#define adw_about_window_set_issue_url adap_about_window_set_issue_url
#define adw_about_window_set_license adap_about_window_set_license
#define adw_about_window_set_license_type adap_about_window_set_license_type
#define adw_about_window_set_release_notes adap_about_window_set_release_notes
#define adw_about_window_set_release_notes_version adap_about_window_set_release_notes_version
#define adw_about_window_set_support_url adap_about_window_set_support_url
#define adw_about_window_set_translator_credits adap_about_window_set_translator_credits
#define adw_about_window_set_version adap_about_window_set_version
#define adw_about_window_set_website adap_about_window_set_website
#define adw_action_row_activate adap_action_row_activate
#define adw_action_row_add_prefix adap_action_row_add_prefix
#define adw_action_row_add_suffix adap_action_row_add_suffix
#define adw_action_row_get_activatable_widget adap_action_row_get_activatable_widget
#define adw_action_row_get_icon_name adap_action_row_get_icon_name
#define adw_action_row_get_subtitle adap_action_row_get_subtitle
#define adw_action_row_get_subtitle_lines adap_action_row_get_subtitle_lines
#define adw_action_row_get_subtitle_selectable adap_action_row_get_subtitle_selectable
#define adw_action_row_get_title_lines adap_action_row_get_title_lines
#define adw_action_row_get_type adap_action_row_get_type
#define adw_action_row_new adap_action_row_new
#define adw_action_row_remove adap_action_row_remove
#define adw_action_row_set_activatable_widget adap_action_row_set_activatable_widget
#define adw_action_row_set_expand_suffixes adap_action_row_set_expand_suffixes
#define adw_action_row_set_icon_name adap_action_row_set_icon_name
#define adw_action_row_set_subtitle adap_action_row_set_subtitle
#define adw_action_row_set_subtitle_lines adap_action_row_set_subtitle_lines
#define adw_action_row_set_subtitle_selectable adap_action_row_set_subtitle_selectable
#define adw_action_row_set_title_lines adap_action_row_set_title_lines
#define adw_alert_dialog_add_response adap_alert_dialog_add_response
#define adw_alert_dialog_add_responses adap_alert_dialog_add_responses
#define adw_alert_dialog_choose adap_alert_dialog_choose
#define adw_alert_dialog_choose_finish adap_alert_dialog_choose_finish
#define adw_alert_dialog_format_body adap_alert_dialog_format_body
#define adw_alert_dialog_format_body_markup adap_alert_dialog_format_body_markup
#define adw_alert_dialog_format_heading adap_alert_dialog_format_heading
#define adw_alert_dialog_format_heading_markup adap_alert_dialog_format_heading_markup
#define adw_alert_dialog_get_body adap_alert_dialog_get_body
#define adw_alert_dialog_get_body_use_markup adap_alert_dialog_get_body_use_markup
#define adw_alert_dialog_get_close_response adap_alert_dialog_get_close_response
#define adw_alert_dialog_get_default_response adap_alert_dialog_get_default_response
#define adw_alert_dialog_get_extra_child adap_alert_dialog_get_extra_child
#define adw_alert_dialog_get_heading adap_alert_dialog_get_heading
#define adw_alert_dialog_get_heading_use_markup adap_alert_dialog_get_heading_use_markup
#define adw_alert_dialog_get_response_appearance adap_alert_dialog_get_response_appearance
#define adw_alert_dialog_get_response_enabled adap_alert_dialog_get_response_enabled
#define adw_alert_dialog_get_response_label adap_alert_dialog_get_response_label
#define adw_alert_dialog_get_type adap_alert_dialog_get_type
#define adw_alert_dialog_has_response adap_alert_dialog_has_response
#define adw_alert_dialog_new adap_alert_dialog_new
#define adw_alert_dialog_remove_response adap_alert_dialog_remove_response
#define adw_alert_dialog_set_body adap_alert_dialog_set_body
#define adw_alert_dialog_set_body_use_markup adap_alert_dialog_set_body_use_markup
#define adw_alert_dialog_set_close_response adap_alert_dialog_set_close_response
#define adw_alert_dialog_set_default_response adap_alert_dialog_set_default_response
#define adw_alert_dialog_set_extra_child adap_alert_dialog_set_extra_child
#define adw_alert_dialog_set_heading adap_alert_dialog_set_heading
#define adw_alert_dialog_set_heading_use_markup adap_alert_dialog_set_heading_use_markup
#define adw_alert_dialog_set_response_appearance adap_alert_dialog_set_response_appearance
#define adw_alert_dialog_set_response_enabled adap_alert_dialog_set_response_enabled
#define adw_alert_dialog_set_response_label adap_alert_dialog_set_response_label
#define adw_animation_get_follow_enable_animations_setting adap_animation_get_follow_enable_animations_setting
#define adw_animation_get_state adap_animation_get_state
#define adw_animation_get_target adap_animation_get_target
#define adw_animation_get_type adap_animation_get_type
#define adw_animation_get_value adap_animation_get_value
#define adw_animation_get_widget adap_animation_get_widget
#define adw_animation_pause adap_animation_pause
#define adw_animation_play adap_animation_play
#define adw_animation_reset adap_animation_reset
#define adw_animation_resume adap_animation_resume
#define adw_animation_set_follow_enable_animations_setting adap_animation_set_follow_enable_animations_setting
#define adw_animation_set_target adap_animation_set_target
#define adw_animation_skip adap_animation_skip
#define adw_animation_target_get_type adap_animation_target_get_type
#define adw_animation_target_set_value adap_animation_target_set_value
#define adw_application_get_style_manager adap_application_get_style_manager
#define adw_application_get_type adap_application_get_type
#define adw_application_new adap_application_new
#define adw_application_window_add_breakpoint adap_application_window_add_breakpoint
#define adw_application_window_get_content adap_application_window_get_content
#define adw_application_window_get_current_breakpoint adap_application_window_get_current_breakpoint
#define adw_application_window_get_dialogs adap_application_window_get_dialogs
#define adw_application_window_get_type adap_application_window_get_type
#define adw_application_window_get_visible_dialog adap_application_window_get_visible_dialog
#define adw_application_window_new adap_application_window_new
#define adw_application_window_set_content adap_application_window_set_content
#define adw_avatar_draw_to_texture adap_avatar_draw_to_texture
#define adw_avatar_get_custom_image adap_avatar_get_custom_image
#define adw_avatar_get_icon_name adap_avatar_get_icon_name
#define adw_avatar_get_show_initials adap_avatar_get_show_initials
#define adw_avatar_get_size adap_avatar_get_size
#define adw_avatar_get_text adap_avatar_get_text
#define adw_avatar_get_type adap_avatar_get_type
#define adw_avatar_new adap_avatar_new
#define adw_avatar_set_custom_image adap_avatar_set_custom_image
#define adw_avatar_set_icon_name adap_avatar_set_icon_name
#define adw_avatar_set_show_initials adap_avatar_set_show_initials
#define adw_avatar_set_size adap_avatar_set_size
#define adw_avatar_set_text adap_avatar_set_text
#define adw_back_button_get_type adap_back_button_get_type
#define adw_back_button_new adap_back_button_new
#define adw_banner_get_button_label adap_banner_get_button_label
#define adw_banner_get_revealed adap_banner_get_revealed
#define adw_banner_get_title adap_banner_get_title
#define adw_banner_get_type adap_banner_get_type
#define adw_banner_get_use_markup adap_banner_get_use_markup
#define adw_banner_new adap_banner_new
#define adw_banner_set_button_label adap_banner_set_button_label
#define adw_banner_set_revealed adap_banner_set_revealed
#define adw_banner_set_title adap_banner_set_title
#define adw_banner_set_use_markup adap_banner_set_use_markup
#define adw_bin_get_child adap_bin_get_child
#define adw_bin_get_type adap_bin_get_type
#define adw_bin_new adap_bin_new
#define adw_bin_set_child adap_bin_set_child
#define adw_bottom_sheet_get_align adap_bottom_sheet_get_align
#define adw_bottom_sheet_get_can_close adap_bottom_sheet_get_can_close
#define adw_bottom_sheet_get_child adap_bottom_sheet_get_child
#define adw_bottom_sheet_get_modal adap_bottom_sheet_get_modal
#define adw_bottom_sheet_get_open adap_bottom_sheet_get_open
#define adw_bottom_sheet_get_sheet adap_bottom_sheet_get_sheet
#define adw_bottom_sheet_get_sheet_bin adap_bottom_sheet_get_sheet_bin
#define adw_bottom_sheet_get_show_drag_handle adap_bottom_sheet_get_show_drag_handle
#define adw_bottom_sheet_get_type adap_bottom_sheet_get_type
#define adw_bottom_sheet_new adap_bottom_sheet_new
#define adw_bottom_sheet_set_align adap_bottom_sheet_set_align
#define adw_bottom_sheet_set_can_close adap_bottom_sheet_set_can_close
#define adw_bottom_sheet_set_child adap_bottom_sheet_set_child
#define adw_bottom_sheet_set_min_natural_width adap_bottom_sheet_set_min_natural_width
#define adw_bottom_sheet_set_modal adap_bottom_sheet_set_modal
#define adw_bottom_sheet_set_open adap_bottom_sheet_set_open
#define adw_bottom_sheet_set_sheet adap_bottom_sheet_set_sheet
#define adw_bottom_sheet_set_show_drag_handle adap_bottom_sheet_set_show_drag_handle
#define adw_breakpoint_add_setter adap_breakpoint_add_setter
#define adw_breakpoint_add_setters adap_breakpoint_add_setters
#define adw_breakpoint_add_setters_valist adap_breakpoint_add_setters_valist
#define adw_breakpoint_add_settersv adap_breakpoint_add_settersv
#define adw_breakpoint_bin_add_breakpoint adap_breakpoint_bin_add_breakpoint
#define adw_breakpoint_bin_get_child adap_breakpoint_bin_get_child
#define adw_breakpoint_bin_get_current_breakpoint adap_breakpoint_bin_get_current_breakpoint
#define adw_breakpoint_bin_get_type adap_breakpoint_bin_get_type
#define adw_breakpoint_bin_has_breakpoints adap_breakpoint_bin_has_breakpoints
#define adw_breakpoint_bin_new adap_breakpoint_bin_new
#define adw_breakpoint_bin_remove_breakpoint adap_breakpoint_bin_remove_breakpoint
#define adw_breakpoint_bin_set_child adap_breakpoint_bin_set_child
#define adw_breakpoint_bin_set_natural_size adap_breakpoint_bin_set_natural_size
#define adw_breakpoint_bin_set_pass_through adap_breakpoint_bin_set_pass_through
#define adw_breakpoint_bin_set_warning_widget adap_breakpoint_bin_set_warning_widget
#define adw_breakpoint_bin_set_warnings adap_breakpoint_bin_set_warnings
#define adw_breakpoint_check_condition adap_breakpoint_check_condition
#define adw_breakpoint_condition_copy adap_breakpoint_condition_copy
#define adw_breakpoint_condition_free adap_breakpoint_condition_free
#define adw_breakpoint_condition_get_type adap_breakpoint_condition_get_type
#define adw_breakpoint_condition_new_and adap_breakpoint_condition_new_and
#define adw_breakpoint_condition_new_length adap_breakpoint_condition_new_length
#define adw_breakpoint_condition_new_or adap_breakpoint_condition_new_or
#define adw_breakpoint_condition_new_ratio adap_breakpoint_condition_new_ratio
#define adw_breakpoint_condition_parse adap_breakpoint_condition_parse
#define adw_breakpoint_condition_to_string adap_breakpoint_condition_to_string
#define adw_breakpoint_get_condition adap_breakpoint_get_condition
#define adw_breakpoint_get_type adap_breakpoint_get_type
#define adw_breakpoint_new adap_breakpoint_new
#define adw_breakpoint_set_condition adap_breakpoint_set_condition
#define adw_breakpoint_transition adap_breakpoint_transition
#define adw_button_content_get_can_shrink adap_button_content_get_can_shrink
#define adw_button_content_get_icon_name adap_button_content_get_icon_name
#define adw_button_content_get_label adap_button_content_get_label
#define adw_button_content_get_type adap_button_content_get_type
#define adw_button_content_get_use_underline adap_button_content_get_use_underline
#define adw_button_content_new adap_button_content_new
#define adw_button_content_set_can_shrink adap_button_content_set_can_shrink
#define adw_button_content_set_icon_name adap_button_content_set_icon_name
#define adw_button_content_set_label adap_button_content_set_label
#define adw_button_content_set_use_underline adap_button_content_set_use_underline
#define adw_callback_animation_target_get_type adap_callback_animation_target_get_type
#define adw_callback_animation_target_new adap_callback_animation_target_new
#define adw_carousel_append adap_carousel_append
#define adw_carousel_get_allow_long_swipes adap_carousel_get_allow_long_swipes
#define adw_carousel_get_allow_mouse_drag adap_carousel_get_allow_mouse_drag
#define adw_carousel_get_allow_scroll_wheel adap_carousel_get_allow_scroll_wheel
#define adw_carousel_get_interactive adap_carousel_get_interactive
#define adw_carousel_get_n_pages adap_carousel_get_n_pages
#define adw_carousel_get_nth_page adap_carousel_get_nth_page
#define adw_carousel_get_position adap_carousel_get_position
#define adw_carousel_get_reveal_duration adap_carousel_get_reveal_duration
#define adw_carousel_get_scroll_params adap_carousel_get_scroll_params
#define adw_carousel_get_spacing adap_carousel_get_spacing
#define adw_carousel_get_type adap_carousel_get_type
#define adw_carousel_indicator_dots_get_carousel adap_carousel_indicator_dots_get_carousel
#define adw_carousel_indicator_dots_get_type adap_carousel_indicator_dots_get_type
#define adw_carousel_indicator_dots_new adap_carousel_indicator_dots_new
#define adw_carousel_indicator_dots_set_carousel adap_carousel_indicator_dots_set_carousel
#define adw_carousel_indicator_lines_get_carousel adap_carousel_indicator_lines_get_carousel
#define adw_carousel_indicator_lines_get_type adap_carousel_indicator_lines_get_type
#define adw_carousel_indicator_lines_new adap_carousel_indicator_lines_new
#define adw_carousel_indicator_lines_set_carousel adap_carousel_indicator_lines_set_carousel
#define adw_carousel_insert adap_carousel_insert
#define adw_carousel_new adap_carousel_new
#define adw_carousel_prepend adap_carousel_prepend
#define adw_carousel_remove adap_carousel_remove
#define adw_carousel_reorder adap_carousel_reorder
#define adw_carousel_scroll_to adap_carousel_scroll_to
#define adw_carousel_set_allow_long_swipes adap_carousel_set_allow_long_swipes
#define adw_carousel_set_allow_mouse_drag adap_carousel_set_allow_mouse_drag
#define adw_carousel_set_allow_scroll_wheel adap_carousel_set_allow_scroll_wheel
#define adw_carousel_set_interactive adap_carousel_set_interactive
#define adw_carousel_set_reveal_duration adap_carousel_set_reveal_duration
#define adw_carousel_set_scroll_params adap_carousel_set_scroll_params
#define adw_carousel_set_spacing adap_carousel_set_spacing
#define adw_clamp_get_child adap_clamp_get_child
#define adw_clamp_get_maximum_size adap_clamp_get_maximum_size
#define adw_clamp_get_tightening_threshold adap_clamp_get_tightening_threshold
#define adw_clamp_get_type adap_clamp_get_type
#define adw_clamp_get_unit adap_clamp_get_unit
#define adw_clamp_layout_get_maximum_size adap_clamp_layout_get_maximum_size
#define adw_clamp_layout_get_tightening_threshold adap_clamp_layout_get_tightening_threshold
#define adw_clamp_layout_get_type adap_clamp_layout_get_type
#define adw_clamp_layout_get_unit adap_clamp_layout_get_unit
#define adw_clamp_layout_new adap_clamp_layout_new
#define adw_clamp_layout_set_maximum_size adap_clamp_layout_set_maximum_size
#define adw_clamp_layout_set_tightening_threshold adap_clamp_layout_set_tightening_threshold
#define adw_clamp_layout_set_unit adap_clamp_layout_set_unit
#define adw_clamp_new adap_clamp_new
#define adw_clamp_scrollable_get_child adap_clamp_scrollable_get_child
#define adw_clamp_scrollable_get_maximum_size adap_clamp_scrollable_get_maximum_size
#define adw_clamp_scrollable_get_tightening_threshold adap_clamp_scrollable_get_tightening_threshold
#define adw_clamp_scrollable_get_type adap_clamp_scrollable_get_type
#define adw_clamp_scrollable_get_unit adap_clamp_scrollable_get_unit
#define adw_clamp_scrollable_new adap_clamp_scrollable_new
#define adw_clamp_scrollable_set_child adap_clamp_scrollable_set_child
#define adw_clamp_scrollable_set_maximum_size adap_clamp_scrollable_set_maximum_size
#define adw_clamp_scrollable_set_tightening_threshold adap_clamp_scrollable_set_tightening_threshold
#define adw_clamp_scrollable_set_unit adap_clamp_scrollable_set_unit
#define adw_clamp_set_child adap_clamp_set_child
#define adw_clamp_set_maximum_size adap_clamp_set_maximum_size
#define adw_clamp_set_tightening_threshold adap_clamp_set_tightening_threshold
#define adw_clamp_set_unit adap_clamp_set_unit
#define adw_combo_row_get_enable_search adap_combo_row_get_enable_search
#define adw_combo_row_get_expression adap_combo_row_get_expression
#define adw_combo_row_get_factory adap_combo_row_get_factory
#define adw_combo_row_get_list_factory adap_combo_row_get_list_factory
#define adw_combo_row_get_model adap_combo_row_get_model
#define adw_combo_row_get_selected adap_combo_row_get_selected
#define adw_combo_row_get_selected_item adap_combo_row_get_selected_item
#define adw_combo_row_get_type adap_combo_row_get_type
#define adw_combo_row_get_use_subtitle adap_combo_row_get_use_subtitle
#define adw_combo_row_new adap_combo_row_new
#define adw_combo_row_set_enable_search adap_combo_row_set_enable_search
#define adw_combo_row_set_expression adap_combo_row_set_expression
#define adw_combo_row_set_factory adap_combo_row_set_factory
#define adw_combo_row_set_list_factory adap_combo_row_set_list_factory
#define adw_combo_row_set_model adap_combo_row_set_model
#define adw_combo_row_set_selected adap_combo_row_set_selected
#define adw_combo_row_set_use_subtitle adap_combo_row_set_use_subtitle
#define adw_decoration_layout_prefers_start adap_decoration_layout_prefers_start
#define adw_demo_generate_debug_info adap_demo_generate_debug_info
#define adw_demo_page_about_get_type adap_demo_page_about_get_type
#define adw_demo_page_animations_get_type adap_demo_page_animations_get_type
#define adw_demo_page_avatar_get_type adap_demo_page_avatar_get_type
#define adw_demo_page_banners_get_type adap_demo_page_banners_get_type
#define adw_demo_page_buttons_get_type adap_demo_page_buttons_get_type
#define adw_demo_page_carousel_get_type adap_demo_page_carousel_get_type
#define adw_demo_page_clamp_get_type adap_demo_page_clamp_get_type
#define adw_demo_page_dialogs_get_type adap_demo_page_dialogs_get_type
#define adw_demo_page_lists_get_type adap_demo_page_lists_get_type
#define adw_demo_page_navigation_view_get_type adap_demo_page_navigation_view_get_type
#define adw_demo_page_split_views_get_type adap_demo_page_split_views_get_type
#define adw_demo_page_styles_get_type adap_demo_page_styles_get_type
#define adw_demo_page_tab_view_get_type adap_demo_page_tab_view_get_type
#define adw_demo_page_toasts_get_type adap_demo_page_toasts_get_type
#define adw_demo_page_toasts_undo adap_demo_page_toasts_undo
#define adw_demo_page_view_switcher_get_type adap_demo_page_view_switcher_get_type
#define adw_demo_page_welcome_get_type adap_demo_page_welcome_get_type
#define adw_demo_preferences_window_get_type adap_demo_preferences_window_get_type
#define adw_demo_preferences_window_new adap_demo_preferences_window_new
#define adw_demo_window_get_type adap_demo_window_get_type
#define adw_demo_window_new adap_demo_window_new
#define adw_dialog_add_breakpoint adap_dialog_add_breakpoint
#define adw_dialog_close adap_dialog_close
#define adw_dialog_force_close adap_dialog_force_close
#define adw_dialog_get_can_close adap_dialog_get_can_close
#define adw_dialog_get_child adap_dialog_get_child
#define adw_dialog_get_closing adap_dialog_get_closing
#define adw_dialog_get_content_height adap_dialog_get_content_height
#define adw_dialog_get_content_width adap_dialog_get_content_width
#define adw_dialog_get_current_breakpoint adap_dialog_get_current_breakpoint
#define adw_dialog_get_default_widget adap_dialog_get_default_widget
#define adw_dialog_get_focus adap_dialog_get_focus
#define adw_dialog_get_follows_content_size adap_dialog_get_follows_content_size
#define adw_dialog_get_presentation_mode adap_dialog_get_presentation_mode
#define adw_dialog_get_title adap_dialog_get_title
#define adw_dialog_get_type adap_dialog_get_type
#define adw_dialog_get_window adap_dialog_get_window
#define adw_dialog_host_get_child adap_dialog_host_get_child
#define adw_dialog_host_get_dialogs adap_dialog_host_get_dialogs
#define adw_dialog_host_get_from_proxy adap_dialog_host_get_from_proxy
#define adw_dialog_host_get_proxy adap_dialog_host_get_proxy
#define adw_dialog_host_get_type adap_dialog_host_get_type
#define adw_dialog_host_get_visible_dialog adap_dialog_host_get_visible_dialog
#define adw_dialog_host_new adap_dialog_host_new
#define adw_dialog_host_present_dialog adap_dialog_host_present_dialog
#define adw_dialog_host_set_child adap_dialog_host_set_child
#define adw_dialog_host_set_proxy adap_dialog_host_set_proxy
#define adw_dialog_new adap_dialog_new
#define adw_dialog_present adap_dialog_present
#define adw_dialog_set_callbacks adap_dialog_set_callbacks
#define adw_dialog_set_can_close adap_dialog_set_can_close
#define adw_dialog_set_child adap_dialog_set_child
#define adw_dialog_set_closing adap_dialog_set_closing
#define adw_dialog_set_content_height adap_dialog_set_content_height
#define adw_dialog_set_content_width adap_dialog_set_content_width
#define adw_dialog_set_default_widget adap_dialog_set_default_widget
#define adw_dialog_set_focus adap_dialog_set_focus
#define adw_dialog_set_follows_content_size adap_dialog_set_follows_content_size
#define adw_dialog_set_presentation_mode adap_dialog_set_presentation_mode
#define adw_dialog_set_shadowed adap_dialog_set_shadowed
#define adw_dialog_set_title adap_dialog_set_title
#define adw_easing_ease adap_easing_ease
#define adw_entry_row_add_prefix adap_entry_row_add_prefix
#define adw_entry_row_add_suffix adap_entry_row_add_suffix
#define adw_entry_row_get_activates_default adap_entry_row_get_activates_default
#define adw_entry_row_get_attributes adap_entry_row_get_attributes
#define adw_entry_row_get_enable_emoji_completion adap_entry_row_get_enable_emoji_completion
#define adw_entry_row_get_input_hints adap_entry_row_get_input_hints
#define adw_entry_row_get_input_purpose adap_entry_row_get_input_purpose
#define adw_entry_row_get_show_apply_button adap_entry_row_get_show_apply_button
#define adw_entry_row_get_text_length adap_entry_row_get_text_length
#define adw_entry_row_get_type adap_entry_row_get_type
#define adw_entry_row_grab_focus_without_selecting adap_entry_row_grab_focus_without_selecting
#define adw_entry_row_new adap_entry_row_new
#define adw_entry_row_remove adap_entry_row_remove
#define adw_entry_row_set_activates_default adap_entry_row_set_activates_default
#define adw_entry_row_set_attributes adap_entry_row_set_attributes
#define adw_entry_row_set_enable_emoji_completion adap_entry_row_set_enable_emoji_completion
#define adw_entry_row_set_indicator_icon_name adap_entry_row_set_indicator_icon_name
#define adw_entry_row_set_indicator_tooltip adap_entry_row_set_indicator_tooltip
#define adw_entry_row_set_input_hints adap_entry_row_set_input_hints
#define adw_entry_row_set_input_purpose adap_entry_row_set_input_purpose
#define adw_entry_row_set_show_apply_button adap_entry_row_set_show_apply_button
#define adw_entry_row_set_show_indicator adap_entry_row_set_show_indicator
#define adw_enum_list_item_get_name adap_enum_list_item_get_name
#define adw_enum_list_item_get_nick adap_enum_list_item_get_nick
#define adw_enum_list_item_get_type adap_enum_list_item_get_type
#define adw_enum_list_item_get_value adap_enum_list_item_get_value
#define adw_enum_list_model_find_position adap_enum_list_model_find_position
#define adw_enum_list_model_get_enum_type adap_enum_list_model_get_enum_type
#define adw_enum_list_model_get_type adap_enum_list_model_get_type
#define adw_enum_list_model_new adap_enum_list_model_new
#define adw_expander_row_add_action adap_expander_row_add_action
#define adw_expander_row_add_prefix adap_expander_row_add_prefix
#define adw_expander_row_add_row adap_expander_row_add_row
#define adw_expander_row_add_suffix adap_expander_row_add_suffix
#define adw_expander_row_get_enable_expansion adap_expander_row_get_enable_expansion
#define adw_expander_row_get_expanded adap_expander_row_get_expanded
#define adw_expander_row_get_icon_name adap_expander_row_get_icon_name
#define adw_expander_row_get_show_enable_switch adap_expander_row_get_show_enable_switch
#define adw_expander_row_get_subtitle adap_expander_row_get_subtitle
#define adw_expander_row_get_subtitle_lines adap_expander_row_get_subtitle_lines
#define adw_expander_row_get_title_lines adap_expander_row_get_title_lines
#define adw_expander_row_get_type adap_expander_row_get_type
#define adw_expander_row_new adap_expander_row_new
#define adw_expander_row_remove adap_expander_row_remove
#define adw_expander_row_set_enable_expansion adap_expander_row_set_enable_expansion
#define adw_expander_row_set_expanded adap_expander_row_set_expanded
#define adw_expander_row_set_icon_name adap_expander_row_set_icon_name
#define adw_expander_row_set_show_enable_switch adap_expander_row_set_show_enable_switch
#define adw_expander_row_set_subtitle adap_expander_row_set_subtitle
#define adw_expander_row_set_subtitle_lines adap_expander_row_set_subtitle_lines
#define adw_expander_row_set_title_lines adap_expander_row_set_title_lines
#define adw_fading_label_get_align adap_fading_label_get_align
#define adw_fading_label_get_label adap_fading_label_get_label
#define adw_fading_label_get_type adap_fading_label_get_type
#define adw_fading_label_set_align adap_fading_label_set_align
#define adw_fading_label_set_label adap_fading_label_set_label
#define adw_find_base_dir adap_find_base_dir
#define adw_flap_get_content adap_flap_get_content
#define adw_flap_get_flap adap_flap_get_flap
#define adw_flap_get_flap_position adap_flap_get_flap_position
#define adw_flap_get_fold_duration adap_flap_get_fold_duration
#define adw_flap_get_fold_policy adap_flap_get_fold_policy
#define adw_flap_get_fold_threshold_policy adap_flap_get_fold_threshold_policy
#define adw_flap_get_folded adap_flap_get_folded
#define adw_flap_get_locked adap_flap_get_locked
#define adw_flap_get_modal adap_flap_get_modal
#define adw_flap_get_reveal_flap adap_flap_get_reveal_flap
#define adw_flap_get_reveal_params adap_flap_get_reveal_params
#define adw_flap_get_reveal_progress adap_flap_get_reveal_progress
#define adw_flap_get_separator adap_flap_get_separator
#define adw_flap_get_swipe_to_close adap_flap_get_swipe_to_close
#define adw_flap_get_swipe_to_open adap_flap_get_swipe_to_open
#define adw_flap_get_transition_type adap_flap_get_transition_type
#define adw_flap_get_type adap_flap_get_type
#define adw_flap_new adap_flap_new
#define adw_flap_set_content adap_flap_set_content
#define adw_flap_set_flap adap_flap_set_flap
#define adw_flap_set_flap_position adap_flap_set_flap_position
#define adw_flap_set_fold_duration adap_flap_set_fold_duration
#define adw_flap_set_fold_policy adap_flap_set_fold_policy
#define adw_flap_set_fold_threshold_policy adap_flap_set_fold_threshold_policy
#define adw_flap_set_locked adap_flap_set_locked
#define adw_flap_set_modal adap_flap_set_modal
#define adw_flap_set_reveal_flap adap_flap_set_reveal_flap
#define adw_flap_set_reveal_params adap_flap_set_reveal_params
#define adw_flap_set_separator adap_flap_set_separator
#define adw_flap_set_swipe_to_close adap_flap_set_swipe_to_close
#define adw_flap_set_swipe_to_open adap_flap_set_swipe_to_open
#define adw_flap_set_transition_type adap_flap_set_transition_type
#define adw_floating_sheet_get_can_close adap_floating_sheet_get_can_close
#define adw_floating_sheet_get_child adap_floating_sheet_get_child
#define adw_floating_sheet_get_open adap_floating_sheet_get_open
#define adw_floating_sheet_get_sheet_bin adap_floating_sheet_get_sheet_bin
#define adw_floating_sheet_get_type adap_floating_sheet_get_type
#define adw_floating_sheet_new adap_floating_sheet_new
#define adw_floating_sheet_set_can_close adap_floating_sheet_set_can_close
#define adw_floating_sheet_set_child adap_floating_sheet_set_child
#define adw_floating_sheet_set_open adap_floating_sheet_set_open
#define adw_get_disable_portal adap_get_disable_portal
#define adw_get_enable_animations adap_get_enable_animations
#define adw_gizmo_get_type adap_gizmo_get_type
#define adw_gizmo_new adap_gizmo_new
#define adw_gizmo_new_with_role adap_gizmo_new_with_role
#define adw_gizmo_set_allocate_func adap_gizmo_set_allocate_func
#define adw_gizmo_set_contains_func adap_gizmo_set_contains_func
#define adw_gizmo_set_focus_func adap_gizmo_set_focus_func
#define adw_gizmo_set_grab_focus_func adap_gizmo_set_grab_focus_func
#define adw_gizmo_set_measure_func adap_gizmo_set_measure_func
#define adw_gizmo_set_snapshot_func adap_gizmo_set_snapshot_func
#define adw_header_bar_get_centering_policy adap_header_bar_get_centering_policy
#define adw_header_bar_get_decoration_layout adap_header_bar_get_decoration_layout
#define adw_header_bar_get_show_back_button adap_header_bar_get_show_back_button
#define adw_header_bar_get_show_end_title_buttons adap_header_bar_get_show_end_title_buttons
#define adw_header_bar_get_show_start_title_buttons adap_header_bar_get_show_start_title_buttons
#define adw_header_bar_get_show_title adap_header_bar_get_show_title
#define adw_header_bar_get_title_widget adap_header_bar_get_title_widget
#define adw_header_bar_get_type adap_header_bar_get_type
#define adw_header_bar_new adap_header_bar_new
#define adw_header_bar_pack_end adap_header_bar_pack_end
#define adw_header_bar_pack_start adap_header_bar_pack_start
#define adw_header_bar_remove adap_header_bar_remove
#define adw_header_bar_set_centering_policy adap_header_bar_set_centering_policy
#define adw_header_bar_set_decoration_layout adap_header_bar_set_decoration_layout
#define adw_header_bar_set_show_back_button adap_header_bar_set_show_back_button
#define adw_header_bar_set_show_end_title_buttons adap_header_bar_set_show_end_title_buttons
#define adw_header_bar_set_show_start_title_buttons adap_header_bar_set_show_start_title_buttons
#define adw_header_bar_set_show_title adap_header_bar_set_show_title
#define adw_header_bar_set_title_widget adap_header_bar_set_title_widget
#define adw_indicator_bin_get_badge adap_indicator_bin_get_badge
#define adw_indicator_bin_get_child adap_indicator_bin_get_child
#define adw_indicator_bin_get_needs_attention adap_indicator_bin_get_needs_attention
#define adw_indicator_bin_get_type adap_indicator_bin_get_type
#define adw_indicator_bin_new adap_indicator_bin_new
#define adw_indicator_bin_set_badge adap_indicator_bin_set_badge
#define adw_indicator_bin_set_child adap_indicator_bin_set_child
#define adw_indicator_bin_set_needs_attention adap_indicator_bin_set_needs_attention
#define adw_init adap_init
#define adw_init_public_types adap_init_public_types
#define adw_inspector_page_get_type adap_inspector_page_get_type
#define adw_is_granite_present adap_is_granite_present
#define adw_is_initialized adap_is_initialized
#define adw_leaflet_append adap_leaflet_append
#define adw_leaflet_get_adjacent_child adap_leaflet_get_adjacent_child
#define adw_leaflet_get_can_navigate_back adap_leaflet_get_can_navigate_back
#define adw_leaflet_get_can_navigate_forward adap_leaflet_get_can_navigate_forward
#define adw_leaflet_get_can_unfold adap_leaflet_get_can_unfold
#define adw_leaflet_get_child_by_name adap_leaflet_get_child_by_name
#define adw_leaflet_get_child_transition_params adap_leaflet_get_child_transition_params
#define adw_leaflet_get_child_transition_running adap_leaflet_get_child_transition_running
#define adw_leaflet_get_fold_threshold_policy adap_leaflet_get_fold_threshold_policy
#define adw_leaflet_get_folded adap_leaflet_get_folded
#define adw_leaflet_get_homogeneous adap_leaflet_get_homogeneous
#define adw_leaflet_get_mode_transition_duration adap_leaflet_get_mode_transition_duration
#define adw_leaflet_get_page adap_leaflet_get_page
#define adw_leaflet_get_pages adap_leaflet_get_pages
#define adw_leaflet_get_transition_type adap_leaflet_get_transition_type
#define adw_leaflet_get_type adap_leaflet_get_type
#define adw_leaflet_get_visible_child adap_leaflet_get_visible_child
#define adw_leaflet_get_visible_child_name adap_leaflet_get_visible_child_name
#define adw_leaflet_insert_child_after adap_leaflet_insert_child_after
#define adw_leaflet_navigate adap_leaflet_navigate
#define adw_leaflet_new adap_leaflet_new
#define adw_leaflet_page_get_child adap_leaflet_page_get_child
#define adw_leaflet_page_get_name adap_leaflet_page_get_name
#define adw_leaflet_page_get_navigatable adap_leaflet_page_get_navigatable
#define adw_leaflet_page_get_type adap_leaflet_page_get_type
#define adw_leaflet_page_set_name adap_leaflet_page_set_name
#define adw_leaflet_page_set_navigatable adap_leaflet_page_set_navigatable
#define adw_leaflet_prepend adap_leaflet_prepend
#define adw_leaflet_remove adap_leaflet_remove
#define adw_leaflet_reorder_child_after adap_leaflet_reorder_child_after
#define adw_leaflet_set_can_navigate_back adap_leaflet_set_can_navigate_back
#define adw_leaflet_set_can_navigate_forward adap_leaflet_set_can_navigate_forward
#define adw_leaflet_set_can_unfold adap_leaflet_set_can_unfold
#define adw_leaflet_set_child_transition_params adap_leaflet_set_child_transition_params
#define adw_leaflet_set_fold_threshold_policy adap_leaflet_set_fold_threshold_policy
#define adw_leaflet_set_homogeneous adap_leaflet_set_homogeneous
#define adw_leaflet_set_mode_transition_duration adap_leaflet_set_mode_transition_duration
#define adw_leaflet_set_transition_type adap_leaflet_set_transition_type
#define adw_leaflet_set_visible_child adap_leaflet_set_visible_child
#define adw_leaflet_set_visible_child_name adap_leaflet_set_visible_child_name
#define adw_length_unit_from_px adap_length_unit_from_px
#define adw_length_unit_to_px adap_length_unit_to_px
#define adw_lerp adap_lerp
#define adw_message_dialog_add_response adap_message_dialog_add_response
#define adw_message_dialog_add_responses adap_message_dialog_add_responses
#define adw_message_dialog_choose adap_message_dialog_choose
#define adw_message_dialog_choose_finish adap_message_dialog_choose_finish
#define adw_message_dialog_format_body adap_message_dialog_format_body
#define adw_message_dialog_format_body_markup adap_message_dialog_format_body_markup
#define adw_message_dialog_format_heading adap_message_dialog_format_heading
#define adw_message_dialog_format_heading_markup adap_message_dialog_format_heading_markup
#define adw_message_dialog_get_body adap_message_dialog_get_body
#define adw_message_dialog_get_body_use_markup adap_message_dialog_get_body_use_markup
#define adw_message_dialog_get_close_response adap_message_dialog_get_close_response
#define adw_message_dialog_get_default_response adap_message_dialog_get_default_response
#define adw_message_dialog_get_extra_child adap_message_dialog_get_extra_child
#define adw_message_dialog_get_heading adap_message_dialog_get_heading
#define adw_message_dialog_get_heading_use_markup adap_message_dialog_get_heading_use_markup
#define adw_message_dialog_get_response_appearance adap_message_dialog_get_response_appearance
#define adw_message_dialog_get_response_enabled adap_message_dialog_get_response_enabled
#define adw_message_dialog_get_response_label adap_message_dialog_get_response_label
#define adw_message_dialog_get_type adap_message_dialog_get_type
#define adw_message_dialog_has_response adap_message_dialog_has_response
#define adw_message_dialog_new adap_message_dialog_new
#define adw_message_dialog_remove_response adap_message_dialog_remove_response
#define adw_message_dialog_response adap_message_dialog_response
#define adw_message_dialog_set_body adap_message_dialog_set_body
#define adw_message_dialog_set_body_use_markup adap_message_dialog_set_body_use_markup
#define adw_message_dialog_set_close_response adap_message_dialog_set_close_response
#define adw_message_dialog_set_default_response adap_message_dialog_set_default_response
#define adw_message_dialog_set_extra_child adap_message_dialog_set_extra_child
#define adw_message_dialog_set_heading adap_message_dialog_set_heading
#define adw_message_dialog_set_heading_use_markup adap_message_dialog_set_heading_use_markup
#define adw_message_dialog_set_response_appearance adap_message_dialog_set_response_appearance
#define adw_message_dialog_set_response_enabled adap_message_dialog_set_response_enabled
#define adw_message_dialog_set_response_label adap_message_dialog_set_response_label
#define adw_navigation_page_add_child_nav_split_view adap_navigation_page_add_child_nav_split_view
#define adw_navigation_page_block_signals adap_navigation_page_block_signals
#define adw_navigation_page_get_can_pop adap_navigation_page_get_can_pop
#define adw_navigation_page_get_child adap_navigation_page_get_child
#define adw_navigation_page_get_child_view adap_navigation_page_get_child_view
#define adw_navigation_page_get_tag adap_navigation_page_get_tag
#define adw_navigation_page_get_title adap_navigation_page_get_title
#define adw_navigation_page_get_type adap_navigation_page_get_type
#define adw_navigation_page_hidden adap_navigation_page_hidden
#define adw_navigation_page_hiding adap_navigation_page_hiding
#define adw_navigation_page_new adap_navigation_page_new
#define adw_navigation_page_new_with_tag adap_navigation_page_new_with_tag
#define adw_navigation_page_remove_child_nav_split_view adap_navigation_page_remove_child_nav_split_view
#define adw_navigation_page_set_can_pop adap_navigation_page_set_can_pop
#define adw_navigation_page_set_child adap_navigation_page_set_child
#define adw_navigation_page_set_tag adap_navigation_page_set_tag
#define adw_navigation_page_set_title adap_navigation_page_set_title
#define adw_navigation_page_showing adap_navigation_page_showing
#define adw_navigation_page_shown adap_navigation_page_shown
#define adw_navigation_page_unblock_signals adap_navigation_page_unblock_signals
#define adw_navigation_split_view_demo_window_get_type adap_navigation_split_view_demo_window_get_type
#define adw_navigation_split_view_demo_window_new adap_navigation_split_view_demo_window_new
#define adw_navigation_split_view_get_collapsed adap_navigation_split_view_get_collapsed
#define adw_navigation_split_view_get_content adap_navigation_split_view_get_content
#define adw_navigation_split_view_get_max_sidebar_width adap_navigation_split_view_get_max_sidebar_width
#define adw_navigation_split_view_get_min_sidebar_width adap_navigation_split_view_get_min_sidebar_width
#define adw_navigation_split_view_get_show_content adap_navigation_split_view_get_show_content
#define adw_navigation_split_view_get_sidebar adap_navigation_split_view_get_sidebar
#define adw_navigation_split_view_get_sidebar_width_fraction adap_navigation_split_view_get_sidebar_width_fraction
#define adw_navigation_split_view_get_sidebar_width_unit adap_navigation_split_view_get_sidebar_width_unit
#define adw_navigation_split_view_get_type adap_navigation_split_view_get_type
#define adw_navigation_split_view_new adap_navigation_split_view_new
#define adw_navigation_split_view_set_collapsed adap_navigation_split_view_set_collapsed
#define adw_navigation_split_view_set_content adap_navigation_split_view_set_content
#define adw_navigation_split_view_set_max_sidebar_width adap_navigation_split_view_set_max_sidebar_width
#define adw_navigation_split_view_set_min_sidebar_width adap_navigation_split_view_set_min_sidebar_width
#define adw_navigation_split_view_set_show_content adap_navigation_split_view_set_show_content
#define adw_navigation_split_view_set_sidebar adap_navigation_split_view_set_sidebar
#define adw_navigation_split_view_set_sidebar_width_fraction adap_navigation_split_view_set_sidebar_width_fraction
#define adw_navigation_split_view_set_sidebar_width_unit adap_navigation_split_view_set_sidebar_width_unit
#define adw_navigation_view_add adap_navigation_view_add
#define adw_navigation_view_demo_window_get_type adap_navigation_view_demo_window_get_type
#define adw_navigation_view_demo_window_new adap_navigation_view_demo_window_new
#define adw_navigation_view_find_page adap_navigation_view_find_page
#define adw_navigation_view_get_animate_transitions adap_navigation_view_get_animate_transitions
#define adw_navigation_view_get_navigation_stack adap_navigation_view_get_navigation_stack
#define adw_navigation_view_get_pop_on_escape adap_navigation_view_get_pop_on_escape
#define adw_navigation_view_get_previous_page adap_navigation_view_get_previous_page
#define adw_navigation_view_get_type adap_navigation_view_get_type
#define adw_navigation_view_get_visible_page adap_navigation_view_get_visible_page
#define adw_navigation_view_new adap_navigation_view_new
#define adw_navigation_view_pop adap_navigation_view_pop
#define adw_navigation_view_pop_to_page adap_navigation_view_pop_to_page
#define adw_navigation_view_pop_to_tag adap_navigation_view_pop_to_tag
#define adw_navigation_view_push adap_navigation_view_push
#define adw_navigation_view_push_by_tag adap_navigation_view_push_by_tag
#define adw_navigation_view_remove adap_navigation_view_remove
#define adw_navigation_view_replace adap_navigation_view_replace
#define adw_navigation_view_replace_with_tags adap_navigation_view_replace_with_tags
#define adw_navigation_view_set_animate_transitions adap_navigation_view_set_animate_transitions
#define adw_navigation_view_set_pop_on_escape adap_navigation_view_set_pop_on_escape
#define adw_overlay_split_view_demo_window_get_type adap_overlay_split_view_demo_window_get_type
#define adw_overlay_split_view_demo_window_new adap_overlay_split_view_demo_window_new
#define adw_overlay_split_view_get_collapsed adap_overlay_split_view_get_collapsed
#define adw_overlay_split_view_get_content adap_overlay_split_view_get_content
#define adw_overlay_split_view_get_enable_hide_gesture adap_overlay_split_view_get_enable_hide_gesture
#define adw_overlay_split_view_get_enable_show_gesture adap_overlay_split_view_get_enable_show_gesture
#define adw_overlay_split_view_get_max_sidebar_width adap_overlay_split_view_get_max_sidebar_width
#define adw_overlay_split_view_get_min_sidebar_width adap_overlay_split_view_get_min_sidebar_width
#define adw_overlay_split_view_get_pin_sidebar adap_overlay_split_view_get_pin_sidebar
#define adw_overlay_split_view_get_show_sidebar adap_overlay_split_view_get_show_sidebar
#define adw_overlay_split_view_get_sidebar adap_overlay_split_view_get_sidebar
#define adw_overlay_split_view_get_sidebar_position adap_overlay_split_view_get_sidebar_position
#define adw_overlay_split_view_get_sidebar_width_fraction adap_overlay_split_view_get_sidebar_width_fraction
#define adw_overlay_split_view_get_sidebar_width_unit adap_overlay_split_view_get_sidebar_width_unit
#define adw_overlay_split_view_get_type adap_overlay_split_view_get_type
#define adw_overlay_split_view_new adap_overlay_split_view_new
#define adw_overlay_split_view_set_collapsed adap_overlay_split_view_set_collapsed
#define adw_overlay_split_view_set_content adap_overlay_split_view_set_content
#define adw_overlay_split_view_set_enable_hide_gesture adap_overlay_split_view_set_enable_hide_gesture
#define adw_overlay_split_view_set_enable_show_gesture adap_overlay_split_view_set_enable_show_gesture
#define adw_overlay_split_view_set_max_sidebar_width adap_overlay_split_view_set_max_sidebar_width
#define adw_overlay_split_view_set_min_sidebar_width adap_overlay_split_view_set_min_sidebar_width
#define adw_overlay_split_view_set_pin_sidebar adap_overlay_split_view_set_pin_sidebar
#define adw_overlay_split_view_set_show_sidebar adap_overlay_split_view_set_show_sidebar
#define adw_overlay_split_view_set_sidebar adap_overlay_split_view_set_sidebar
#define adw_overlay_split_view_set_sidebar_position adap_overlay_split_view_set_sidebar_position
#define adw_overlay_split_view_set_sidebar_width_fraction adap_overlay_split_view_set_sidebar_width_fraction
#define adw_overlay_split_view_set_sidebar_width_unit adap_overlay_split_view_set_sidebar_width_unit
#define adw_password_entry_row_get_type adap_password_entry_row_get_type
#define adw_password_entry_row_new adap_password_entry_row_new
#define adw_preferences_dialog_add adap_preferences_dialog_add
#define adw_preferences_dialog_add_toast adap_preferences_dialog_add_toast
#define adw_preferences_dialog_get_search_enabled adap_preferences_dialog_get_search_enabled
#define adw_preferences_dialog_get_type adap_preferences_dialog_get_type
#define adw_preferences_dialog_get_visible_page adap_preferences_dialog_get_visible_page
#define adw_preferences_dialog_get_visible_page_name adap_preferences_dialog_get_visible_page_name
#define adw_preferences_dialog_new adap_preferences_dialog_new
#define adw_preferences_dialog_pop_subpage adap_preferences_dialog_pop_subpage
#define adw_preferences_dialog_push_subpage adap_preferences_dialog_push_subpage
#define adw_preferences_dialog_remove adap_preferences_dialog_remove
#define adw_preferences_dialog_set_search_enabled adap_preferences_dialog_set_search_enabled
#define adw_preferences_dialog_set_visible_page adap_preferences_dialog_set_visible_page
#define adw_preferences_dialog_set_visible_page_name adap_preferences_dialog_set_visible_page_name
#define adw_preferences_group_add adap_preferences_group_add
#define adw_preferences_group_get_description adap_preferences_group_get_description
#define adw_preferences_group_get_header_suffix adap_preferences_group_get_header_suffix
#define adw_preferences_group_get_rows adap_preferences_group_get_rows
#define adw_preferences_group_get_title adap_preferences_group_get_title
#define adw_preferences_group_get_type adap_preferences_group_get_type
#define adw_preferences_group_new adap_preferences_group_new
#define adw_preferences_group_remove adap_preferences_group_remove
#define adw_preferences_group_set_description adap_preferences_group_set_description
#define adw_preferences_group_set_header_suffix adap_preferences_group_set_header_suffix
#define adw_preferences_group_set_title adap_preferences_group_set_title
#define adw_preferences_page_add adap_preferences_page_add
#define adw_preferences_page_get_description adap_preferences_page_get_description
#define adw_preferences_page_get_icon_name adap_preferences_page_get_icon_name
#define adw_preferences_page_get_name adap_preferences_page_get_name
#define adw_preferences_page_get_rows adap_preferences_page_get_rows
#define adw_preferences_page_get_title adap_preferences_page_get_title
#define adw_preferences_page_get_type adap_preferences_page_get_type
#define adw_preferences_page_get_use_underline adap_preferences_page_get_use_underline
#define adw_preferences_page_new adap_preferences_page_new
#define adw_preferences_page_remove adap_preferences_page_remove
#define adw_preferences_page_scroll_to_top adap_preferences_page_scroll_to_top
#define adw_preferences_page_set_description adap_preferences_page_set_description
#define adw_preferences_page_set_icon_name adap_preferences_page_set_icon_name
#define adw_preferences_page_set_name adap_preferences_page_set_name
#define adw_preferences_page_set_title adap_preferences_page_set_title
#define adw_preferences_page_set_use_underline adap_preferences_page_set_use_underline
#define adw_preferences_row_get_title adap_preferences_row_get_title
#define adw_preferences_row_get_title_selectable adap_preferences_row_get_title_selectable
#define adw_preferences_row_get_type adap_preferences_row_get_type
#define adw_preferences_row_get_use_markup adap_preferences_row_get_use_markup
#define adw_preferences_row_get_use_underline adap_preferences_row_get_use_underline
#define adw_preferences_row_new adap_preferences_row_new
#define adw_preferences_row_set_title adap_preferences_row_set_title
#define adw_preferences_row_set_title_selectable adap_preferences_row_set_title_selectable
#define adw_preferences_row_set_use_markup adap_preferences_row_set_use_markup
#define adw_preferences_row_set_use_underline adap_preferences_row_set_use_underline
#define adw_preferences_window_add adap_preferences_window_add
#define adw_preferences_window_add_toast adap_preferences_window_add_toast
#define adw_preferences_window_close_subpage adap_preferences_window_close_subpage
#define adw_preferences_window_get_can_navigate_back adap_preferences_window_get_can_navigate_back
#define adw_preferences_window_get_search_enabled adap_preferences_window_get_search_enabled
#define adw_preferences_window_get_type adap_preferences_window_get_type
#define adw_preferences_window_get_visible_page adap_preferences_window_get_visible_page
#define adw_preferences_window_get_visible_page_name adap_preferences_window_get_visible_page_name
#define adw_preferences_window_new adap_preferences_window_new
#define adw_preferences_window_pop_subpage adap_preferences_window_pop_subpage
#define adw_preferences_window_present_subpage adap_preferences_window_present_subpage
#define adw_preferences_window_push_subpage adap_preferences_window_push_subpage
#define adw_preferences_window_remove adap_preferences_window_remove
#define adw_preferences_window_set_can_navigate_back adap_preferences_window_set_can_navigate_back
#define adw_preferences_window_set_search_enabled adap_preferences_window_set_search_enabled
#define adw_preferences_window_set_visible_page adap_preferences_window_set_visible_page
#define adw_preferences_window_set_visible_page_name adap_preferences_window_set_visible_page_name
#define adw_property_animation_target_get_object adap_property_animation_target_get_object
#define adw_property_animation_target_get_pspec adap_property_animation_target_get_pspec
#define adw_property_animation_target_get_type adap_property_animation_target_get_type
#define adw_property_animation_target_new adap_property_animation_target_new
#define adw_property_animation_target_new_for_pspec adap_property_animation_target_new_for_pspec
#define adw_settings_end_override adap_settings_end_override
#define adw_settings_get_color_scheme adap_settings_get_color_scheme
#define adw_settings_get_default adap_settings_get_default
#define adw_settings_get_high_contrast adap_settings_get_high_contrast
#define adw_settings_get_system_supports_color_schemes adap_settings_get_system_supports_color_schemes
#define adw_settings_get_theme_name adap_settings_get_theme_name
#define adw_settings_get_type adap_settings_get_type
#define adw_settings_impl_get_color_scheme adap_settings_impl_get_color_scheme
#define adw_settings_impl_get_has_color_scheme adap_settings_impl_get_has_color_scheme
#define adw_settings_impl_get_has_high_contrast adap_settings_impl_get_has_high_contrast
#define adw_settings_impl_get_has_theme_name adap_settings_impl_get_has_theme_name
#define adw_settings_impl_get_high_contrast adap_settings_impl_get_high_contrast
#define adw_settings_impl_get_theme_name adap_settings_impl_get_theme_name
#define adw_settings_impl_get_type adap_settings_impl_get_type
#define adw_settings_impl_gsettings_get_type adap_settings_impl_gsettings_get_type
#define adw_settings_impl_gsettings_new adap_settings_impl_gsettings_new
#define adw_settings_impl_legacy_get_type adap_settings_impl_legacy_get_type
#define adw_settings_impl_legacy_new adap_settings_impl_legacy_new
#define adw_settings_impl_macos_get_type adap_settings_impl_macos_get_type
#define adw_settings_impl_macos_new adap_settings_impl_macos_new
#define adw_settings_impl_portal_get_type adap_settings_impl_portal_get_type
#define adw_settings_impl_portal_new adap_settings_impl_portal_new
#define adw_settings_impl_set_color_scheme adap_settings_impl_set_color_scheme
#define adw_settings_impl_set_features adap_settings_impl_set_features
#define adw_settings_impl_set_high_contrast adap_settings_impl_set_high_contrast
#define adw_settings_impl_set_theme_name adap_settings_impl_set_theme_name
#define adw_settings_impl_win32_get_type adap_settings_impl_win32_get_type
#define adw_settings_impl_win32_new adap_settings_impl_win32_new
#define adw_settings_override_color_scheme adap_settings_override_color_scheme
#define adw_settings_override_high_contrast adap_settings_override_high_contrast
#define adw_settings_override_system_supports_color_schemes adap_settings_override_system_supports_color_schemes
#define adw_settings_start_override adap_settings_start_override
#define adw_shadow_helper_get_type adap_shadow_helper_get_type
#define adw_shadow_helper_new adap_shadow_helper_new
#define adw_shadow_helper_size_allocate adap_shadow_helper_size_allocate
#define adw_shadow_helper_snapshot adap_shadow_helper_snapshot
#define adw_sheet_controls_get_decoration_layout adap_sheet_controls_get_decoration_layout
#define adw_sheet_controls_get_empty adap_sheet_controls_get_empty
#define adw_sheet_controls_get_side adap_sheet_controls_get_side
#define adw_sheet_controls_get_type adap_sheet_controls_get_type
#define adw_sheet_controls_new adap_sheet_controls_new
#define adw_sheet_controls_set_decoration_layout adap_sheet_controls_set_decoration_layout
#define adw_sheet_controls_set_side adap_sheet_controls_set_side
#define adw_show_about_dialog adap_show_about_dialog
#define adw_show_about_dialog_from_appdata adap_show_about_dialog_from_appdata
#define adw_show_about_window adap_show_about_window
#define adw_show_about_window_from_appdata adap_show_about_window_from_appdata
#define adw_spin_row_configure adap_spin_row_configure
#define adw_spin_row_get_adjustment adap_spin_row_get_adjustment
#define adw_spin_row_get_climb_rate adap_spin_row_get_climb_rate
#define adw_spin_row_get_digits adap_spin_row_get_digits
#define adw_spin_row_get_numeric adap_spin_row_get_numeric
#define adw_spin_row_get_snap_to_ticks adap_spin_row_get_snap_to_ticks
#define adw_spin_row_get_type adap_spin_row_get_type
#define adw_spin_row_get_update_policy adap_spin_row_get_update_policy
#define adw_spin_row_get_value adap_spin_row_get_value
#define adw_spin_row_get_wrap adap_spin_row_get_wrap
#define adw_spin_row_new adap_spin_row_new
#define adw_spin_row_new_with_range adap_spin_row_new_with_range
#define adw_spin_row_set_adjustment adap_spin_row_set_adjustment
#define adw_spin_row_set_climb_rate adap_spin_row_set_climb_rate
#define adw_spin_row_set_digits adap_spin_row_set_digits
#define adw_spin_row_set_numeric adap_spin_row_set_numeric
#define adw_spin_row_set_range adap_spin_row_set_range
#define adw_spin_row_set_snap_to_ticks adap_spin_row_set_snap_to_ticks
#define adw_spin_row_set_update_policy adap_spin_row_set_update_policy
#define adw_spin_row_set_value adap_spin_row_set_value
#define adw_spin_row_set_wrap adap_spin_row_set_wrap
#define adw_spin_row_update adap_spin_row_update
#define adw_split_button_get_can_shrink adap_split_button_get_can_shrink
#define adw_split_button_get_child adap_split_button_get_child
#define adw_split_button_get_direction adap_split_button_get_direction
#define adw_split_button_get_dropdown_tooltip adap_split_button_get_dropdown_tooltip
#define adw_split_button_get_icon_name adap_split_button_get_icon_name
#define adw_split_button_get_label adap_split_button_get_label
#define adw_split_button_get_menu_model adap_split_button_get_menu_model
#define adw_split_button_get_popover adap_split_button_get_popover
#define adw_split_button_get_type adap_split_button_get_type
#define adw_split_button_get_use_underline adap_split_button_get_use_underline
#define adw_split_button_new adap_split_button_new
#define adw_split_button_popdown adap_split_button_popdown
#define adw_split_button_popup adap_split_button_popup
#define adw_split_button_set_can_shrink adap_split_button_set_can_shrink
#define adw_split_button_set_child adap_split_button_set_child
#define adw_split_button_set_direction adap_split_button_set_direction
#define adw_split_button_set_dropdown_tooltip adap_split_button_set_dropdown_tooltip
#define adw_split_button_set_icon_name adap_split_button_set_icon_name
#define adw_split_button_set_label adap_split_button_set_label
#define adw_split_button_set_menu_model adap_split_button_set_menu_model
#define adw_split_button_set_popover adap_split_button_set_popover
#define adw_split_button_set_use_underline adap_split_button_set_use_underline
#define adw_spring_animation_calculate_value adap_spring_animation_calculate_value
#define adw_spring_animation_calculate_velocity adap_spring_animation_calculate_velocity
#define adw_spring_animation_get_clamp adap_spring_animation_get_clamp
#define adw_spring_animation_get_epsilon adap_spring_animation_get_epsilon
#define adw_spring_animation_get_estimated_duration adap_spring_animation_get_estimated_duration
#define adw_spring_animation_get_initial_velocity adap_spring_animation_get_initial_velocity
#define adw_spring_animation_get_spring_params adap_spring_animation_get_spring_params
#define adw_spring_animation_get_type adap_spring_animation_get_type
#define adw_spring_animation_get_value_from adap_spring_animation_get_value_from
#define adw_spring_animation_get_value_to adap_spring_animation_get_value_to
#define adw_spring_animation_get_velocity adap_spring_animation_get_velocity
#define adw_spring_animation_new adap_spring_animation_new
#define adw_spring_animation_set_clamp adap_spring_animation_set_clamp
#define adw_spring_animation_set_epsilon adap_spring_animation_set_epsilon
#define adw_spring_animation_set_initial_velocity adap_spring_animation_set_initial_velocity
#define adw_spring_animation_set_spring_params adap_spring_animation_set_spring_params
#define adw_spring_animation_set_value_from adap_spring_animation_set_value_from
#define adw_spring_animation_set_value_to adap_spring_animation_set_value_to
#define adw_spring_params_get_damping adap_spring_params_get_damping
#define adw_spring_params_get_damping_ratio adap_spring_params_get_damping_ratio
#define adw_spring_params_get_mass adap_spring_params_get_mass
#define adw_spring_params_get_stiffness adap_spring_params_get_stiffness
#define adw_spring_params_get_type adap_spring_params_get_type
#define adw_spring_params_new adap_spring_params_new
#define adw_spring_params_new_full adap_spring_params_new_full
#define adw_spring_params_ref adap_spring_params_ref
#define adw_spring_params_unref adap_spring_params_unref
#define adw_squeezer_add adap_squeezer_add
#define adw_squeezer_get_allow_none adap_squeezer_get_allow_none
#define adw_squeezer_get_homogeneous adap_squeezer_get_homogeneous
#define adw_squeezer_get_interpolate_size adap_squeezer_get_interpolate_size
#define adw_squeezer_get_page adap_squeezer_get_page
#define adw_squeezer_get_pages adap_squeezer_get_pages
#define adw_squeezer_get_switch_threshold_policy adap_squeezer_get_switch_threshold_policy
#define adw_squeezer_get_transition_duration adap_squeezer_get_transition_duration
#define adw_squeezer_get_transition_running adap_squeezer_get_transition_running
#define adw_squeezer_get_transition_type adap_squeezer_get_transition_type
#define adw_squeezer_get_type adap_squeezer_get_type
#define adw_squeezer_get_visible_child adap_squeezer_get_visible_child
#define adw_squeezer_get_xalign adap_squeezer_get_xalign
#define adw_squeezer_get_yalign adap_squeezer_get_yalign
#define adw_squeezer_new adap_squeezer_new
#define adw_squeezer_page_get_child adap_squeezer_page_get_child
#define adw_squeezer_page_get_enabled adap_squeezer_page_get_enabled
#define adw_squeezer_page_get_type adap_squeezer_page_get_type
#define adw_squeezer_page_set_enabled adap_squeezer_page_set_enabled
#define adw_squeezer_remove adap_squeezer_remove
#define adw_squeezer_set_allow_none adap_squeezer_set_allow_none
#define adw_squeezer_set_homogeneous adap_squeezer_set_homogeneous
#define adw_squeezer_set_interpolate_size adap_squeezer_set_interpolate_size
#define adw_squeezer_set_switch_threshold_policy adap_squeezer_set_switch_threshold_policy
#define adw_squeezer_set_transition_duration adap_squeezer_set_transition_duration
#define adw_squeezer_set_transition_type adap_squeezer_set_transition_type
#define adw_squeezer_set_xalign adap_squeezer_set_xalign
#define adw_squeezer_set_yalign adap_squeezer_set_yalign
#define adw_status_page_get_child adap_status_page_get_child
#define adw_status_page_get_description adap_status_page_get_description
#define adw_status_page_get_icon_name adap_status_page_get_icon_name
#define adw_status_page_get_paintable adap_status_page_get_paintable
#define adw_status_page_get_title adap_status_page_get_title
#define adw_status_page_get_type adap_status_page_get_type
#define adw_status_page_new adap_status_page_new
#define adw_status_page_set_child adap_status_page_set_child
#define adw_status_page_set_description adap_status_page_set_description
#define adw_status_page_set_icon_name adap_status_page_set_icon_name
#define adw_status_page_set_paintable adap_status_page_set_paintable
#define adw_status_page_set_title adap_status_page_set_title
#define adw_style_demo_window_get_type adap_style_demo_window_get_type
#define adw_style_demo_window_new adap_style_demo_window_new
#define adw_style_manager_ensure adap_style_manager_ensure
#define adw_style_manager_get_color_scheme adap_style_manager_get_color_scheme
#define adw_style_manager_get_dark adap_style_manager_get_dark
#define adw_style_manager_get_default adap_style_manager_get_default
#define adw_style_manager_get_display adap_style_manager_get_display
#define adw_style_manager_get_for_display adap_style_manager_get_for_display
#define adw_style_manager_get_high_contrast adap_style_manager_get_high_contrast
#define adw_style_manager_get_system_supports_color_schemes adap_style_manager_get_system_supports_color_schemes
#define adw_style_manager_get_type adap_style_manager_get_type
#define adw_style_manager_set_color_scheme adap_style_manager_set_color_scheme
#define adw_swipe_tracker_get_allow_long_swipes adap_swipe_tracker_get_allow_long_swipes
#define adw_swipe_tracker_get_allow_mouse_drag adap_swipe_tracker_get_allow_mouse_drag
#define adw_swipe_tracker_get_allow_window_handle adap_swipe_tracker_get_allow_window_handle
#define adw_swipe_tracker_get_enabled adap_swipe_tracker_get_enabled
#define adw_swipe_tracker_get_lower_overshoot adap_swipe_tracker_get_lower_overshoot
#define adw_swipe_tracker_get_reversed adap_swipe_tracker_get_reversed
#define adw_swipe_tracker_get_swipeable adap_swipe_tracker_get_swipeable
#define adw_swipe_tracker_get_type adap_swipe_tracker_get_type
#define adw_swipe_tracker_get_upper_overshoot adap_swipe_tracker_get_upper_overshoot
#define adw_swipe_tracker_new adap_swipe_tracker_new
#define adw_swipe_tracker_reset adap_swipe_tracker_reset
#define adw_swipe_tracker_set_allow_long_swipes adap_swipe_tracker_set_allow_long_swipes
#define adw_swipe_tracker_set_allow_mouse_drag adap_swipe_tracker_set_allow_mouse_drag
#define adw_swipe_tracker_set_allow_window_handle adap_swipe_tracker_set_allow_window_handle
#define adw_swipe_tracker_set_enabled adap_swipe_tracker_set_enabled
#define adw_swipe_tracker_set_lower_overshoot adap_swipe_tracker_set_lower_overshoot
#define adw_swipe_tracker_set_reversed adap_swipe_tracker_set_reversed
#define adw_swipe_tracker_set_upper_overshoot adap_swipe_tracker_set_upper_overshoot
#define adw_swipe_tracker_shift_position adap_swipe_tracker_shift_position
#define adw_swipeable_get_cancel_progress adap_swipeable_get_cancel_progress
#define adw_swipeable_get_distance adap_swipeable_get_distance
#define adw_swipeable_get_progress adap_swipeable_get_progress
#define adw_swipeable_get_snap_points adap_swipeable_get_snap_points
#define adw_swipeable_get_swipe_area adap_swipeable_get_swipe_area
#define adw_swipeable_get_type adap_swipeable_get_type
#define adw_switch_row_get_active adap_switch_row_get_active
#define adw_switch_row_get_type adap_switch_row_get_type
#define adw_switch_row_new adap_switch_row_new
#define adw_switch_row_set_active adap_switch_row_set_active
#define adw_tab_bar_get_autohide adap_tab_bar_get_autohide
#define adw_tab_bar_get_end_action_widget adap_tab_bar_get_end_action_widget
#define adw_tab_bar_get_expand_tabs adap_tab_bar_get_expand_tabs
#define adw_tab_bar_get_extra_drag_preferred_action adap_tab_bar_get_extra_drag_preferred_action
#define adw_tab_bar_get_extra_drag_preload adap_tab_bar_get_extra_drag_preload
#define adw_tab_bar_get_inverted adap_tab_bar_get_inverted
#define adw_tab_bar_get_is_overflowing adap_tab_bar_get_is_overflowing
#define adw_tab_bar_get_pinned_tab_box adap_tab_bar_get_pinned_tab_box
#define adw_tab_bar_get_start_action_widget adap_tab_bar_get_start_action_widget
#define adw_tab_bar_get_tab_box adap_tab_bar_get_tab_box
#define adw_tab_bar_get_tabs_revealed adap_tab_bar_get_tabs_revealed
#define adw_tab_bar_get_type adap_tab_bar_get_type
#define adw_tab_bar_get_view adap_tab_bar_get_view
#define adw_tab_bar_new adap_tab_bar_new
#define adw_tab_bar_set_autohide adap_tab_bar_set_autohide
#define adw_tab_bar_set_end_action_widget adap_tab_bar_set_end_action_widget
#define adw_tab_bar_set_expand_tabs adap_tab_bar_set_expand_tabs
#define adw_tab_bar_set_extra_drag_preload adap_tab_bar_set_extra_drag_preload
#define adw_tab_bar_set_inverted adap_tab_bar_set_inverted
#define adw_tab_bar_set_start_action_widget adap_tab_bar_set_start_action_widget
#define adw_tab_bar_set_view adap_tab_bar_set_view
#define adw_tab_bar_setup_extra_drop_target adap_tab_bar_setup_extra_drop_target
#define adw_tab_bar_tabs_have_visible_focus adap_tab_bar_tabs_have_visible_focus
#define adw_tab_box_attach_page adap_tab_box_attach_page
#define adw_tab_box_detach_page adap_tab_box_detach_page
#define adw_tab_box_get_expand_tabs adap_tab_box_get_expand_tabs
#define adw_tab_box_get_extra_drag_preload adap_tab_box_get_extra_drag_preload
#define adw_tab_box_get_inverted adap_tab_box_get_inverted
#define adw_tab_box_get_type adap_tab_box_get_type
#define adw_tab_box_is_page_focused adap_tab_box_is_page_focused
#define adw_tab_box_select_page adap_tab_box_select_page
#define adw_tab_box_set_expand_tabs adap_tab_box_set_expand_tabs
#define adw_tab_box_set_extra_drag_preload adap_tab_box_set_extra_drag_preload
#define adw_tab_box_set_inverted adap_tab_box_set_inverted
#define adw_tab_box_set_view adap_tab_box_set_view
#define adw_tab_box_setup_extra_drop_target adap_tab_box_setup_extra_drop_target
#define adw_tab_box_try_focus_selected_tab adap_tab_box_try_focus_selected_tab
#define adw_tab_button_get_type adap_tab_button_get_type
#define adw_tab_button_get_view adap_tab_button_get_view
#define adw_tab_button_new adap_tab_button_new
#define adw_tab_button_set_view adap_tab_button_set_view
#define adw_tab_can_click_at adap_tab_can_click_at
#define adw_tab_get_dragging adap_tab_get_dragging
#define adw_tab_get_inverted adap_tab_get_inverted
#define adw_tab_get_page adap_tab_get_page
#define adw_tab_get_type adap_tab_get_type
#define adw_tab_grid_adjustment_shifted adap_tab_grid_adjustment_shifted
#define adw_tab_grid_attach_page adap_tab_grid_attach_page
#define adw_tab_grid_detach_page adap_tab_grid_detach_page
#define adw_tab_grid_focus_first_row adap_tab_grid_focus_first_row
#define adw_tab_grid_focus_last_row adap_tab_grid_focus_last_row
#define adw_tab_grid_focus_page adap_tab_grid_focus_page
#define adw_tab_grid_get_empty adap_tab_grid_get_empty
#define adw_tab_grid_get_extra_drag_preload adap_tab_grid_get_extra_drag_preload
#define adw_tab_grid_get_inverted adap_tab_grid_get_inverted
#define adw_tab_grid_get_scrolled_tab_y adap_tab_grid_get_scrolled_tab_y
#define adw_tab_grid_get_transition_thumbnail adap_tab_grid_get_transition_thumbnail
#define adw_tab_grid_get_type adap_tab_grid_get_type
#define adw_tab_grid_is_page_focused adap_tab_grid_is_page_focused
#define adw_tab_grid_measure_height_final adap_tab_grid_measure_height_final
#define adw_tab_grid_reset_scrolled_tab adap_tab_grid_reset_scrolled_tab
#define adw_tab_grid_scroll_to_page adap_tab_grid_scroll_to_page
#define adw_tab_grid_select_page adap_tab_grid_select_page
#define adw_tab_grid_set_extra_drag_preload adap_tab_grid_set_extra_drag_preload
#define adw_tab_grid_set_hovering adap_tab_grid_set_hovering
#define adw_tab_grid_set_inverted adap_tab_grid_set_inverted
#define adw_tab_grid_set_search_terms adap_tab_grid_set_search_terms
#define adw_tab_grid_set_view adap_tab_grid_set_view
#define adw_tab_grid_set_visible_range adap_tab_grid_set_visible_range
#define adw_tab_grid_setup_extra_drop_target adap_tab_grid_setup_extra_drop_target
#define adw_tab_grid_try_focus_selected_tab adap_tab_grid_try_focus_selected_tab
#define adw_tab_new adap_tab_new
#define adw_tab_overview_get_child adap_tab_overview_get_child
#define adw_tab_overview_get_enable_new_tab adap_tab_overview_get_enable_new_tab
#define adw_tab_overview_get_enable_search adap_tab_overview_get_enable_search
#define adw_tab_overview_get_extra_drag_preferred_action adap_tab_overview_get_extra_drag_preferred_action
#define adw_tab_overview_get_extra_drag_preload adap_tab_overview_get_extra_drag_preload
#define adw_tab_overview_get_inverted adap_tab_overview_get_inverted
#define adw_tab_overview_get_open adap_tab_overview_get_open
#define adw_tab_overview_get_pinned_tab_grid adap_tab_overview_get_pinned_tab_grid
#define adw_tab_overview_get_search_active adap_tab_overview_get_search_active
#define adw_tab_overview_get_secondary_menu adap_tab_overview_get_secondary_menu
#define adw_tab_overview_get_show_end_title_buttons adap_tab_overview_get_show_end_title_buttons
#define adw_tab_overview_get_show_start_title_buttons adap_tab_overview_get_show_start_title_buttons
#define adw_tab_overview_get_tab_grid adap_tab_overview_get_tab_grid
#define adw_tab_overview_get_type adap_tab_overview_get_type
#define adw_tab_overview_get_view adap_tab_overview_get_view
#define adw_tab_overview_new adap_tab_overview_new
#define adw_tab_overview_set_child adap_tab_overview_set_child
#define adw_tab_overview_set_enable_new_tab adap_tab_overview_set_enable_new_tab
#define adw_tab_overview_set_enable_search adap_tab_overview_set_enable_search
#define adw_tab_overview_set_extra_drag_preload adap_tab_overview_set_extra_drag_preload
#define adw_tab_overview_set_inverted adap_tab_overview_set_inverted
#define adw_tab_overview_set_open adap_tab_overview_set_open
#define adw_tab_overview_set_secondary_menu adap_tab_overview_set_secondary_menu
#define adw_tab_overview_set_show_end_title_buttons adap_tab_overview_set_show_end_title_buttons
#define adw_tab_overview_set_show_start_title_buttons adap_tab_overview_set_show_start_title_buttons
#define adw_tab_overview_set_view adap_tab_overview_set_view
#define adw_tab_overview_setup_extra_drop_target adap_tab_overview_setup_extra_drop_target
#define adw_tab_page_get_child adap_tab_page_get_child
#define adw_tab_page_get_icon adap_tab_page_get_icon
#define adw_tab_page_get_indicator_activatable adap_tab_page_get_indicator_activatable
#define adw_tab_page_get_indicator_icon adap_tab_page_get_indicator_icon
#define adw_tab_page_get_indicator_tooltip adap_tab_page_get_indicator_tooltip
#define adw_tab_page_get_keyword adap_tab_page_get_keyword
#define adw_tab_page_get_live_thumbnail adap_tab_page_get_live_thumbnail
#define adw_tab_page_get_loading adap_tab_page_get_loading
#define adw_tab_page_get_needs_attention adap_tab_page_get_needs_attention
#define adw_tab_page_get_paintable adap_tab_page_get_paintable
#define adw_tab_page_get_parent adap_tab_page_get_parent
#define adw_tab_page_get_pinned adap_tab_page_get_pinned
#define adw_tab_page_get_selected adap_tab_page_get_selected
#define adw_tab_page_get_thumbnail_xalign adap_tab_page_get_thumbnail_xalign
#define adw_tab_page_get_thumbnail_yalign adap_tab_page_get_thumbnail_yalign
#define adw_tab_page_get_title adap_tab_page_get_title
#define adw_tab_page_get_tooltip adap_tab_page_get_tooltip
#define adw_tab_page_get_type adap_tab_page_get_type
#define adw_tab_page_invalidate_thumbnail adap_tab_page_invalidate_thumbnail
#define adw_tab_page_set_icon adap_tab_page_set_icon
#define adw_tab_page_set_indicator_activatable adap_tab_page_set_indicator_activatable
#define adw_tab_page_set_indicator_icon adap_tab_page_set_indicator_icon
#define adw_tab_page_set_indicator_tooltip adap_tab_page_set_indicator_tooltip
#define adw_tab_page_set_keyword adap_tab_page_set_keyword
#define adw_tab_page_set_live_thumbnail adap_tab_page_set_live_thumbnail
#define adw_tab_page_set_loading adap_tab_page_set_loading
#define adw_tab_page_set_needs_attention adap_tab_page_set_needs_attention
#define adw_tab_page_set_thumbnail_xalign adap_tab_page_set_thumbnail_xalign
#define adw_tab_page_set_thumbnail_yalign adap_tab_page_set_thumbnail_yalign
#define adw_tab_page_set_title adap_tab_page_set_title
#define adw_tab_page_set_tooltip adap_tab_page_set_tooltip
#define adw_tab_set_dragging adap_tab_set_dragging
#define adw_tab_set_extra_drag_preload adap_tab_set_extra_drag_preload
#define adw_tab_set_fully_visible adap_tab_set_fully_visible
#define adw_tab_set_inverted adap_tab_set_inverted
#define adw_tab_set_page adap_tab_set_page
#define adw_tab_setup_extra_drop_target adap_tab_setup_extra_drop_target
#define adw_tab_thumbnail_fade_in adap_tab_thumbnail_fade_in
#define adw_tab_thumbnail_fade_out adap_tab_thumbnail_fade_out
#define adw_tab_thumbnail_get_inverted adap_tab_thumbnail_get_inverted
#define adw_tab_thumbnail_get_page adap_tab_thumbnail_get_page
#define adw_tab_thumbnail_get_thumbnail adap_tab_thumbnail_get_thumbnail
#define adw_tab_thumbnail_get_type adap_tab_thumbnail_get_type
#define adw_tab_thumbnail_new adap_tab_thumbnail_new
#define adw_tab_thumbnail_set_extra_drag_preload adap_tab_thumbnail_set_extra_drag_preload
#define adw_tab_thumbnail_set_inverted adap_tab_thumbnail_set_inverted
#define adw_tab_thumbnail_set_page adap_tab_thumbnail_set_page
#define adw_tab_thumbnail_setup_extra_drop_target adap_tab_thumbnail_setup_extra_drop_target
#define adw_tab_view_add_page adap_tab_view_add_page
#define adw_tab_view_add_shortcuts adap_tab_view_add_shortcuts
#define adw_tab_view_append adap_tab_view_append
#define adw_tab_view_append_pinned adap_tab_view_append_pinned
#define adw_tab_view_attach_page adap_tab_view_attach_page
#define adw_tab_view_close_other_pages adap_tab_view_close_other_pages
#define adw_tab_view_close_overview adap_tab_view_close_overview
#define adw_tab_view_close_page adap_tab_view_close_page
#define adw_tab_view_close_page_finish adap_tab_view_close_page_finish
#define adw_tab_view_close_pages_after adap_tab_view_close_pages_after
#define adw_tab_view_close_pages_before adap_tab_view_close_pages_before
#define adw_tab_view_create_window adap_tab_view_create_window
#define adw_tab_view_demo_page_get_type adap_tab_view_demo_page_get_type
#define adw_tab_view_demo_page_new adap_tab_view_demo_page_new
#define adw_tab_view_demo_page_new_duplicate adap_tab_view_demo_page_new_duplicate
#define adw_tab_view_demo_page_refresh_icon adap_tab_view_demo_page_refresh_icon
#define adw_tab_view_demo_page_set_enable_icon adap_tab_view_demo_page_set_enable_icon
#define adw_tab_view_demo_window_get_type adap_tab_view_demo_window_get_type
#define adw_tab_view_demo_window_new adap_tab_view_demo_window_new
#define adw_tab_view_demo_window_prepopulate adap_tab_view_demo_window_prepopulate
#define adw_tab_view_detach_page adap_tab_view_detach_page
#define adw_tab_view_get_default_icon adap_tab_view_get_default_icon
#define adw_tab_view_get_is_transferring_page adap_tab_view_get_is_transferring_page
#define adw_tab_view_get_menu_model adap_tab_view_get_menu_model
#define adw_tab_view_get_n_pages adap_tab_view_get_n_pages
#define adw_tab_view_get_n_pinned_pages adap_tab_view_get_n_pinned_pages
#define adw_tab_view_get_nth_page adap_tab_view_get_nth_page
#define adw_tab_view_get_page adap_tab_view_get_page
#define adw_tab_view_get_page_position adap_tab_view_get_page_position
#define adw_tab_view_get_pages adap_tab_view_get_pages
#define adw_tab_view_get_selected_page adap_tab_view_get_selected_page
#define adw_tab_view_get_shortcuts adap_tab_view_get_shortcuts
#define adw_tab_view_get_type adap_tab_view_get_type
#define adw_tab_view_insert adap_tab_view_insert
#define adw_tab_view_insert_pinned adap_tab_view_insert_pinned
#define adw_tab_view_invalidate_thumbnails adap_tab_view_invalidate_thumbnails
#define adw_tab_view_new adap_tab_view_new
#define adw_tab_view_open_overview adap_tab_view_open_overview
#define adw_tab_view_prepend adap_tab_view_prepend
#define adw_tab_view_prepend_pinned adap_tab_view_prepend_pinned
#define adw_tab_view_remove_shortcuts adap_tab_view_remove_shortcuts
#define adw_tab_view_reorder_backward adap_tab_view_reorder_backward
#define adw_tab_view_reorder_first adap_tab_view_reorder_first
#define adw_tab_view_reorder_forward adap_tab_view_reorder_forward
#define adw_tab_view_reorder_last adap_tab_view_reorder_last
#define adw_tab_view_reorder_page adap_tab_view_reorder_page
#define adw_tab_view_select_first_page adap_tab_view_select_first_page
#define adw_tab_view_select_last_page adap_tab_view_select_last_page
#define adw_tab_view_select_next_page adap_tab_view_select_next_page
#define adw_tab_view_select_previous_page adap_tab_view_select_previous_page
#define adw_tab_view_set_default_icon adap_tab_view_set_default_icon
#define adw_tab_view_set_menu_model adap_tab_view_set_menu_model
#define adw_tab_view_set_page_pinned adap_tab_view_set_page_pinned
#define adw_tab_view_set_selected_page adap_tab_view_set_selected_page
#define adw_tab_view_set_shortcuts adap_tab_view_set_shortcuts
#define adw_tab_view_transfer_page adap_tab_view_transfer_page
#define adw_timed_animation_get_alternate adap_timed_animation_get_alternate
#define adw_timed_animation_get_duration adap_timed_animation_get_duration
#define adw_timed_animation_get_easing adap_timed_animation_get_easing
#define adw_timed_animation_get_repeat_count adap_timed_animation_get_repeat_count
#define adw_timed_animation_get_reverse adap_timed_animation_get_reverse
#define adw_timed_animation_get_type adap_timed_animation_get_type
#define adw_timed_animation_get_value_from adap_timed_animation_get_value_from
#define adw_timed_animation_get_value_to adap_timed_animation_get_value_to
#define adw_timed_animation_new adap_timed_animation_new
#define adw_timed_animation_set_alternate adap_timed_animation_set_alternate
#define adw_timed_animation_set_duration adap_timed_animation_set_duration
#define adw_timed_animation_set_easing adap_timed_animation_set_easing
#define adw_timed_animation_set_repeat_count adap_timed_animation_set_repeat_count
#define adw_timed_animation_set_reverse adap_timed_animation_set_reverse
#define adw_timed_animation_set_value_from adap_timed_animation_set_value_from
#define adw_timed_animation_set_value_to adap_timed_animation_set_value_to
#define adw_toast_dismiss adap_toast_dismiss
#define adw_toast_get_action_name adap_toast_get_action_name
#define adw_toast_get_action_target_value adap_toast_get_action_target_value
#define adw_toast_get_button_label adap_toast_get_button_label
#define adw_toast_get_custom_title adap_toast_get_custom_title
#define adw_toast_get_overlay adap_toast_get_overlay
#define adw_toast_get_priority adap_toast_get_priority
#define adw_toast_get_timeout adap_toast_get_timeout
#define adw_toast_get_title adap_toast_get_title
#define adw_toast_get_type adap_toast_get_type
#define adw_toast_get_use_markup adap_toast_get_use_markup
#define adw_toast_new adap_toast_new
#define adw_toast_new_format adap_toast_new_format
#define adw_toast_overlay_add_toast adap_toast_overlay_add_toast
#define adw_toast_overlay_get_child adap_toast_overlay_get_child
#define adw_toast_overlay_get_type adap_toast_overlay_get_type
#define adw_toast_overlay_new adap_toast_overlay_new
#define adw_toast_overlay_set_child adap_toast_overlay_set_child
#define adw_toast_set_action_name adap_toast_set_action_name
#define adw_toast_set_action_target adap_toast_set_action_target
#define adw_toast_set_action_target_value adap_toast_set_action_target_value
#define adw_toast_set_button_label adap_toast_set_button_label
#define adw_toast_set_custom_title adap_toast_set_custom_title
#define adw_toast_set_detailed_action_name adap_toast_set_detailed_action_name
#define adw_toast_set_overlay adap_toast_set_overlay
#define adw_toast_set_priority adap_toast_set_priority
#define adw_toast_set_timeout adap_toast_set_timeout
#define adw_toast_set_title adap_toast_set_title
#define adw_toast_set_use_markup adap_toast_set_use_markup
#define adw_toast_widget_get_button_visible adap_toast_widget_get_button_visible
#define adw_toast_widget_get_type adap_toast_widget_get_type
#define adw_toast_widget_new adap_toast_widget_new
#define adw_toast_widget_reset_timeout adap_toast_widget_reset_timeout
#define adw_toolbar_view_add_bottom_bar adap_toolbar_view_add_bottom_bar
#define adw_toolbar_view_add_top_bar adap_toolbar_view_add_top_bar
#define adw_toolbar_view_get_bottom_bar_height adap_toolbar_view_get_bottom_bar_height
#define adw_toolbar_view_get_bottom_bar_style adap_toolbar_view_get_bottom_bar_style
#define adw_toolbar_view_get_content adap_toolbar_view_get_content
#define adw_toolbar_view_get_extend_content_to_bottom_edge adap_toolbar_view_get_extend_content_to_bottom_edge
#define adw_toolbar_view_get_extend_content_to_top_edge adap_toolbar_view_get_extend_content_to_top_edge
#define adw_toolbar_view_get_reveal_bottom_bars adap_toolbar_view_get_reveal_bottom_bars
#define adw_toolbar_view_get_reveal_top_bars adap_toolbar_view_get_reveal_top_bars
#define adw_toolbar_view_get_top_bar_height adap_toolbar_view_get_top_bar_height
#define adw_toolbar_view_get_top_bar_style adap_toolbar_view_get_top_bar_style
#define adw_toolbar_view_get_type adap_toolbar_view_get_type
#define adw_toolbar_view_new adap_toolbar_view_new
#define adw_toolbar_view_remove adap_toolbar_view_remove
#define adw_toolbar_view_set_bottom_bar_style adap_toolbar_view_set_bottom_bar_style
#define adw_toolbar_view_set_content adap_toolbar_view_set_content
#define adw_toolbar_view_set_extend_content_to_bottom_edge adap_toolbar_view_set_extend_content_to_bottom_edge
#define adw_toolbar_view_set_extend_content_to_top_edge adap_toolbar_view_set_extend_content_to_top_edge
#define adw_toolbar_view_set_reveal_bottom_bars adap_toolbar_view_set_reveal_bottom_bars
#define adw_toolbar_view_set_reveal_top_bars adap_toolbar_view_set_reveal_top_bars
#define adw_toolbar_view_set_top_bar_style adap_toolbar_view_set_top_bar_style
#define adw_view_stack_add adap_view_stack_add
#define adw_view_stack_add_named adap_view_stack_add_named
#define adw_view_stack_add_titled adap_view_stack_add_titled
#define adw_view_stack_add_titled_with_icon adap_view_stack_add_titled_with_icon
#define adw_view_stack_get_child_by_name adap_view_stack_get_child_by_name
#define adw_view_stack_get_hhomogeneous adap_view_stack_get_hhomogeneous
#define adw_view_stack_get_page adap_view_stack_get_page
#define adw_view_stack_get_pages adap_view_stack_get_pages
#define adw_view_stack_get_type adap_view_stack_get_type
#define adw_view_stack_get_vhomogeneous adap_view_stack_get_vhomogeneous
#define adw_view_stack_get_visible_child adap_view_stack_get_visible_child
#define adw_view_stack_get_visible_child_name adap_view_stack_get_visible_child_name
#define adw_view_stack_new adap_view_stack_new
#define adw_view_stack_page_get_badge_number adap_view_stack_page_get_badge_number
#define adw_view_stack_page_get_child adap_view_stack_page_get_child
#define adw_view_stack_page_get_icon_name adap_view_stack_page_get_icon_name
#define adw_view_stack_page_get_name adap_view_stack_page_get_name
#define adw_view_stack_page_get_needs_attention adap_view_stack_page_get_needs_attention
#define adw_view_stack_page_get_title adap_view_stack_page_get_title
#define adw_view_stack_page_get_type adap_view_stack_page_get_type
#define adw_view_stack_page_get_use_underline adap_view_stack_page_get_use_underline
#define adw_view_stack_page_get_visible adap_view_stack_page_get_visible
#define adw_view_stack_page_set_badge_number adap_view_stack_page_set_badge_number
#define adw_view_stack_page_set_icon_name adap_view_stack_page_set_icon_name
#define adw_view_stack_page_set_name adap_view_stack_page_set_name
#define adw_view_stack_page_set_needs_attention adap_view_stack_page_set_needs_attention
#define adw_view_stack_page_set_title adap_view_stack_page_set_title
#define adw_view_stack_page_set_use_underline adap_view_stack_page_set_use_underline
#define adw_view_stack_page_set_visible adap_view_stack_page_set_visible
#define adw_view_stack_pages_get_selected_page adap_view_stack_pages_get_selected_page
#define adw_view_stack_pages_get_type adap_view_stack_pages_get_type
#define adw_view_stack_pages_set_selected_page adap_view_stack_pages_set_selected_page
#define adw_view_stack_remove adap_view_stack_remove
#define adw_view_stack_set_hhomogeneous adap_view_stack_set_hhomogeneous
#define adw_view_stack_set_vhomogeneous adap_view_stack_set_vhomogeneous
#define adw_view_stack_set_visible_child adap_view_stack_set_visible_child
#define adw_view_stack_set_visible_child_name adap_view_stack_set_visible_child_name
#define adw_view_switcher_bar_get_reveal adap_view_switcher_bar_get_reveal
#define adw_view_switcher_bar_get_stack adap_view_switcher_bar_get_stack
#define adw_view_switcher_bar_get_type adap_view_switcher_bar_get_type
#define adw_view_switcher_bar_new adap_view_switcher_bar_new
#define adw_view_switcher_bar_set_reveal adap_view_switcher_bar_set_reveal
#define adw_view_switcher_bar_set_stack adap_view_switcher_bar_set_stack
#define adw_view_switcher_button_get_badge_number adap_view_switcher_button_get_badge_number
#define adw_view_switcher_button_get_icon_name adap_view_switcher_button_get_icon_name
#define adw_view_switcher_button_get_icon_size adap_view_switcher_button_get_icon_size
#define adw_view_switcher_button_get_label adap_view_switcher_button_get_label
#define adw_view_switcher_button_get_needs_attention adap_view_switcher_button_get_needs_attention
#define adw_view_switcher_button_get_type adap_view_switcher_button_get_type
#define adw_view_switcher_button_new adap_view_switcher_button_new
#define adw_view_switcher_button_set_badge_number adap_view_switcher_button_set_badge_number
#define adw_view_switcher_button_set_icon_name adap_view_switcher_button_set_icon_name
#define adw_view_switcher_button_set_icon_size adap_view_switcher_button_set_icon_size
#define adw_view_switcher_button_set_label adap_view_switcher_button_set_label
#define adw_view_switcher_button_set_needs_attention adap_view_switcher_button_set_needs_attention
#define adw_view_switcher_demo_window_get_type adap_view_switcher_demo_window_get_type
#define adw_view_switcher_demo_window_new adap_view_switcher_demo_window_new
#define adw_view_switcher_get_policy adap_view_switcher_get_policy
#define adw_view_switcher_get_stack adap_view_switcher_get_stack
#define adw_view_switcher_get_type adap_view_switcher_get_type
#define adw_view_switcher_new adap_view_switcher_new
#define adw_view_switcher_set_policy adap_view_switcher_set_policy
#define adw_view_switcher_set_stack adap_view_switcher_set_stack
#define adw_view_switcher_title_get_stack adap_view_switcher_title_get_stack
#define adw_view_switcher_title_get_subtitle adap_view_switcher_title_get_subtitle
#define adw_view_switcher_title_get_title adap_view_switcher_title_get_title
#define adw_view_switcher_title_get_title_visible adap_view_switcher_title_get_title_visible
#define adw_view_switcher_title_get_type adap_view_switcher_title_get_type
#define adw_view_switcher_title_get_view_switcher_enabled adap_view_switcher_title_get_view_switcher_enabled
#define adw_view_switcher_title_new adap_view_switcher_title_new
#define adw_view_switcher_title_set_stack adap_view_switcher_title_set_stack
#define adw_view_switcher_title_set_subtitle adap_view_switcher_title_set_subtitle
#define adw_view_switcher_title_set_title adap_view_switcher_title_set_title
#define adw_view_switcher_title_set_view_switcher_enabled adap_view_switcher_title_set_view_switcher_enabled
#define adw_widget_compute_expand adap_widget_compute_expand
#define adw_widget_compute_expand_horizontal_only adap_widget_compute_expand_horizontal_only
#define adw_widget_contains_passthrough adap_widget_contains_passthrough
#define adw_widget_focus_child adap_widget_focus_child
#define adw_widget_get_ancestor adap_widget_get_ancestor
#define adw_widget_get_request_mode adap_widget_get_request_mode
#define adw_widget_grab_focus_child adap_widget_grab_focus_child
#define adw_widget_grab_focus_child_or_self adap_widget_grab_focus_child_or_self
#define adw_widget_grab_focus_self adap_widget_grab_focus_self
#define adw_widget_lookup_color adap_widget_lookup_color
#define adw_window_add_breakpoint adap_window_add_breakpoint
#define adw_window_get_content adap_window_get_content
#define adw_window_get_current_breakpoint adap_window_get_current_breakpoint
#define adw_window_get_dialogs adap_window_get_dialogs
#define adw_window_get_type adap_window_get_type
#define adw_window_get_visible_dialog adap_window_get_visible_dialog
#define adw_window_new adap_window_new
#define adw_window_set_content adap_window_set_content
#define adw_window_title_get_subtitle adap_window_title_get_subtitle
#define adw_window_title_get_title adap_window_title_get_title
#define adw_window_title_get_type adap_window_title_get_type
#define adw_window_title_new adap_window_title_new
#define adw_window_title_set_subtitle adap_window_title_set_subtitle
#define adw_window_title_set_title adap_window_title_set_title

#endif /* _ADW_COMPAT_H */
