/*
 * Copyright (c) 2008, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */
package com.sun.hotspot.igv.filterwindow;

import com.sun.hotspot.igv.data.ChangedListener;
import com.sun.hotspot.igv.filter.FilterChain;
import com.sun.hotspot.igv.filter.FilterChainProvider;
import javax.swing.JComboBox;
import org.openide.util.lookup.ServiceProvider;

/**
 *
 * @author Thomas Wuerthinger
 */
@ServiceProvider(service=FilterChainProvider.class)
public class FilterChainProviderImplementation implements FilterChainProvider {

    @Override
    public FilterChain getFilterChain() {
        return FilterTopComponent.findInstance().getCurrentChain();
    }

    @Override
    public FilterChain getAllFiltersOrdered() {
        return FilterTopComponent.findInstance().getAllFiltersOrdered();
    }

    @Override
    public FilterChain createNewCustomFilterChain() {
        return FilterTopComponent.findInstance().createNewCustomFilterChain();
    }

    @Override
    public void selectFilterChain(FilterChain filterChain) {
        FilterTopComponent.findInstance().selectFilterChain(filterChain);
    }

    @Override
    public void setCustomFilterChain(FilterChain filterChain) {
        FilterTopComponent.findInstance().setCustomFilterChain(filterChain);
    }

    @Override
    public void setFilterChainSelectionChangedListener(ChangedListener<JComboBox<FilterChain>> listener) {
        FilterTopComponent.findInstance().setFilterChainSelectionChangedListener(listener);
    }
}
