# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs."""

    INTERNAL = "Internal"


class CategoryStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the category status."""

    PASSED = "Passed"
    """The category is passed."""
    FAILED = "Failed"
    """The category is failed."""
    NOT_APPLICABLE = "NotApplicable"
    """The category is not applicable."""
    PENDING_APPROVAL = "PendingApproval"
    """The category is pending for approval."""


class CheckNameAvailabilityReason(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The reason why the given name is not available."""

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"


class ContentType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """content type."""

    APPLICATION_JSON = "application/json"
    """The content type is application/json."""


class ControlFamilyStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the control family status."""

    PASSED = "Passed"
    """The control family is passed."""
    FAILED = "Failed"
    """The control family is failed."""
    NOT_APPLICABLE = "NotApplicable"
    """The control family is not applicable."""
    PENDING_APPROVAL = "PendingApproval"
    """The control family is pending for approval."""


class ControlStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the control status."""

    PASSED = "Passed"
    """The control is passed."""
    FAILED = "Failed"
    """The control is failed."""
    NOT_APPLICABLE = "NotApplicable"
    """The control is not applicable."""
    PENDING_APPROVAL = "PendingApproval"
    """The control is pending for approval."""


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of identity that created the resource."""

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"


class DeliveryStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """webhook deliveryStatus."""

    SUCCEEDED = "Succeeded"
    """The webhook is delivered successfully."""
    FAILED = "Failed"
    """The webhook is failed to deliver."""
    NOT_STARTED = "NotStarted"
    """The webhook is not delivered."""


class DownloadType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the download type."""

    COMPLIANCE_REPORT = "ComplianceReport"
    """Download the compliance report."""
    COMPLIANCE_PDF_REPORT = "CompliancePdfReport"
    """Download the compliance pdf report."""
    COMPLIANCE_DETAILED_PDF_REPORT = "ComplianceDetailedPdfReport"
    """Download the detailed compliance pdf report."""
    RESOURCE_LIST = "ResourceList"
    """Download the resource list of the report."""


class EnableSslVerification(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """whether to enable ssl verification."""

    TRUE = "true"
    """The ssl verification is enabled."""
    FALSE = "false"
    """The ssl verification is not enabled."""


class EvidenceType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Evidence type."""

    FILE = "File"
    """The evidence is a file."""
    AUTO_COLLECTED_EVIDENCE = "AutoCollectedEvidence"
    """The evidence auto collected by App Compliance Automation."""
    DATA = "Data"
    """The evidence is data."""


class InputType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Question input type."""

    NONE = "None"
    """The input type is a text box."""
    TEXT = "Text"
    """The input content is text string."""
    EMAIL = "Email"
    """The input content should be an email address."""
    MULTILINE_TEXT = "MultilineText"
    """The input content should be multiline text."""
    URL = "Url"
    """The input content should be a URL."""
    NUMBER = "Number"
    """The input content should be a number."""
    BOOLEAN = "Boolean"
    """The input content should be a boolean."""
    TELEPHONE = "Telephone"
    """The input content should be a telephone number."""
    YES_NO_NA = "YesNoNa"
    """The input content should be Yes, No or Na."""
    DATE = "Date"
    """The input content should be a date."""
    YEAR_PICKER = "YearPicker"
    """The input content is a Year, pick from the dropdown list."""
    SINGLE_SELECTION = "SingleSelection"
    """The input content is a single result seleted from the options."""
    SINGLE_SELECT_DROPDOWN = "SingleSelectDropdown"
    """The input content is a single result seleted from the dropdown options."""
    MULTI_SELECT_CHECKBOX = "MultiSelectCheckbox"
    """The input content are multiple results seleted from the checkboxes."""
    MULTI_SELECT_DROPDOWN = "MultiSelectDropdown"
    """The input content are multiple results seleted from the dropdown options."""
    MULTI_SELECT_DROPDOWN_CUSTOM = "MultiSelectDropdownCustom"
    """The input content are result seleted from the custom dropdown options."""
    GROUP = "Group"
    """The input content is a group of answers."""
    UPLOAD = "Upload"
    """The input content is a uploaded file."""


class IsRecommendSolution(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether this solution is the recommended."""

    TRUE = "true"
    """This solution is the recommended."""
    FALSE = "false"
    """This solution is not the recommended."""


class NotificationEvent(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """notification event."""

    GENERATE_SNAPSHOT_SUCCESS = "generate_snapshot_success"
    """The subscribed report's snapshot is successfully generated."""
    GENERATE_SNAPSHOT_FAILED = "generate_snapshot_failed"
    """The subscribed report's snapshot is failed to generate."""
    ASSESSMENT_FAILURE = "assessment_failure"
    """The subscribed report failed while collecting the assessments."""
    REPORT_CONFIGURATION_CHANGES = "report_configuration_changes"
    """The subscribed report's configuration is changed."""
    REPORT_DELETION = "report_deletion"
    """The subscribed report is deleted."""


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource provisioning states."""

    SUCCEEDED = "Succeeded"
    """The provision is succeeded."""
    FAILED = "Failed"
    """The provision is failed."""
    CANCELED = "Canceled"
    """The provision is canceled."""
    CREATING = "Creating"
    """The creation is in progress."""
    DELETING = "Deleting"
    """The deletion is in progress."""
    FIXING = "Fixing"
    """The fix of the resource in progress."""
    VERIFYING = "Verifying"
    """The verification of the resource in progress."""
    UPDATING = "Updating"
    """The update of the resource in progress."""


class ReportStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Report status."""

    ACTIVE = "Active"
    """The report is active."""
    FAILED = "Failed"
    """The report is failed."""
    REVIEWING = "Reviewing"
    """The report is under reviewing."""
    DISABLED = "Disabled"
    """The report is disabled."""


class ResourceOrigin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource Origin."""

    AZURE = "Azure"
    """The resource is from Azure."""
    AWS = "AWS"
    """The resource is from AWS."""
    GCP = "GCP"
    """The resource is from GCP."""


class ResourceStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the resource status."""

    HEALTHY = "Healthy"
    """The resource is healthy."""
    UNHEALTHY = "Unhealthy"
    """The resource is unhealthy."""


class ResponsibilityEnvironment(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the customer responsibility supported cloud environment."""

    AZURE = "Azure"
    """The responsibility is supported in Azure."""
    AWS = "AWS"
    """The responsibility is supported in AWS."""
    GCP = "GCP"
    """The responsibility is supported in GCP."""
    GENERAL = "General"
    """The responsibility is general requirement of all environment."""


class ResponsibilitySeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the customer responsibility severity."""

    HIGH = "High"
    """The responsibility is high severity."""
    MEDIUM = "Medium"
    """The responsibility is medium severity."""
    LOW = "Low"
    """The responsibility is low severity."""


class ResponsibilityStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the customer responsibility status."""

    PASSED = "Passed"
    """The responsibility is passed."""
    FAILED = "Failed"
    """The responsibility is failed."""
    NOT_APPLICABLE = "NotApplicable"
    """The responsibility is not applicable."""
    PENDING_APPROVAL = "PendingApproval"
    """The responsibility is pending for approval."""


class ResponsibilityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates the customer responsibility type."""

    AUTOMATED = "Automated"
    """The responsibility is automated."""
    SCOPED_MANUAL = "ScopedManual"
    """The responsibility is scoped manual."""
    MANUAL = "Manual"
    """The responsibility is manual."""


class Result(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Indicates whether the fix action is Succeeded or Failed."""

    SUCCEEDED = "Succeeded"
    """The result is succeeded."""
    FAILED = "Failed"
    """The result is failed."""


class Rule(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Scoping question rule."""

    REQUIRED = "Required"
    """The question is required to answer."""
    CHAR_LENGTH = "CharLength"
    """The question answer length is limited."""
    URL = "Url"
    """The question answer should be an Url."""
    URLS = "Urls"
    """The question answer should be Urls."""
    DOMAINS = "Domains"
    """The question answer should be domains."""
    US_PRIVACY_SHIELD = "USPrivacyShield"
    """The question answer should be a UsPrivacyShield."""
    PUBLIC_SOX = "PublicSOX"
    """The question answer should be a PublicSOX."""
    CREDIT_CARD_PCI = "CreditCardPCI"
    """The question answer should be a CreditCardPCI."""
    AZURE_APPLICATION = "AzureApplication"
    """The question answer should be an AzureApplication."""
    VALID_GUID = "ValidGuid"
    """The question answer should be a valid guid."""
    PUBLISHER_VERIFICATION = "PublisherVerification"
    """The question answer should be publisher verification."""
    DYNAMIC_DROPDOWN = "DynamicDropdown"
    """The question answer should be dynamic dropdown."""
    PREVENT_NON_ENGLISH_CHAR = "PreventNonEnglishChar"
    """The question answer should prevent non-english char."""
    VALID_EMAIL = "ValidEmail"
    """The question answer should be a valid email."""


class SendAllEvents(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """whether to send notification under any event."""

    TRUE = "true"
    """Need send notification under any event."""
    FALSE = "false"
    """No need to send notification under any event."""


class UpdateWebhookKey(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """whether to update webhookKey."""

    TRUE = "true"
    """Need update the webhook key."""
    FALSE = "false"
    """No need to update the webhook key."""


class WebhookKeyEnabled(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """whether webhookKey is enabled."""

    TRUE = "true"
    """The webhookKey is enabled."""
    FALSE = "false"
    """The webhookKey is not enabled."""


class WebhookStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Webhook status."""

    ENABLED = "Enabled"
    """The webhook is enabled."""
    DISABLED = "Disabled"
    """The webhook is disabled."""
