# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models


class ARMBaseModel(_serialization.Model):
    """Represents the base class for all object models.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None


class Addon(ARMBaseModel):
    """Role Addon.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ArcAddon, IoTAddon

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Addon type. Required. Known values are: "IotEdge" and "ArcForKubernetes".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.AddonType
    :ivar system_data: Addon type.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    _subtype_map = {"kind": {"ArcForKubernetes": "ArcAddon", "IotEdge": "IoTAddon"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class AddonList(_serialization.Model):
    """Collection of all the Role addon on the Azure Stack Edge device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The Value.
    :vartype value: list[~azure.mgmt.databoxedge.models.Addon]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Addon]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Addon"]] = None
        self.next_link: Optional[str] = None


class Address(_serialization.Model):
    """The shipping address of the customer.

    All required parameters must be populated in order to send to server.

    :ivar address_line1: The address line1.
    :vartype address_line1: str
    :ivar address_line2: The address line2.
    :vartype address_line2: str
    :ivar address_line3: The address line3.
    :vartype address_line3: str
    :ivar postal_code: The postal code.
    :vartype postal_code: str
    :ivar city: The city name.
    :vartype city: str
    :ivar state: The state name.
    :vartype state: str
    :ivar country: The country name. Required.
    :vartype country: str
    """

    _validation = {
        "country": {"required": True},
    }

    _attribute_map = {
        "address_line1": {"key": "addressLine1", "type": "str"},
        "address_line2": {"key": "addressLine2", "type": "str"},
        "address_line3": {"key": "addressLine3", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "country": {"key": "country", "type": "str"},
    }

    def __init__(
        self,
        *,
        country: str,
        address_line1: Optional[str] = None,
        address_line2: Optional[str] = None,
        address_line3: Optional[str] = None,
        postal_code: Optional[str] = None,
        city: Optional[str] = None,
        state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address_line1: The address line1.
        :paramtype address_line1: str
        :keyword address_line2: The address line2.
        :paramtype address_line2: str
        :keyword address_line3: The address line3.
        :paramtype address_line3: str
        :keyword postal_code: The postal code.
        :paramtype postal_code: str
        :keyword city: The city name.
        :paramtype city: str
        :keyword state: The state name.
        :paramtype state: str
        :keyword country: The country name. Required.
        :paramtype country: str
        """
        super().__init__(**kwargs)
        self.address_line1 = address_line1
        self.address_line2 = address_line2
        self.address_line3 = address_line3
        self.postal_code = postal_code
        self.city = city
        self.state = state
        self.country = country


class Alert(ARMBaseModel):
    """Alert on the data box edge/gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Alert generated in the resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar title: Alert title.
    :vartype title: str
    :ivar alert_type: Alert type.
    :vartype alert_type: str
    :ivar appeared_at_date_time: UTC time when the alert appeared.
    :vartype appeared_at_date_time: ~datetime.datetime
    :ivar recommendation: Alert recommendation.
    :vartype recommendation: str
    :ivar severity: Severity of the alert. Known values are: "Informational", "Warning", and
     "Critical".
    :vartype severity: str or ~azure.mgmt.databoxedge.models.AlertSeverity
    :ivar error_details: Error details of the alert.
    :vartype error_details: ~azure.mgmt.databoxedge.models.AlertErrorDetails
    :ivar detailed_information: Alert details.
    :vartype detailed_information: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "title": {"readonly": True},
        "alert_type": {"readonly": True},
        "appeared_at_date_time": {"readonly": True},
        "recommendation": {"readonly": True},
        "severity": {"readonly": True},
        "error_details": {"readonly": True},
        "detailed_information": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "title": {"key": "properties.title", "type": "str"},
        "alert_type": {"key": "properties.alertType", "type": "str"},
        "appeared_at_date_time": {"key": "properties.appearedAtDateTime", "type": "iso-8601"},
        "recommendation": {"key": "properties.recommendation", "type": "str"},
        "severity": {"key": "properties.severity", "type": "str"},
        "error_details": {"key": "properties.errorDetails", "type": "AlertErrorDetails"},
        "detailed_information": {"key": "properties.detailedInformation", "type": "{str}"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.title: Optional[str] = None
        self.alert_type: Optional[str] = None
        self.appeared_at_date_time: Optional[datetime.datetime] = None
        self.recommendation: Optional[str] = None
        self.severity: Optional[Union[str, "_models.AlertSeverity"]] = None
        self.error_details: Optional["_models.AlertErrorDetails"] = None
        self.detailed_information: Optional[Dict[str, str]] = None


class AlertErrorDetails(_serialization.Model):
    """Error details for the alert.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: Error code.
    :vartype error_code: str
    :ivar error_message: Error Message.
    :vartype error_message: str
    :ivar occurrences: Number of occurrences.
    :vartype occurrences: int
    """

    _validation = {
        "error_code": {"readonly": True},
        "error_message": {"readonly": True},
        "occurrences": {"readonly": True},
    }

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "occurrences": {"key": "occurrences", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error_code: Optional[str] = None
        self.error_message: Optional[str] = None
        self.occurrences: Optional[int] = None


class AlertList(_serialization.Model):
    """Collection of alerts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The value.
    :vartype value: list[~azure.mgmt.databoxedge.models.Alert]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Alert]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Alert"]] = None
        self.next_link: Optional[str] = None


class ArcAddon(Addon):
    """Arc Addon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Addon type. Required. Known values are: "IotEdge" and "ArcForKubernetes".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.AddonType
    :ivar system_data: Addon type.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar subscription_id: Arc resource subscription Id. Required.
    :vartype subscription_id: str
    :ivar resource_group_name: Arc resource group name. Required.
    :vartype resource_group_name: str
    :ivar resource_name: Arc resource Name. Required.
    :vartype resource_name: str
    :ivar resource_location: Arc resource location. Required.
    :vartype resource_location: str
    :ivar version: Arc resource version.
    :vartype version: str
    :ivar host_platform: Host OS supported by the Arc addon. Known values are: "Windows" and
     "Linux".
    :vartype host_platform: str or ~azure.mgmt.databoxedge.models.PlatformType
    :ivar host_platform_type: Platform where the runtime is hosted. Known values are:
     "KubernetesCluster" and "LinuxVM".
    :vartype host_platform_type: str or ~azure.mgmt.databoxedge.models.HostPlatformType
    :ivar provisioning_state: Addon Provisioning State. Known values are: "Invalid", "Creating",
     "Created", "Updating", "Reconfiguring", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.databoxedge.models.AddonState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
        "subscription_id": {"required": True},
        "resource_group_name": {"required": True},
        "resource_name": {"required": True},
        "resource_location": {"required": True},
        "version": {"readonly": True},
        "host_platform": {"readonly": True},
        "host_platform_type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "subscription_id": {"key": "properties.subscriptionId", "type": "str"},
        "resource_group_name": {"key": "properties.resourceGroupName", "type": "str"},
        "resource_name": {"key": "properties.resourceName", "type": "str"},
        "resource_location": {"key": "properties.resourceLocation", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "host_platform": {"key": "properties.hostPlatform", "type": "str"},
        "host_platform_type": {"key": "properties.hostPlatformType", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        subscription_id: str,
        resource_group_name: str,
        resource_name: str,
        resource_location: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword subscription_id: Arc resource subscription Id. Required.
        :paramtype subscription_id: str
        :keyword resource_group_name: Arc resource group name. Required.
        :paramtype resource_group_name: str
        :keyword resource_name: Arc resource Name. Required.
        :paramtype resource_name: str
        :keyword resource_location: Arc resource location. Required.
        :paramtype resource_location: str
        """
        super().__init__(**kwargs)
        self.kind: str = "ArcForKubernetes"
        self.subscription_id = subscription_id
        self.resource_group_name = resource_group_name
        self.resource_name = resource_name
        self.resource_location = resource_location
        self.version: Optional[str] = None
        self.host_platform: Optional[Union[str, "_models.PlatformType"]] = None
        self.host_platform_type: Optional[Union[str, "_models.HostPlatformType"]] = None
        self.provisioning_state: Optional[Union[str, "_models.AddonState"]] = None


class AsymmetricEncryptedSecret(_serialization.Model):
    """Represent the secrets intended for encryption with asymmetric key pair.

    All required parameters must be populated in order to send to server.

    :ivar value: The value of the secret. Required.
    :vartype value: str
    :ivar encryption_cert_thumbprint: Thumbprint certificate used to encrypt \\"Value\\". If the
     value is unencrypted, it will be null.
    :vartype encryption_cert_thumbprint: str
    :ivar encryption_algorithm: The algorithm used to encrypt "Value". Required. Known values are:
     "None", "AES256", and "RSAES_PKCS1_v_1_5".
    :vartype encryption_algorithm: str or ~azure.mgmt.databoxedge.models.EncryptionAlgorithm
    """

    _validation = {
        "value": {"required": True},
        "encryption_algorithm": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "encryption_cert_thumbprint": {"key": "encryptionCertThumbprint", "type": "str"},
        "encryption_algorithm": {"key": "encryptionAlgorithm", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: str,
        encryption_algorithm: Union[str, "_models.EncryptionAlgorithm"],
        encryption_cert_thumbprint: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The value of the secret. Required.
        :paramtype value: str
        :keyword encryption_cert_thumbprint: Thumbprint certificate used to encrypt \\"Value\\". If the
         value is unencrypted, it will be null.
        :paramtype encryption_cert_thumbprint: str
        :keyword encryption_algorithm: The algorithm used to encrypt "Value". Required. Known values
         are: "None", "AES256", and "RSAES_PKCS1_v_1_5".
        :paramtype encryption_algorithm: str or ~azure.mgmt.databoxedge.models.EncryptionAlgorithm
        """
        super().__init__(**kwargs)
        self.value = value
        self.encryption_cert_thumbprint = encryption_cert_thumbprint
        self.encryption_algorithm = encryption_algorithm


class Authentication(_serialization.Model):
    """Authentication mechanism for IoT devices.

    :ivar symmetric_key: Symmetric key for authentication.
    :vartype symmetric_key: ~azure.mgmt.databoxedge.models.SymmetricKey
    """

    _attribute_map = {
        "symmetric_key": {"key": "symmetricKey", "type": "SymmetricKey"},
    }

    def __init__(self, *, symmetric_key: Optional["_models.SymmetricKey"] = None, **kwargs: Any) -> None:
        """
        :keyword symmetric_key: Symmetric key for authentication.
        :paramtype symmetric_key: ~azure.mgmt.databoxedge.models.SymmetricKey
        """
        super().__init__(**kwargs)
        self.symmetric_key = symmetric_key


class AzureContainerInfo(_serialization.Model):
    """Azure container mapping of the endpoint.

    All required parameters must be populated in order to send to server.

    :ivar storage_account_credential_id: ID of the storage account credential used to access
     storage. Required.
    :vartype storage_account_credential_id: str
    :ivar container_name: Container name (Based on the data format specified, this represents the
     name of Azure Files/Page blob/Block blob). Required.
    :vartype container_name: str
    :ivar data_format: Storage format used for the file represented by the share. Required. Known
     values are: "BlockBlob", "PageBlob", and "AzureFile".
    :vartype data_format: str or ~azure.mgmt.databoxedge.models.AzureContainerDataFormat
    """

    _validation = {
        "storage_account_credential_id": {"required": True},
        "container_name": {"required": True},
        "data_format": {"required": True},
    }

    _attribute_map = {
        "storage_account_credential_id": {"key": "storageAccountCredentialId", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "data_format": {"key": "dataFormat", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_account_credential_id: str,
        container_name: str,
        data_format: Union[str, "_models.AzureContainerDataFormat"],
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_account_credential_id: ID of the storage account credential used to access
         storage. Required.
        :paramtype storage_account_credential_id: str
        :keyword container_name: Container name (Based on the data format specified, this represents
         the name of Azure Files/Page blob/Block blob). Required.
        :paramtype container_name: str
        :keyword data_format: Storage format used for the file represented by the share. Required.
         Known values are: "BlockBlob", "PageBlob", and "AzureFile".
        :paramtype data_format: str or ~azure.mgmt.databoxedge.models.AzureContainerDataFormat
        """
        super().__init__(**kwargs)
        self.storage_account_credential_id = storage_account_credential_id
        self.container_name = container_name
        self.data_format = data_format


class BandwidthSchedule(ARMBaseModel):
    """The bandwidth schedule details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Bandwidth object related to ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar start: The start time of the schedule in UTC. Required.
    :vartype start: str
    :ivar stop: The stop time of the schedule in UTC. Required.
    :vartype stop: str
    :ivar rate_in_mbps: The bandwidth rate in Mbps. Required.
    :vartype rate_in_mbps: int
    :ivar days: The days of the week when this schedule is applicable. Required.
    :vartype days: list[str or ~azure.mgmt.databoxedge.models.DayOfWeek]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "start": {"required": True},
        "stop": {"required": True},
        "rate_in_mbps": {"required": True},
        "days": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "start": {"key": "properties.start", "type": "str"},
        "stop": {"key": "properties.stop", "type": "str"},
        "rate_in_mbps": {"key": "properties.rateInMbps", "type": "int"},
        "days": {"key": "properties.days", "type": "[str]"},
    }

    def __init__(
        self, *, start: str, stop: str, rate_in_mbps: int, days: List[Union[str, "_models.DayOfWeek"]], **kwargs: Any
    ) -> None:
        """
        :keyword start: The start time of the schedule in UTC. Required.
        :paramtype start: str
        :keyword stop: The stop time of the schedule in UTC. Required.
        :paramtype stop: str
        :keyword rate_in_mbps: The bandwidth rate in Mbps. Required.
        :paramtype rate_in_mbps: int
        :keyword days: The days of the week when this schedule is applicable. Required.
        :paramtype days: list[str or ~azure.mgmt.databoxedge.models.DayOfWeek]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.start = start
        self.stop = stop
        self.rate_in_mbps = rate_in_mbps
        self.days = days


class BandwidthSchedulesList(_serialization.Model):
    """The collection of bandwidth schedules.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of bandwidth schedules.
    :vartype value: list[~azure.mgmt.databoxedge.models.BandwidthSchedule]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[BandwidthSchedule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.BandwidthSchedule"]] = None
        self.next_link: Optional[str] = None


class ClientAccessRight(_serialization.Model):
    """The mapping between a particular client IP and the type of access client has on the NFS share.

    All required parameters must be populated in order to send to server.

    :ivar client: IP of the client. Required.
    :vartype client: str
    :ivar access_permission: Type of access to be allowed for the client. Required. Known values
     are: "NoAccess", "ReadOnly", and "ReadWrite".
    :vartype access_permission: str or ~azure.mgmt.databoxedge.models.ClientPermissionType
    """

    _validation = {
        "client": {"required": True},
        "access_permission": {"required": True},
    }

    _attribute_map = {
        "client": {"key": "client", "type": "str"},
        "access_permission": {"key": "accessPermission", "type": "str"},
    }

    def __init__(
        self, *, client: str, access_permission: Union[str, "_models.ClientPermissionType"], **kwargs: Any
    ) -> None:
        """
        :keyword client: IP of the client. Required.
        :paramtype client: str
        :keyword access_permission: Type of access to be allowed for the client. Required. Known values
         are: "NoAccess", "ReadOnly", and "ReadWrite".
        :paramtype access_permission: str or ~azure.mgmt.databoxedge.models.ClientPermissionType
        """
        super().__init__(**kwargs)
        self.client = client
        self.access_permission = access_permission


class Role(ARMBaseModel):
    """Compute role.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CloudEdgeManagementRole, IoTRole, KubernetesRole, MECRole

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Role type. Required. Known values are: "IOT", "ASA", "Functions", "Cognitive",
     "MEC", "CloudEdgeManagement", and "Kubernetes".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.RoleTypes
    :ivar system_data: Role configured on ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    _subtype_map = {
        "kind": {
            "CloudEdgeManagement": "CloudEdgeManagementRole",
            "IOT": "IoTRole",
            "Kubernetes": "KubernetesRole",
            "MEC": "MECRole",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kind: Optional[str] = None
        self.system_data: Optional["_models.SystemData"] = None


class CloudEdgeManagementRole(Role):
    """CloudEdgeManagementRole role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Role type. Required. Known values are: "IOT", "ASA", "Functions", "Cognitive",
     "MEC", "CloudEdgeManagement", and "Kubernetes".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.RoleTypes
    :ivar system_data: Role configured on ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar local_management_status: Local Edge Management Status. Known values are: "Enabled" and
     "Disabled".
    :vartype local_management_status: str or ~azure.mgmt.databoxedge.models.RoleStatus
    :ivar edge_profile: Edge Profile of the resource.
    :vartype edge_profile: ~azure.mgmt.databoxedge.models.EdgeProfile
    :ivar role_status: Role status. Known values are: "Enabled" and "Disabled".
    :vartype role_status: str or ~azure.mgmt.databoxedge.models.RoleStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
        "local_management_status": {"readonly": True},
        "edge_profile": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "local_management_status": {"key": "properties.localManagementStatus", "type": "str"},
        "edge_profile": {"key": "properties.edgeProfile", "type": "EdgeProfile"},
        "role_status": {"key": "properties.roleStatus", "type": "str"},
    }

    def __init__(self, *, role_status: Optional[Union[str, "_models.RoleStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword role_status: Role status. Known values are: "Enabled" and "Disabled".
        :paramtype role_status: str or ~azure.mgmt.databoxedge.models.RoleStatus
        """
        super().__init__(**kwargs)
        self.kind: str = "CloudEdgeManagement"
        self.local_management_status: Optional[Union[str, "_models.RoleStatus"]] = None
        self.edge_profile: Optional["_models.EdgeProfile"] = None
        self.role_status = role_status


class CloudErrorBody(_serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.databoxedge.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.databoxedge.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details


class CniConfig(_serialization.Model):
    """Cni configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Cni type.
    :vartype type: str
    :ivar version: Cni version.
    :vartype version: str
    :ivar pod_subnet: Pod Subnet.
    :vartype pod_subnet: str
    :ivar service_subnet: Service subnet.
    :vartype service_subnet: str
    """

    _validation = {
        "type": {"readonly": True},
        "version": {"readonly": True},
        "pod_subnet": {"readonly": True},
        "service_subnet": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "pod_subnet": {"key": "podSubnet", "type": "str"},
        "service_subnet": {"key": "serviceSubnet", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.version: Optional[str] = None
        self.pod_subnet: Optional[str] = None
        self.service_subnet: Optional[str] = None


class ComputeResource(_serialization.Model):
    """Compute infrastructure Resource.

    All required parameters must be populated in order to send to server.

    :ivar processor_count: Processor count. Required.
    :vartype processor_count: int
    :ivar memory_in_gb: Memory in GB. Required.
    :vartype memory_in_gb: int
    """

    _validation = {
        "processor_count": {"required": True},
        "memory_in_gb": {"required": True},
    }

    _attribute_map = {
        "processor_count": {"key": "processorCount", "type": "int"},
        "memory_in_gb": {"key": "memoryInGB", "type": "int"},
    }

    def __init__(self, *, processor_count: int, memory_in_gb: int, **kwargs: Any) -> None:
        """
        :keyword processor_count: Processor count. Required.
        :paramtype processor_count: int
        :keyword memory_in_gb: Memory in GB. Required.
        :paramtype memory_in_gb: int
        """
        super().__init__(**kwargs)
        self.processor_count = processor_count
        self.memory_in_gb = memory_in_gb


class ContactDetails(_serialization.Model):
    """Contains all the contact details of the customer.

    All required parameters must be populated in order to send to server.

    :ivar contact_person: The contact person name. Required.
    :vartype contact_person: str
    :ivar company_name: The name of the company. Required.
    :vartype company_name: str
    :ivar phone: The phone number. Required.
    :vartype phone: str
    :ivar email_list: The email list. Required.
    :vartype email_list: list[str]
    """

    _validation = {
        "contact_person": {"required": True},
        "company_name": {"required": True},
        "phone": {"required": True},
        "email_list": {"required": True},
    }

    _attribute_map = {
        "contact_person": {"key": "contactPerson", "type": "str"},
        "company_name": {"key": "companyName", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
        "email_list": {"key": "emailList", "type": "[str]"},
    }

    def __init__(
        self, *, contact_person: str, company_name: str, phone: str, email_list: List[str], **kwargs: Any
    ) -> None:
        """
        :keyword contact_person: The contact person name. Required.
        :paramtype contact_person: str
        :keyword company_name: The name of the company. Required.
        :paramtype company_name: str
        :keyword phone: The phone number. Required.
        :paramtype phone: str
        :keyword email_list: The email list. Required.
        :paramtype email_list: list[str]
        """
        super().__init__(**kwargs)
        self.contact_person = contact_person
        self.company_name = company_name
        self.phone = phone
        self.email_list = email_list


class Container(ARMBaseModel):
    """Represents a container on the  Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Container in DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar container_status: Current status of the container. Known values are: "OK", "Offline",
     "Unknown", "Updating", and "NeedsAttention".
    :vartype container_status: str or ~azure.mgmt.databoxedge.models.ContainerStatus
    :ivar data_format: DataFormat for Container. Required. Known values are: "BlockBlob",
     "PageBlob", and "AzureFile".
    :vartype data_format: str or ~azure.mgmt.databoxedge.models.AzureContainerDataFormat
    :ivar refresh_details: Details of the refresh job on this container.
    :vartype refresh_details: ~azure.mgmt.databoxedge.models.RefreshDetails
    :ivar created_date_time: The UTC time when container got created.
    :vartype created_date_time: ~datetime.datetime
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "container_status": {"readonly": True},
        "data_format": {"required": True},
        "refresh_details": {"readonly": True},
        "created_date_time": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "container_status": {"key": "properties.containerStatus", "type": "str"},
        "data_format": {"key": "properties.dataFormat", "type": "str"},
        "refresh_details": {"key": "properties.refreshDetails", "type": "RefreshDetails"},
        "created_date_time": {"key": "properties.createdDateTime", "type": "iso-8601"},
    }

    def __init__(self, *, data_format: Union[str, "_models.AzureContainerDataFormat"], **kwargs: Any) -> None:
        """
        :keyword data_format: DataFormat for Container. Required. Known values are: "BlockBlob",
         "PageBlob", and "AzureFile".
        :paramtype data_format: str or ~azure.mgmt.databoxedge.models.AzureContainerDataFormat
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.container_status: Optional[Union[str, "_models.ContainerStatus"]] = None
        self.data_format = data_format
        self.refresh_details: Optional["_models.RefreshDetails"] = None
        self.created_date_time: Optional[datetime.datetime] = None


class ContainerList(_serialization.Model):
    """Collection of all the containers on the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of containers.
    :vartype value: list[~azure.mgmt.databoxedge.models.Container]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Container]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Container"]] = None
        self.next_link: Optional[str] = None


class DataBoxEdgeDevice(ARMBaseModel):
    """The Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar location: The location of the device. This is a supported and registered Azure
     geographical region (for example, West US, East US, or Southeast Asia). The geographical region
     of a device cannot be changed once it is created, but if an identical geographical region is
     specified on update, the request will succeed. Required.
    :vartype location: str
    :ivar tags: The list of tags that describe the device. These tags can be used to view and group
     this device (across resource groups).
    :vartype tags: dict[str, str]
    :ivar sku: The SKU type.
    :vartype sku: ~azure.mgmt.databoxedge.models.Sku
    :ivar etag: The etag for the devices.
    :vartype etag: str
    :ivar identity: Msi identity of the resource.
    :vartype identity: ~azure.mgmt.databoxedge.models.ResourceIdentity
    :ivar kind: The etag for the devices. Known values are: "AzureDataBoxGateway",
     "AzureStackEdge", "AzureStackHub", and "AzureModularDataCentre".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.DataBoxEdgeDeviceKind
    :ivar system_data: DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar data_box_edge_device_status: The status of the Data Box Edge/Gateway device. Known values
     are: "ReadyToSetup", "Online", "Offline", "NeedsAttention", "Disconnected",
     "PartiallyDisconnected", and "Maintenance".
    :vartype data_box_edge_device_status: str or
     ~azure.mgmt.databoxedge.models.DataBoxEdgeDeviceStatus
    :ivar serial_number: The Serial Number of Data Box Edge/Gateway device.
    :vartype serial_number: str
    :ivar description: The Description of the Data Box Edge/Gateway device.
    :vartype description: str
    :ivar model_description: The description of the Data Box Edge/Gateway device model.
    :vartype model_description: str
    :ivar device_type: The type of the Data Box Edge/Gateway device. "DataBoxEdgeDevice"
    :vartype device_type: str or ~azure.mgmt.databoxedge.models.DeviceType
    :ivar friendly_name: The Data Box Edge/Gateway device name.
    :vartype friendly_name: str
    :ivar culture: The Data Box Edge/Gateway device culture.
    :vartype culture: str
    :ivar device_model: The Data Box Edge/Gateway device model.
    :vartype device_model: str
    :ivar device_software_version: The Data Box Edge/Gateway device software version.
    :vartype device_software_version: str
    :ivar device_local_capacity: The Data Box Edge/Gateway device local capacity in MB.
    :vartype device_local_capacity: int
    :ivar time_zone: The Data Box Edge/Gateway device timezone.
    :vartype time_zone: str
    :ivar device_hcs_version: The device software version number of the device (eg: 1.2.18105.6).
    :vartype device_hcs_version: str
    :ivar configured_role_types: Type of compute roles configured.
    :vartype configured_role_types: list[str or ~azure.mgmt.databoxedge.models.RoleTypes]
    :ivar node_count: The number of nodes in the cluster.
    :vartype node_count: int
    :ivar resource_move_details: The details of the move operation on this resource.
    :vartype resource_move_details: ~azure.mgmt.databoxedge.models.ResourceMoveDetails
    :ivar edge_profile: The details of Edge Profile for this resource.
    :vartype edge_profile: ~azure.mgmt.databoxedge.models.EdgeProfile
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "kind": {"readonly": True},
        "system_data": {"readonly": True},
        "serial_number": {"readonly": True},
        "description": {"readonly": True},
        "model_description": {"readonly": True},
        "device_type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "culture": {"readonly": True},
        "device_model": {"readonly": True},
        "device_software_version": {"readonly": True},
        "device_local_capacity": {"readonly": True},
        "time_zone": {"readonly": True},
        "device_hcs_version": {"readonly": True},
        "configured_role_types": {"readonly": True},
        "node_count": {"readonly": True},
        "resource_move_details": {"readonly": True},
        "edge_profile": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "etag": {"key": "etag", "type": "str"},
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "data_box_edge_device_status": {"key": "properties.dataBoxEdgeDeviceStatus", "type": "str"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "model_description": {"key": "properties.modelDescription", "type": "str"},
        "device_type": {"key": "properties.deviceType", "type": "str"},
        "friendly_name": {"key": "properties.friendlyName", "type": "str"},
        "culture": {"key": "properties.culture", "type": "str"},
        "device_model": {"key": "properties.deviceModel", "type": "str"},
        "device_software_version": {"key": "properties.deviceSoftwareVersion", "type": "str"},
        "device_local_capacity": {"key": "properties.deviceLocalCapacity", "type": "int"},
        "time_zone": {"key": "properties.timeZone", "type": "str"},
        "device_hcs_version": {"key": "properties.deviceHcsVersion", "type": "str"},
        "configured_role_types": {"key": "properties.configuredRoleTypes", "type": "[str]"},
        "node_count": {"key": "properties.nodeCount", "type": "int"},
        "resource_move_details": {"key": "properties.resourceMoveDetails", "type": "ResourceMoveDetails"},
        "edge_profile": {"key": "properties.edgeProfile", "type": "EdgeProfile"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.Sku"] = None,
        etag: Optional[str] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        data_box_edge_device_status: Optional[Union[str, "_models.DataBoxEdgeDeviceStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the device. This is a supported and registered Azure
         geographical region (for example, West US, East US, or Southeast Asia). The geographical region
         of a device cannot be changed once it is created, but if an identical geographical region is
         specified on update, the request will succeed. Required.
        :paramtype location: str
        :keyword tags: The list of tags that describe the device. These tags can be used to view and
         group this device (across resource groups).
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU type.
        :paramtype sku: ~azure.mgmt.databoxedge.models.Sku
        :keyword etag: The etag for the devices.
        :paramtype etag: str
        :keyword identity: Msi identity of the resource.
        :paramtype identity: ~azure.mgmt.databoxedge.models.ResourceIdentity
        :keyword data_box_edge_device_status: The status of the Data Box Edge/Gateway device. Known
         values are: "ReadyToSetup", "Online", "Offline", "NeedsAttention", "Disconnected",
         "PartiallyDisconnected", and "Maintenance".
        :paramtype data_box_edge_device_status: str or
         ~azure.mgmt.databoxedge.models.DataBoxEdgeDeviceStatus
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.sku = sku
        self.etag = etag
        self.identity = identity
        self.kind: Optional[Union[str, "_models.DataBoxEdgeDeviceKind"]] = None
        self.system_data: Optional["_models.SystemData"] = None
        self.data_box_edge_device_status = data_box_edge_device_status
        self.serial_number: Optional[str] = None
        self.description: Optional[str] = None
        self.model_description: Optional[str] = None
        self.device_type: Optional[Union[str, "_models.DeviceType"]] = None
        self.friendly_name: Optional[str] = None
        self.culture: Optional[str] = None
        self.device_model: Optional[str] = None
        self.device_software_version: Optional[str] = None
        self.device_local_capacity: Optional[int] = None
        self.time_zone: Optional[str] = None
        self.device_hcs_version: Optional[str] = None
        self.configured_role_types: Optional[List[Union[str, "_models.RoleTypes"]]] = None
        self.node_count: Optional[int] = None
        self.resource_move_details: Optional["_models.ResourceMoveDetails"] = None
        self.edge_profile: Optional["_models.EdgeProfile"] = None


class DataBoxEdgeDeviceExtendedInfo(ARMBaseModel):
    """The extended Info of the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar encryption_key_thumbprint: The digital signature of encrypted certificate.
    :vartype encryption_key_thumbprint: str
    :ivar encryption_key: The public part of the encryption certificate. Client uses this to
     encrypt any secret.
    :vartype encryption_key: str
    :ivar resource_key: The Resource ID of the Resource.
    :vartype resource_key: str
    :ivar client_secret_store_id: The Key Vault ARM Id for client secrets.
    :vartype client_secret_store_id: str
    :ivar client_secret_store_url: The url to access the Client Key Vault.
    :vartype client_secret_store_url: str
    :ivar channel_integrity_key_name: The name of Channel Integrity Key stored in the Client Key
     Vault.
    :vartype channel_integrity_key_name: str
    :ivar channel_integrity_key_version: The version of Channel Integrity Key stored in the Client
     Key Vault.
    :vartype channel_integrity_key_version: str
    :ivar key_vault_sync_status: Key vault sync status. Known values are: "KeyVaultSynced",
     "KeyVaultSyncFailed", "KeyVaultNotConfigured", "KeyVaultSyncPending", "KeyVaultSyncing", and
     "KeyVaultNotSynced".
    :vartype key_vault_sync_status: str or ~azure.mgmt.databoxedge.models.KeyVaultSyncStatus
    :ivar device_secrets: Device secrets, will be returned only with ODataFilter
     $expand=deviceSecrets.
    :vartype device_secrets: dict[str, ~azure.mgmt.databoxedge.models.Secret]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "resource_key": {"readonly": True},
        "device_secrets": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "encryption_key_thumbprint": {"key": "properties.encryptionKeyThumbprint", "type": "str"},
        "encryption_key": {"key": "properties.encryptionKey", "type": "str"},
        "resource_key": {"key": "properties.resourceKey", "type": "str"},
        "client_secret_store_id": {"key": "properties.clientSecretStoreId", "type": "str"},
        "client_secret_store_url": {"key": "properties.clientSecretStoreUrl", "type": "str"},
        "channel_integrity_key_name": {"key": "properties.channelIntegrityKeyName", "type": "str"},
        "channel_integrity_key_version": {"key": "properties.channelIntegrityKeyVersion", "type": "str"},
        "key_vault_sync_status": {"key": "properties.keyVaultSyncStatus", "type": "str"},
        "device_secrets": {"key": "properties.deviceSecrets", "type": "{Secret}"},
    }

    def __init__(
        self,
        *,
        encryption_key_thumbprint: Optional[str] = None,
        encryption_key: Optional[str] = None,
        client_secret_store_id: Optional[str] = None,
        client_secret_store_url: Optional[str] = None,
        channel_integrity_key_name: Optional[str] = None,
        channel_integrity_key_version: Optional[str] = None,
        key_vault_sync_status: Optional[Union[str, "_models.KeyVaultSyncStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encryption_key_thumbprint: The digital signature of encrypted certificate.
        :paramtype encryption_key_thumbprint: str
        :keyword encryption_key: The public part of the encryption certificate. Client uses this to
         encrypt any secret.
        :paramtype encryption_key: str
        :keyword client_secret_store_id: The Key Vault ARM Id for client secrets.
        :paramtype client_secret_store_id: str
        :keyword client_secret_store_url: The url to access the Client Key Vault.
        :paramtype client_secret_store_url: str
        :keyword channel_integrity_key_name: The name of Channel Integrity Key stored in the Client Key
         Vault.
        :paramtype channel_integrity_key_name: str
        :keyword channel_integrity_key_version: The version of Channel Integrity Key stored in the
         Client Key Vault.
        :paramtype channel_integrity_key_version: str
        :keyword key_vault_sync_status: Key vault sync status. Known values are: "KeyVaultSynced",
         "KeyVaultSyncFailed", "KeyVaultNotConfigured", "KeyVaultSyncPending", "KeyVaultSyncing", and
         "KeyVaultNotSynced".
        :paramtype key_vault_sync_status: str or ~azure.mgmt.databoxedge.models.KeyVaultSyncStatus
        """
        super().__init__(**kwargs)
        self.encryption_key_thumbprint = encryption_key_thumbprint
        self.encryption_key = encryption_key
        self.resource_key: Optional[str] = None
        self.client_secret_store_id = client_secret_store_id
        self.client_secret_store_url = client_secret_store_url
        self.channel_integrity_key_name = channel_integrity_key_name
        self.channel_integrity_key_version = channel_integrity_key_version
        self.key_vault_sync_status = key_vault_sync_status
        self.device_secrets: Optional[Dict[str, "_models.Secret"]] = None


class DataBoxEdgeDeviceExtendedInfoPatch(_serialization.Model):
    """The Data Box Edge/Gateway device extended info patch.

    :ivar client_secret_store_id: The Key Vault ARM Id for client secrets.
    :vartype client_secret_store_id: str
    :ivar client_secret_store_url: The url to access the Client Key Vault.
    :vartype client_secret_store_url: str
    :ivar channel_integrity_key_name: The name for Channel Integrity Key stored in the Client Key
     Vault.
    :vartype channel_integrity_key_name: str
    :ivar channel_integrity_key_version: The version of Channel Integrity Key stored in the Client
     Key Vault.
    :vartype channel_integrity_key_version: str
    :ivar sync_status: For changing or to initiate the resync to key-vault set the status to
     KeyVaultSyncPending, rest of the status will not be applicable. Known values are:
     "KeyVaultSynced", "KeyVaultSyncFailed", "KeyVaultNotConfigured", "KeyVaultSyncPending",
     "KeyVaultSyncing", and "KeyVaultNotSynced".
    :vartype sync_status: str or ~azure.mgmt.databoxedge.models.KeyVaultSyncStatus
    """

    _attribute_map = {
        "client_secret_store_id": {"key": "clientSecretStoreId", "type": "str"},
        "client_secret_store_url": {"key": "clientSecretStoreUrl", "type": "str"},
        "channel_integrity_key_name": {"key": "channelIntegrityKeyName", "type": "str"},
        "channel_integrity_key_version": {"key": "channelIntegrityKeyVersion", "type": "str"},
        "sync_status": {"key": "syncStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        client_secret_store_id: Optional[str] = None,
        client_secret_store_url: Optional[str] = None,
        channel_integrity_key_name: Optional[str] = None,
        channel_integrity_key_version: Optional[str] = None,
        sync_status: Optional[Union[str, "_models.KeyVaultSyncStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword client_secret_store_id: The Key Vault ARM Id for client secrets.
        :paramtype client_secret_store_id: str
        :keyword client_secret_store_url: The url to access the Client Key Vault.
        :paramtype client_secret_store_url: str
        :keyword channel_integrity_key_name: The name for Channel Integrity Key stored in the Client
         Key Vault.
        :paramtype channel_integrity_key_name: str
        :keyword channel_integrity_key_version: The version of Channel Integrity Key stored in the
         Client Key Vault.
        :paramtype channel_integrity_key_version: str
        :keyword sync_status: For changing or to initiate the resync to key-vault set the status to
         KeyVaultSyncPending, rest of the status will not be applicable. Known values are:
         "KeyVaultSynced", "KeyVaultSyncFailed", "KeyVaultNotConfigured", "KeyVaultSyncPending",
         "KeyVaultSyncing", and "KeyVaultNotSynced".
        :paramtype sync_status: str or ~azure.mgmt.databoxedge.models.KeyVaultSyncStatus
        """
        super().__init__(**kwargs)
        self.client_secret_store_id = client_secret_store_id
        self.client_secret_store_url = client_secret_store_url
        self.channel_integrity_key_name = channel_integrity_key_name
        self.channel_integrity_key_version = channel_integrity_key_version
        self.sync_status = sync_status


class DataBoxEdgeDeviceList(_serialization.Model):
    """The collection of Data Box Edge/Gateway devices.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Data Box Edge/Gateway devices.
    :vartype value: list[~azure.mgmt.databoxedge.models.DataBoxEdgeDevice]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataBoxEdgeDevice]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DataBoxEdgeDevice"]] = None
        self.next_link: Optional[str] = None


class DataBoxEdgeDevicePatch(_serialization.Model):
    """The Data Box Edge/Gateway device patch.

    :ivar tags: The tags attached to the Data Box Edge/Gateway resource.
    :vartype tags: dict[str, str]
    :ivar identity: Msi identity of the resource.
    :vartype identity: ~azure.mgmt.databoxedge.models.ResourceIdentity
    :ivar edge_profile: Edge Profile property of the Data Box Edge/Gateway device.
    :vartype edge_profile: ~azure.mgmt.databoxedge.models.EdgeProfilePatch
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "edge_profile": {"key": "properties.edgeProfile", "type": "EdgeProfilePatch"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        edge_profile: Optional["_models.EdgeProfilePatch"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The tags attached to the Data Box Edge/Gateway resource.
        :paramtype tags: dict[str, str]
        :keyword identity: Msi identity of the resource.
        :paramtype identity: ~azure.mgmt.databoxedge.models.ResourceIdentity
        :keyword edge_profile: Edge Profile property of the Data Box Edge/Gateway device.
        :paramtype edge_profile: ~azure.mgmt.databoxedge.models.EdgeProfilePatch
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.edge_profile = edge_profile


class DataBoxEdgeMoveRequest(_serialization.Model):
    """Resource Move details.

    All required parameters must be populated in order to send to server.

    :ivar target_resource_group: Target resource group ARMId. Required.
    :vartype target_resource_group: str
    :ivar resources: List of resources to be moved. Required.
    :vartype resources: list[str]
    """

    _validation = {
        "target_resource_group": {"required": True},
        "resources": {"required": True},
    }

    _attribute_map = {
        "target_resource_group": {"key": "targetResourceGroup", "type": "str"},
        "resources": {"key": "resources", "type": "[str]"},
    }

    def __init__(self, *, target_resource_group: str, resources: List[str], **kwargs: Any) -> None:
        """
        :keyword target_resource_group: Target resource group ARMId. Required.
        :paramtype target_resource_group: str
        :keyword resources: List of resources to be moved. Required.
        :paramtype resources: list[str]
        """
        super().__init__(**kwargs)
        self.target_resource_group = target_resource_group
        self.resources = resources


class DataBoxEdgeSku(_serialization.Model):
    """The Sku information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :ivar name: The Sku name. Known values are: "Gateway", "Edge", "TEA_1Node", "TEA_1Node_UPS",
     "TEA_1Node_Heater", "TEA_1Node_UPS_Heater", "TEA_4Node_Heater", "TEA_4Node_UPS_Heater", "TMA",
     "TDC", "TCA_Small", "GPU", "TCA_Large", "EdgeP_Base", "EdgeP_High", "EdgePR_Base",
     "EdgePR_Base_UPS", "EP2_64_1VPU_W", "EP2_128_1T4_Mx1_W", "EP2_256_2T4_W", "EdgeMR_Mini",
     "RCA_Small", "RCA_Large", "RDC", and "Management".
    :vartype name: str or ~azure.mgmt.databoxedge.models.SkuName
    :ivar kind: The Sku kind.
    :vartype kind: str
    :ivar tier: The Sku tier. "Standard"
    :vartype tier: str or ~azure.mgmt.databoxedge.models.SkuTier
    :ivar size: The Sku kind.
    :vartype size: str
    :ivar family: The Sku family.
    :vartype family: str
    :ivar locations: Availability of the Sku for the region.
    :vartype locations: list[str]
    :ivar api_versions: The API versions in which Sku is available.
    :vartype api_versions: list[str]
    :ivar location_info: Availability of the Sku for the location/zone/site.
    :vartype location_info: list[~azure.mgmt.databoxedge.models.SkuLocationInfo]
    :ivar costs: The pricing info of the Sku.
    :vartype costs: list[~azure.mgmt.databoxedge.models.SkuCost]
    :ivar signup_option: Sku can be signed up by customer or not. Known values are: "None" and
     "Available".
    :vartype signup_option: str or ~azure.mgmt.databoxedge.models.SkuSignupOption
    :ivar version: Availability of the Sku as preview/stable. Known values are: "Stable" and
     "Preview".
    :vartype version: str or ~azure.mgmt.databoxedge.models.SkuVersion
    :ivar availability: Links to the next set of results. Known values are: "Available" and
     "Unavailable".
    :vartype availability: str or ~azure.mgmt.databoxedge.models.SkuAvailability
    :ivar shipment_types: List of Shipment Types supported by this SKU.
    :vartype shipment_types: list[str or ~azure.mgmt.databoxedge.models.ShipmentType]
    :ivar capabilities: The capability info of the SKU.
    :vartype capabilities: list[~azure.mgmt.databoxedge.models.SkuCapability]
    """

    _validation = {
        "resource_type": {"readonly": True},
        "name": {"readonly": True},
        "kind": {"readonly": True},
        "tier": {"readonly": True},
        "size": {"readonly": True},
        "family": {"readonly": True},
        "locations": {"readonly": True},
        "api_versions": {"readonly": True},
        "location_info": {"readonly": True},
        "costs": {"readonly": True},
        "signup_option": {"readonly": True},
        "version": {"readonly": True},
        "availability": {"readonly": True},
        "shipment_types": {"readonly": True},
        "capabilities": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "api_versions": {"key": "apiVersions", "type": "[str]"},
        "location_info": {"key": "locationInfo", "type": "[SkuLocationInfo]"},
        "costs": {"key": "costs", "type": "[SkuCost]"},
        "signup_option": {"key": "signupOption", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "availability": {"key": "availability", "type": "str"},
        "shipment_types": {"key": "shipmentTypes", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[SkuCapability]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_type: Optional[str] = None
        self.name: Optional[Union[str, "_models.SkuName"]] = None
        self.kind: Optional[str] = None
        self.tier: Optional[Union[str, "_models.SkuTier"]] = None
        self.size: Optional[str] = None
        self.family: Optional[str] = None
        self.locations: Optional[List[str]] = None
        self.api_versions: Optional[List[str]] = None
        self.location_info: Optional[List["_models.SkuLocationInfo"]] = None
        self.costs: Optional[List["_models.SkuCost"]] = None
        self.signup_option: Optional[Union[str, "_models.SkuSignupOption"]] = None
        self.version: Optional[Union[str, "_models.SkuVersion"]] = None
        self.availability: Optional[Union[str, "_models.SkuAvailability"]] = None
        self.shipment_types: Optional[List[Union[str, "_models.ShipmentType"]]] = None
        self.capabilities: Optional[List["_models.SkuCapability"]] = None


class DataBoxEdgeSkuList(_serialization.Model):
    """List of SKU Information objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of ResourceType Sku.
    :vartype value: list[~azure.mgmt.databoxedge.models.DataBoxEdgeSku]
    :ivar next_link: Links to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataBoxEdgeSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.DataBoxEdgeSku"]] = None
        self.next_link: Optional[str] = None


class DCAccessCode(_serialization.Model):
    """DC Access code in the case of Self Managed Shipping.

    :ivar auth_code: DCAccess Code for the Self Managed shipment.
    :vartype auth_code: str
    """

    _attribute_map = {
        "auth_code": {"key": "properties.authCode", "type": "str"},
    }

    def __init__(self, *, auth_code: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword auth_code: DCAccess Code for the Self Managed shipment.
        :paramtype auth_code: str
        """
        super().__init__(**kwargs)
        self.auth_code = auth_code


class EdgeProfile(_serialization.Model):
    """Details about Edge Profile for the resource.

    :ivar subscription: Edge Profile Subscription.
    :vartype subscription: ~azure.mgmt.databoxedge.models.EdgeProfileSubscription
    """

    _attribute_map = {
        "subscription": {"key": "subscription", "type": "EdgeProfileSubscription"},
    }

    def __init__(self, *, subscription: Optional["_models.EdgeProfileSubscription"] = None, **kwargs: Any) -> None:
        """
        :keyword subscription: Edge Profile Subscription.
        :paramtype subscription: ~azure.mgmt.databoxedge.models.EdgeProfileSubscription
        """
        super().__init__(**kwargs)
        self.subscription = subscription


class EdgeProfilePatch(_serialization.Model):
    """The Data Box Edge/Gateway Edge Profile patch.

    :ivar subscription: The Data Box Edge/Gateway Edge Profile Subscription patch.
    :vartype subscription: ~azure.mgmt.databoxedge.models.EdgeProfileSubscriptionPatch
    """

    _attribute_map = {
        "subscription": {"key": "subscription", "type": "EdgeProfileSubscriptionPatch"},
    }

    def __init__(self, *, subscription: Optional["_models.EdgeProfileSubscriptionPatch"] = None, **kwargs: Any) -> None:
        """
        :keyword subscription: The Data Box Edge/Gateway Edge Profile Subscription patch.
        :paramtype subscription: ~azure.mgmt.databoxedge.models.EdgeProfileSubscriptionPatch
        """
        super().__init__(**kwargs)
        self.subscription = subscription


class EdgeProfileSubscription(_serialization.Model):
    """Subscription details for the Edge Profile.

    :ivar registration_id: Edge Subscription Registration ID.
    :vartype registration_id: str
    :ivar id: ARM ID of the subscription.
    :vartype id: str
    :ivar state: Known values are: "Registered", "Warned", "Suspended", "Deleted", and
     "Unregistered".
    :vartype state: str or ~azure.mgmt.databoxedge.models.SubscriptionState
    :ivar registration_date:
    :vartype registration_date: str
    :ivar subscription_id:
    :vartype subscription_id: str
    :ivar tenant_id:
    :vartype tenant_id: str
    :ivar location_placement_id:
    :vartype location_placement_id: str
    :ivar quota_id:
    :vartype quota_id: str
    :ivar serialized_details:
    :vartype serialized_details: str
    :ivar registered_features:
    :vartype registered_features:
     list[~azure.mgmt.databoxedge.models.SubscriptionRegisteredFeatures]
    """

    _attribute_map = {
        "registration_id": {"key": "registrationId", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "registration_date": {"key": "registrationDate", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "tenant_id": {"key": "properties.tenantId", "type": "str"},
        "location_placement_id": {"key": "properties.locationPlacementId", "type": "str"},
        "quota_id": {"key": "properties.quotaId", "type": "str"},
        "serialized_details": {"key": "properties.serializedDetails", "type": "str"},
        "registered_features": {"key": "properties.registeredFeatures", "type": "[SubscriptionRegisteredFeatures]"},
    }

    def __init__(
        self,
        *,
        registration_id: Optional[str] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        state: Optional[Union[str, "_models.SubscriptionState"]] = None,
        registration_date: Optional[str] = None,
        subscription_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        location_placement_id: Optional[str] = None,
        quota_id: Optional[str] = None,
        serialized_details: Optional[str] = None,
        registered_features: Optional[List["_models.SubscriptionRegisteredFeatures"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword registration_id: Edge Subscription Registration ID.
        :paramtype registration_id: str
        :keyword id: ARM ID of the subscription.
        :paramtype id: str
        :keyword state: Known values are: "Registered", "Warned", "Suspended", "Deleted", and
         "Unregistered".
        :paramtype state: str or ~azure.mgmt.databoxedge.models.SubscriptionState
        :keyword registration_date:
        :paramtype registration_date: str
        :keyword subscription_id:
        :paramtype subscription_id: str
        :keyword tenant_id:
        :paramtype tenant_id: str
        :keyword location_placement_id:
        :paramtype location_placement_id: str
        :keyword quota_id:
        :paramtype quota_id: str
        :keyword serialized_details:
        :paramtype serialized_details: str
        :keyword registered_features:
        :paramtype registered_features:
         list[~azure.mgmt.databoxedge.models.SubscriptionRegisteredFeatures]
        """
        super().__init__(**kwargs)
        self.registration_id = registration_id
        self.id = id
        self.state = state
        self.registration_date = registration_date
        self.subscription_id = subscription_id
        self.tenant_id = tenant_id
        self.location_placement_id = location_placement_id
        self.quota_id = quota_id
        self.serialized_details = serialized_details
        self.registered_features = registered_features


class EdgeProfileSubscriptionPatch(_serialization.Model):
    """The Data Box Edge/Gateway Edge Profile Subscription patch.

    :ivar id: The path ID that uniquely identifies the subscription of the edge profile.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The path ID that uniquely identifies the subscription of the edge profile.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class EtcdInfo(_serialization.Model):
    """Etcd configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Etcd type.
    :vartype type: str
    :ivar version: Etcd version.
    :vartype version: str
    """

    _validation = {
        "type": {"readonly": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.version: Optional[str] = None


class Trigger(ARMBaseModel):
    """Trigger details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FileEventTrigger, PeriodicTimerEventTrigger

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Trigger in DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar kind: Trigger Kind. Required. Known values are: "FileEvent" and "PeriodicTimerEvent".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.TriggerEventType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"FileEvent": "FileEventTrigger", "PeriodicTimerEvent": "PeriodicTimerEventTrigger"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.kind: Optional[str] = None


class FileEventTrigger(Trigger):
    """Trigger details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Trigger in DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar kind: Trigger Kind. Required. Known values are: "FileEvent" and "PeriodicTimerEvent".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.TriggerEventType
    :ivar source_info: File event source details. Required.
    :vartype source_info: ~azure.mgmt.databoxedge.models.FileSourceInfo
    :ivar sink_info: Role sink info. Required.
    :vartype sink_info: ~azure.mgmt.databoxedge.models.RoleSinkInfo
    :ivar custom_context_tag: A custom context tag typically used to correlate the trigger against
     its usage. For example, if a periodic timer trigger is intended for certain specific IoT
     modules in the device, the tag can be the name or the image URL of the module.
    :vartype custom_context_tag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "source_info": {"required": True},
        "sink_info": {"required": True},
        "custom_context_tag": {"max_length": 192},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "source_info": {"key": "properties.sourceInfo", "type": "FileSourceInfo"},
        "sink_info": {"key": "properties.sinkInfo", "type": "RoleSinkInfo"},
        "custom_context_tag": {"key": "properties.customContextTag", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_info: "_models.FileSourceInfo",
        sink_info: "_models.RoleSinkInfo",
        custom_context_tag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_info: File event source details. Required.
        :paramtype source_info: ~azure.mgmt.databoxedge.models.FileSourceInfo
        :keyword sink_info: Role sink info. Required.
        :paramtype sink_info: ~azure.mgmt.databoxedge.models.RoleSinkInfo
        :keyword custom_context_tag: A custom context tag typically used to correlate the trigger
         against its usage. For example, if a periodic timer trigger is intended for certain specific
         IoT modules in the device, the tag can be the name or the image URL of the module.
        :paramtype custom_context_tag: str
        """
        super().__init__(**kwargs)
        self.kind: str = "FileEvent"
        self.source_info = source_info
        self.sink_info = sink_info
        self.custom_context_tag = custom_context_tag


class FileSourceInfo(_serialization.Model):
    """File source details.

    All required parameters must be populated in order to send to server.

    :ivar share_id: File share ID. Required.
    :vartype share_id: str
    """

    _validation = {
        "share_id": {"required": True},
    }

    _attribute_map = {
        "share_id": {"key": "shareId", "type": "str"},
    }

    def __init__(self, *, share_id: str, **kwargs: Any) -> None:
        """
        :keyword share_id: File share ID. Required.
        :paramtype share_id: str
        """
        super().__init__(**kwargs)
        self.share_id = share_id


class GenerateCertResponse(_serialization.Model):
    """Used in activation key generation flow.

    :ivar public_key: Gets or sets base64 encoded certificate raw data,
     this is the public part needed to be uploaded to cert vault.
    :vartype public_key: str
    :ivar private_key: Gets or sets base64 encoded private part of the certificate,
     needed to form the activation key.
    :vartype private_key: str
    :ivar expiry_time_in_utc: Gets or sets expiry time in UTC.
    :vartype expiry_time_in_utc: str
    """

    _attribute_map = {
        "public_key": {"key": "publicKey", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
        "expiry_time_in_utc": {"key": "expiryTimeInUTC", "type": "str"},
    }

    def __init__(
        self,
        *,
        public_key: Optional[str] = None,
        private_key: Optional[str] = None,
        expiry_time_in_utc: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword public_key: Gets or sets base64 encoded certificate raw data,
         this is the public part needed to be uploaded to cert vault.
        :paramtype public_key: str
        :keyword private_key: Gets or sets base64 encoded private part of the certificate,
         needed to form the activation key.
        :paramtype private_key: str
        :keyword expiry_time_in_utc: Gets or sets expiry time in UTC.
        :paramtype expiry_time_in_utc: str
        """
        super().__init__(**kwargs)
        self.public_key = public_key
        self.private_key = private_key
        self.expiry_time_in_utc = expiry_time_in_utc


class ImageRepositoryCredential(_serialization.Model):
    """Image repository credential.

    All required parameters must be populated in order to send to server.

    :ivar image_repository_url: Image repository url (e.g.: mcr.microsoft.com). Required.
    :vartype image_repository_url: str
    :ivar user_name: Repository user name. Required.
    :vartype user_name: str
    :ivar password: Repository user password.
    :vartype password: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
    """

    _validation = {
        "image_repository_url": {"required": True},
        "user_name": {"required": True},
    }

    _attribute_map = {
        "image_repository_url": {"key": "imageRepositoryUrl", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "AsymmetricEncryptedSecret"},
    }

    def __init__(
        self,
        *,
        image_repository_url: str,
        user_name: str,
        password: Optional["_models.AsymmetricEncryptedSecret"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_repository_url: Image repository url (e.g.: mcr.microsoft.com). Required.
        :paramtype image_repository_url: str
        :keyword user_name: Repository user name. Required.
        :paramtype user_name: str
        :keyword password: Repository user password.
        :paramtype password: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
        """
        super().__init__(**kwargs)
        self.image_repository_url = image_repository_url
        self.user_name = user_name
        self.password = password


class IoTAddon(Addon):
    """IoT Addon.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Addon type. Required. Known values are: "IotEdge" and "ArcForKubernetes".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.AddonType
    :ivar system_data: Addon type.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar io_t_device_details: IoT device metadata to which appliance needs to be connected.
     Required.
    :vartype io_t_device_details: ~azure.mgmt.databoxedge.models.IoTDeviceInfo
    :ivar io_t_edge_device_details: IoT edge device to which the IoT Addon needs to be configured.
     Required.
    :vartype io_t_edge_device_details: ~azure.mgmt.databoxedge.models.IoTDeviceInfo
    :ivar version: Version of IoT running on the appliance.
    :vartype version: str
    :ivar host_platform: Host OS supported by the IoT addon. Known values are: "Windows" and
     "Linux".
    :vartype host_platform: str or ~azure.mgmt.databoxedge.models.PlatformType
    :ivar host_platform_type: Platform where the runtime is hosted. Known values are:
     "KubernetesCluster" and "LinuxVM".
    :vartype host_platform_type: str or ~azure.mgmt.databoxedge.models.HostPlatformType
    :ivar provisioning_state: Addon Provisioning State. Known values are: "Invalid", "Creating",
     "Created", "Updating", "Reconfiguring", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.databoxedge.models.AddonState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
        "io_t_device_details": {"required": True},
        "io_t_edge_device_details": {"required": True},
        "version": {"readonly": True},
        "host_platform": {"readonly": True},
        "host_platform_type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "io_t_device_details": {"key": "properties.ioTDeviceDetails", "type": "IoTDeviceInfo"},
        "io_t_edge_device_details": {"key": "properties.ioTEdgeDeviceDetails", "type": "IoTDeviceInfo"},
        "version": {"key": "properties.version", "type": "str"},
        "host_platform": {"key": "properties.hostPlatform", "type": "str"},
        "host_platform_type": {"key": "properties.hostPlatformType", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        io_t_device_details: "_models.IoTDeviceInfo",
        io_t_edge_device_details: "_models.IoTDeviceInfo",
        **kwargs: Any
    ) -> None:
        """
        :keyword io_t_device_details: IoT device metadata to which appliance needs to be connected.
         Required.
        :paramtype io_t_device_details: ~azure.mgmt.databoxedge.models.IoTDeviceInfo
        :keyword io_t_edge_device_details: IoT edge device to which the IoT Addon needs to be
         configured. Required.
        :paramtype io_t_edge_device_details: ~azure.mgmt.databoxedge.models.IoTDeviceInfo
        """
        super().__init__(**kwargs)
        self.kind: str = "IotEdge"
        self.io_t_device_details = io_t_device_details
        self.io_t_edge_device_details = io_t_edge_device_details
        self.version: Optional[str] = None
        self.host_platform: Optional[Union[str, "_models.PlatformType"]] = None
        self.host_platform_type: Optional[Union[str, "_models.HostPlatformType"]] = None
        self.provisioning_state: Optional[Union[str, "_models.AddonState"]] = None


class IoTDeviceInfo(_serialization.Model):
    """Metadata of IoT device/IoT Edge device to be configured.

    All required parameters must be populated in order to send to server.

    :ivar device_id: ID of the IoT device/edge device. Required.
    :vartype device_id: str
    :ivar io_t_host_hub: Host name for the IoT hub associated to the device. Required.
    :vartype io_t_host_hub: str
    :ivar io_t_host_hub_id: Id for the IoT hub associated to the device.
    :vartype io_t_host_hub_id: str
    :ivar authentication: Encrypted IoT device/IoT edge device connection string.
    :vartype authentication: ~azure.mgmt.databoxedge.models.Authentication
    """

    _validation = {
        "device_id": {"required": True},
        "io_t_host_hub": {"required": True},
    }

    _attribute_map = {
        "device_id": {"key": "deviceId", "type": "str"},
        "io_t_host_hub": {"key": "ioTHostHub", "type": "str"},
        "io_t_host_hub_id": {"key": "ioTHostHubId", "type": "str"},
        "authentication": {"key": "authentication", "type": "Authentication"},
    }

    def __init__(
        self,
        *,
        device_id: str,
        io_t_host_hub: str,
        io_t_host_hub_id: Optional[str] = None,
        authentication: Optional["_models.Authentication"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword device_id: ID of the IoT device/edge device. Required.
        :paramtype device_id: str
        :keyword io_t_host_hub: Host name for the IoT hub associated to the device. Required.
        :paramtype io_t_host_hub: str
        :keyword io_t_host_hub_id: Id for the IoT hub associated to the device.
        :paramtype io_t_host_hub_id: str
        :keyword authentication: Encrypted IoT device/IoT edge device connection string.
        :paramtype authentication: ~azure.mgmt.databoxedge.models.Authentication
        """
        super().__init__(**kwargs)
        self.device_id = device_id
        self.io_t_host_hub = io_t_host_hub
        self.io_t_host_hub_id = io_t_host_hub_id
        self.authentication = authentication


class IoTEdgeAgentInfo(_serialization.Model):
    """IoT edge agent details is optional, this will be used for download system Agent module while
    bootstrapping IoT Role if specified.

    All required parameters must be populated in order to send to server.

    :ivar image_name: Name of the IoT edge agent image. Required.
    :vartype image_name: str
    :ivar tag: Image Tag. Required.
    :vartype tag: str
    :ivar image_repository: Image repository details.
    :vartype image_repository: ~azure.mgmt.databoxedge.models.ImageRepositoryCredential
    """

    _validation = {
        "image_name": {"required": True},
        "tag": {"required": True},
    }

    _attribute_map = {
        "image_name": {"key": "imageName", "type": "str"},
        "tag": {"key": "tag", "type": "str"},
        "image_repository": {"key": "imageRepository", "type": "ImageRepositoryCredential"},
    }

    def __init__(
        self,
        *,
        image_name: str,
        tag: str,
        image_repository: Optional["_models.ImageRepositoryCredential"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword image_name: Name of the IoT edge agent image. Required.
        :paramtype image_name: str
        :keyword tag: Image Tag. Required.
        :paramtype tag: str
        :keyword image_repository: Image repository details.
        :paramtype image_repository: ~azure.mgmt.databoxedge.models.ImageRepositoryCredential
        """
        super().__init__(**kwargs)
        self.image_name = image_name
        self.tag = tag
        self.image_repository = image_repository


class IoTRole(Role):
    """Compute role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Role type. Required. Known values are: "IOT", "ASA", "Functions", "Cognitive",
     "MEC", "CloudEdgeManagement", and "Kubernetes".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.RoleTypes
    :ivar system_data: Role configured on ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar host_platform: Host OS supported by the IoT role. Known values are: "Windows" and
     "Linux".
    :vartype host_platform: str or ~azure.mgmt.databoxedge.models.PlatformType
    :ivar io_t_device_details: IoT device metadata to which data box edge device needs to be
     connected.
    :vartype io_t_device_details: ~azure.mgmt.databoxedge.models.IoTDeviceInfo
    :ivar io_t_edge_device_details: IoT edge device to which the IoT role needs to be configured.
    :vartype io_t_edge_device_details: ~azure.mgmt.databoxedge.models.IoTDeviceInfo
    :ivar share_mappings: Mount points of shares in role(s).
    :vartype share_mappings: list[~azure.mgmt.databoxedge.models.MountPointMap]
    :ivar io_t_edge_agent_info: Iot edge agent details to download the agent and bootstrap iot
     runtime.
    :vartype io_t_edge_agent_info: ~azure.mgmt.databoxedge.models.IoTEdgeAgentInfo
    :ivar host_platform_type: Platform where the Iot runtime is hosted. Known values are:
     "KubernetesCluster" and "LinuxVM".
    :vartype host_platform_type: str or ~azure.mgmt.databoxedge.models.HostPlatformType
    :ivar compute_resource: Resource allocation.
    :vartype compute_resource: ~azure.mgmt.databoxedge.models.ComputeResource
    :ivar role_status: Role status. Known values are: "Enabled" and "Disabled".
    :vartype role_status: str or ~azure.mgmt.databoxedge.models.RoleStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
        "host_platform_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "host_platform": {"key": "properties.hostPlatform", "type": "str"},
        "io_t_device_details": {"key": "properties.ioTDeviceDetails", "type": "IoTDeviceInfo"},
        "io_t_edge_device_details": {"key": "properties.ioTEdgeDeviceDetails", "type": "IoTDeviceInfo"},
        "share_mappings": {"key": "properties.shareMappings", "type": "[MountPointMap]"},
        "io_t_edge_agent_info": {"key": "properties.ioTEdgeAgentInfo", "type": "IoTEdgeAgentInfo"},
        "host_platform_type": {"key": "properties.hostPlatformType", "type": "str"},
        "compute_resource": {"key": "properties.computeResource", "type": "ComputeResource"},
        "role_status": {"key": "properties.roleStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_platform: Optional[Union[str, "_models.PlatformType"]] = None,
        io_t_device_details: Optional["_models.IoTDeviceInfo"] = None,
        io_t_edge_device_details: Optional["_models.IoTDeviceInfo"] = None,
        share_mappings: Optional[List["_models.MountPointMap"]] = None,
        io_t_edge_agent_info: Optional["_models.IoTEdgeAgentInfo"] = None,
        compute_resource: Optional["_models.ComputeResource"] = None,
        role_status: Optional[Union[str, "_models.RoleStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_platform: Host OS supported by the IoT role. Known values are: "Windows" and
         "Linux".
        :paramtype host_platform: str or ~azure.mgmt.databoxedge.models.PlatformType
        :keyword io_t_device_details: IoT device metadata to which data box edge device needs to be
         connected.
        :paramtype io_t_device_details: ~azure.mgmt.databoxedge.models.IoTDeviceInfo
        :keyword io_t_edge_device_details: IoT edge device to which the IoT role needs to be
         configured.
        :paramtype io_t_edge_device_details: ~azure.mgmt.databoxedge.models.IoTDeviceInfo
        :keyword share_mappings: Mount points of shares in role(s).
        :paramtype share_mappings: list[~azure.mgmt.databoxedge.models.MountPointMap]
        :keyword io_t_edge_agent_info: Iot edge agent details to download the agent and bootstrap iot
         runtime.
        :paramtype io_t_edge_agent_info: ~azure.mgmt.databoxedge.models.IoTEdgeAgentInfo
        :keyword compute_resource: Resource allocation.
        :paramtype compute_resource: ~azure.mgmt.databoxedge.models.ComputeResource
        :keyword role_status: Role status. Known values are: "Enabled" and "Disabled".
        :paramtype role_status: str or ~azure.mgmt.databoxedge.models.RoleStatus
        """
        super().__init__(**kwargs)
        self.kind: str = "IOT"
        self.host_platform = host_platform
        self.io_t_device_details = io_t_device_details
        self.io_t_edge_device_details = io_t_edge_device_details
        self.share_mappings = share_mappings
        self.io_t_edge_agent_info = io_t_edge_agent_info
        self.host_platform_type: Optional[Union[str, "_models.HostPlatformType"]] = None
        self.compute_resource = compute_resource
        self.role_status = role_status


class Ipv4Config(_serialization.Model):
    """Details related to the IPv4 address configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ip_address: The IPv4 address of the network adapter.
    :vartype ip_address: str
    :ivar subnet: The IPv4 subnet of the network adapter.
    :vartype subnet: str
    :ivar gateway: The IPv4 gateway of the network adapter.
    :vartype gateway: str
    """

    _validation = {
        "ip_address": {"readonly": True},
        "subnet": {"readonly": True},
        "gateway": {"readonly": True},
    }

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "subnet": {"key": "subnet", "type": "str"},
        "gateway": {"key": "gateway", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.ip_address: Optional[str] = None
        self.subnet: Optional[str] = None
        self.gateway: Optional[str] = None


class Ipv6Config(_serialization.Model):
    """Details related to the IPv6 address configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar ip_address: The IPv6 address of the network adapter.
    :vartype ip_address: str
    :ivar prefix_length: The IPv6 prefix of the network adapter.
    :vartype prefix_length: int
    :ivar gateway: The IPv6 gateway of the network adapter.
    :vartype gateway: str
    """

    _validation = {
        "ip_address": {"readonly": True},
        "prefix_length": {"readonly": True},
        "gateway": {"readonly": True},
    }

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "prefix_length": {"key": "prefixLength", "type": "int"},
        "gateway": {"key": "gateway", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.ip_address: Optional[str] = None
        self.prefix_length: Optional[int] = None
        self.gateway: Optional[str] = None


class Job(_serialization.Model):
    """A device job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The name of the object.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar status: The current status of the job. Known values are: "Invalid", "Running",
     "Succeeded", "Failed", "Canceled", "Paused", and "Scheduled".
    :vartype status: str or ~azure.mgmt.databoxedge.models.JobStatus
    :ivar start_time: The UTC date and time at which the job started.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The UTC date and time at which the job completed.
    :vartype end_time: ~datetime.datetime
    :ivar percent_complete: The percentage of the job that is complete.
    :vartype percent_complete: int
    :ivar error: The error details.
    :vartype error: ~azure.mgmt.databoxedge.models.JobErrorDetails
    :ivar job_type: The type of the job. Known values are: "Invalid", "ScanForUpdates",
     "DownloadUpdates", "InstallUpdates", "RefreshShare", "RefreshContainer", "Backup", "Restore",
     and "TriggerSupportPackage".
    :vartype job_type: str or ~azure.mgmt.databoxedge.models.JobType
    :ivar current_stage: Current stage of the update operation. Known values are: "Unknown",
     "Initial", "ScanStarted", "ScanComplete", "ScanFailed", "DownloadStarted", "DownloadComplete",
     "DownloadFailed", "InstallStarted", "InstallComplete", "InstallFailed", "RebootInitiated",
     "Success", "Failure", "RescanStarted", "RescanComplete", and "RescanFailed".
    :vartype current_stage: str or ~azure.mgmt.databoxedge.models.UpdateOperationStage
    :ivar download_progress: The download progress.
    :vartype download_progress: ~azure.mgmt.databoxedge.models.UpdateDownloadProgress
    :ivar install_progress: The install progress.
    :vartype install_progress: ~azure.mgmt.databoxedge.models.UpdateInstallProgress
    :ivar total_refresh_errors: Total number of errors encountered during the refresh process.
    :vartype total_refresh_errors: int
    :ivar error_manifest_file: Local share/remote container relative path to the error manifest
     file of the refresh.
    :vartype error_manifest_file: str
    :ivar refreshed_entity_id: ARM ID of the entity that was refreshed.
    :vartype refreshed_entity_id: str
    :ivar folder: If only subfolders need to be refreshed, then the subfolder path inside the share
     or container. (The path is empty if there are no subfolders.).
    :vartype folder: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "status": {"readonly": True},
        "start_time": {"readonly": True},
        "end_time": {"readonly": True},
        "percent_complete": {"readonly": True},
        "error": {"readonly": True},
        "job_type": {"readonly": True},
        "current_stage": {"readonly": True},
        "download_progress": {"readonly": True},
        "install_progress": {"readonly": True},
        "total_refresh_errors": {"readonly": True},
        "error_manifest_file": {"readonly": True},
        "refreshed_entity_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "percent_complete": {"key": "percentComplete", "type": "int"},
        "error": {"key": "error", "type": "JobErrorDetails"},
        "job_type": {"key": "properties.jobType", "type": "str"},
        "current_stage": {"key": "properties.currentStage", "type": "str"},
        "download_progress": {"key": "properties.downloadProgress", "type": "UpdateDownloadProgress"},
        "install_progress": {"key": "properties.installProgress", "type": "UpdateInstallProgress"},
        "total_refresh_errors": {"key": "properties.totalRefreshErrors", "type": "int"},
        "error_manifest_file": {"key": "properties.errorManifestFile", "type": "str"},
        "refreshed_entity_id": {"key": "properties.refreshedEntityId", "type": "str"},
        "folder": {"key": "properties.folder", "type": "str"},
    }

    def __init__(self, *, folder: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword folder: If only subfolders need to be refreshed, then the subfolder path inside the
         share or container. (The path is empty if there are no subfolders.).
        :paramtype folder: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.status: Optional[Union[str, "_models.JobStatus"]] = None
        self.start_time: Optional[datetime.datetime] = None
        self.end_time: Optional[datetime.datetime] = None
        self.percent_complete: Optional[int] = None
        self.error: Optional["_models.JobErrorDetails"] = None
        self.job_type: Optional[Union[str, "_models.JobType"]] = None
        self.current_stage: Optional[Union[str, "_models.UpdateOperationStage"]] = None
        self.download_progress: Optional["_models.UpdateDownloadProgress"] = None
        self.install_progress: Optional["_models.UpdateInstallProgress"] = None
        self.total_refresh_errors: Optional[int] = None
        self.error_manifest_file: Optional[str] = None
        self.refreshed_entity_id: Optional[str] = None
        self.folder = folder


class JobErrorDetails(_serialization.Model):
    """The job error information containing the list of job errors.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_details: The error details.
    :vartype error_details: list[~azure.mgmt.databoxedge.models.JobErrorItem]
    :ivar code: The code intended for programmatic access.
    :vartype code: str
    :ivar message: The message that describes the error in detail.
    :vartype message: str
    """

    _validation = {
        "error_details": {"readonly": True},
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "error_details": {"key": "errorDetails", "type": "[JobErrorItem]"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error_details: Optional[List["_models.JobErrorItem"]] = None
        self.code: Optional[str] = None
        self.message: Optional[str] = None


class JobErrorItem(_serialization.Model):
    """The job error items.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar recommendations: The recommended actions.
    :vartype recommendations: list[str]
    :ivar code: The code intended for programmatic access.
    :vartype code: str
    :ivar message: The message that describes the error in detail.
    :vartype message: str
    """

    _validation = {
        "recommendations": {"readonly": True},
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "recommendations": {"key": "recommendations", "type": "[str]"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.recommendations: Optional[List[str]] = None
        self.code: Optional[str] = None
        self.message: Optional[str] = None


class KubernetesClusterInfo(_serialization.Model):
    """Kubernetes cluster configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar etcd_info: Etcd configuration.
    :vartype etcd_info: ~azure.mgmt.databoxedge.models.EtcdInfo
    :ivar nodes: Kubernetes cluster nodes.
    :vartype nodes: list[~azure.mgmt.databoxedge.models.NodeInfo]
    :ivar version: Kubernetes cluster version. Required.
    :vartype version: str
    """

    _validation = {
        "etcd_info": {"readonly": True},
        "nodes": {"readonly": True},
        "version": {"required": True},
    }

    _attribute_map = {
        "etcd_info": {"key": "etcdInfo", "type": "EtcdInfo"},
        "nodes": {"key": "nodes", "type": "[NodeInfo]"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, *, version: str, **kwargs: Any) -> None:
        """
        :keyword version: Kubernetes cluster version. Required.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.etcd_info: Optional["_models.EtcdInfo"] = None
        self.nodes: Optional[List["_models.NodeInfo"]] = None
        self.version = version


class KubernetesIPConfiguration(_serialization.Model):
    """Kubernetes node IP configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar port: Port of the Kubernetes node.
    :vartype port: str
    :ivar ip_address: IP address of the Kubernetes node.
    :vartype ip_address: str
    """

    _validation = {
        "port": {"readonly": True},
    }

    _attribute_map = {
        "port": {"key": "port", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
    }

    def __init__(self, *, ip_address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_address: IP address of the Kubernetes node.
        :paramtype ip_address: str
        """
        super().__init__(**kwargs)
        self.port: Optional[str] = None
        self.ip_address = ip_address


class KubernetesRole(Role):
    """Kubernetes role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Role type. Required. Known values are: "IOT", "ASA", "Functions", "Cognitive",
     "MEC", "CloudEdgeManagement", and "Kubernetes".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.RoleTypes
    :ivar system_data: Role configured on ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar host_platform: Host OS supported by the Kubernetes role. Known values are: "Windows" and
     "Linux".
    :vartype host_platform: str or ~azure.mgmt.databoxedge.models.PlatformType
    :ivar provisioning_state: State of Kubernetes deployment. Known values are: "Invalid",
     "Creating", "Created", "Updating", "Reconfiguring", "Failed", and "Deleting".
    :vartype provisioning_state: str or ~azure.mgmt.databoxedge.models.KubernetesState
    :ivar host_platform_type: Platform where the runtime is hosted. Known values are:
     "KubernetesCluster" and "LinuxVM".
    :vartype host_platform_type: str or ~azure.mgmt.databoxedge.models.HostPlatformType
    :ivar kubernetes_cluster_info: Kubernetes cluster configuration.
    :vartype kubernetes_cluster_info: ~azure.mgmt.databoxedge.models.KubernetesClusterInfo
    :ivar kubernetes_role_resources: Kubernetes role resources.
    :vartype kubernetes_role_resources: ~azure.mgmt.databoxedge.models.KubernetesRoleResources
    :ivar role_status: Role status. Known values are: "Enabled" and "Disabled".
    :vartype role_status: str or ~azure.mgmt.databoxedge.models.RoleStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "host_platform_type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "host_platform": {"key": "properties.hostPlatform", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "host_platform_type": {"key": "properties.hostPlatformType", "type": "str"},
        "kubernetes_cluster_info": {"key": "properties.kubernetesClusterInfo", "type": "KubernetesClusterInfo"},
        "kubernetes_role_resources": {"key": "properties.kubernetesRoleResources", "type": "KubernetesRoleResources"},
        "role_status": {"key": "properties.roleStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        host_platform: Optional[Union[str, "_models.PlatformType"]] = None,
        kubernetes_cluster_info: Optional["_models.KubernetesClusterInfo"] = None,
        kubernetes_role_resources: Optional["_models.KubernetesRoleResources"] = None,
        role_status: Optional[Union[str, "_models.RoleStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_platform: Host OS supported by the Kubernetes role. Known values are: "Windows"
         and "Linux".
        :paramtype host_platform: str or ~azure.mgmt.databoxedge.models.PlatformType
        :keyword kubernetes_cluster_info: Kubernetes cluster configuration.
        :paramtype kubernetes_cluster_info: ~azure.mgmt.databoxedge.models.KubernetesClusterInfo
        :keyword kubernetes_role_resources: Kubernetes role resources.
        :paramtype kubernetes_role_resources: ~azure.mgmt.databoxedge.models.KubernetesRoleResources
        :keyword role_status: Role status. Known values are: "Enabled" and "Disabled".
        :paramtype role_status: str or ~azure.mgmt.databoxedge.models.RoleStatus
        """
        super().__init__(**kwargs)
        self.kind: str = "Kubernetes"
        self.host_platform = host_platform
        self.provisioning_state: Optional[Union[str, "_models.KubernetesState"]] = None
        self.host_platform_type: Optional[Union[str, "_models.HostPlatformType"]] = None
        self.kubernetes_cluster_info = kubernetes_cluster_info
        self.kubernetes_role_resources = kubernetes_role_resources
        self.role_status = role_status


class KubernetesRoleCompute(_serialization.Model):
    """Kubernetes role compute resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar vm_profile: VM profile. Required.
    :vartype vm_profile: str
    :ivar memory_in_bytes: Memory in bytes.
    :vartype memory_in_bytes: int
    :ivar processor_count: Processor count.
    :vartype processor_count: int
    """

    _validation = {
        "vm_profile": {"required": True},
        "memory_in_bytes": {"readonly": True},
        "processor_count": {"readonly": True},
    }

    _attribute_map = {
        "vm_profile": {"key": "vmProfile", "type": "str"},
        "memory_in_bytes": {"key": "memoryInBytes", "type": "int"},
        "processor_count": {"key": "processorCount", "type": "int"},
    }

    def __init__(self, *, vm_profile: str, **kwargs: Any) -> None:
        """
        :keyword vm_profile: VM profile. Required.
        :paramtype vm_profile: str
        """
        super().__init__(**kwargs)
        self.vm_profile = vm_profile
        self.memory_in_bytes: Optional[int] = None
        self.processor_count: Optional[int] = None


class KubernetesRoleNetwork(_serialization.Model):
    """Kubernetes role network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar cni_config: Cni configuration.
    :vartype cni_config: ~azure.mgmt.databoxedge.models.CniConfig
    :ivar load_balancer_config: Load balancer configuration.
    :vartype load_balancer_config: ~azure.mgmt.databoxedge.models.LoadBalancerConfig
    """

    _validation = {
        "cni_config": {"readonly": True},
        "load_balancer_config": {"readonly": True},
    }

    _attribute_map = {
        "cni_config": {"key": "cniConfig", "type": "CniConfig"},
        "load_balancer_config": {"key": "loadBalancerConfig", "type": "LoadBalancerConfig"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.cni_config: Optional["_models.CniConfig"] = None
        self.load_balancer_config: Optional["_models.LoadBalancerConfig"] = None


class KubernetesRoleResources(_serialization.Model):
    """Kubernetes role resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar storage: Kubernetes role storage resource.
    :vartype storage: ~azure.mgmt.databoxedge.models.KubernetesRoleStorage
    :ivar compute: Kubernetes role compute resource. Required.
    :vartype compute: ~azure.mgmt.databoxedge.models.KubernetesRoleCompute
    :ivar network: Kubernetes role network resource.
    :vartype network: ~azure.mgmt.databoxedge.models.KubernetesRoleNetwork
    """

    _validation = {
        "compute": {"required": True},
        "network": {"readonly": True},
    }

    _attribute_map = {
        "storage": {"key": "storage", "type": "KubernetesRoleStorage"},
        "compute": {"key": "compute", "type": "KubernetesRoleCompute"},
        "network": {"key": "network", "type": "KubernetesRoleNetwork"},
    }

    def __init__(
        self,
        *,
        compute: "_models.KubernetesRoleCompute",
        storage: Optional["_models.KubernetesRoleStorage"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage: Kubernetes role storage resource.
        :paramtype storage: ~azure.mgmt.databoxedge.models.KubernetesRoleStorage
        :keyword compute: Kubernetes role compute resource. Required.
        :paramtype compute: ~azure.mgmt.databoxedge.models.KubernetesRoleCompute
        """
        super().__init__(**kwargs)
        self.storage = storage
        self.compute = compute
        self.network: Optional["_models.KubernetesRoleNetwork"] = None


class KubernetesRoleStorage(_serialization.Model):
    """Kubernetes role storage resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_classes: Kubernetes storage class info.
    :vartype storage_classes: list[~azure.mgmt.databoxedge.models.KubernetesRoleStorageClassInfo]
    :ivar endpoints: Mount points of shares in role(s).
    :vartype endpoints: list[~azure.mgmt.databoxedge.models.MountPointMap]
    """

    _validation = {
        "storage_classes": {"readonly": True},
    }

    _attribute_map = {
        "storage_classes": {"key": "storageClasses", "type": "[KubernetesRoleStorageClassInfo]"},
        "endpoints": {"key": "endpoints", "type": "[MountPointMap]"},
    }

    def __init__(self, *, endpoints: Optional[List["_models.MountPointMap"]] = None, **kwargs: Any) -> None:
        """
        :keyword endpoints: Mount points of shares in role(s).
        :paramtype endpoints: list[~azure.mgmt.databoxedge.models.MountPointMap]
        """
        super().__init__(**kwargs)
        self.storage_classes: Optional[List["_models.KubernetesRoleStorageClassInfo"]] = None
        self.endpoints = endpoints


class KubernetesRoleStorageClassInfo(_serialization.Model):
    """Kubernetes storage class info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Storage class name.
    :vartype name: str
    :ivar type: Storage class type.
    :vartype type: str
    :ivar posix_compliant: If provisioned storage is posix compliant. Known values are: "Invalid",
     "Enabled", and "Disabled".
    :vartype posix_compliant: str or ~azure.mgmt.databoxedge.models.PosixComplianceStatus
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "posix_compliant": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "posix_compliant": {"key": "posixCompliant", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.posix_compliant: Optional[Union[str, "_models.PosixComplianceStatus"]] = None


class LoadBalancerConfig(_serialization.Model):
    """Load balancer configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Load balancer type.
    :vartype type: str
    :ivar version: Load balancer version.
    :vartype version: str
    """

    _validation = {
        "type": {"readonly": True},
        "version": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.version: Optional[str] = None


class MECRole(Role):
    """MEC role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar kind: Role type. Required. Known values are: "IOT", "ASA", "Functions", "Cognitive",
     "MEC", "CloudEdgeManagement", and "Kubernetes".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.RoleTypes
    :ivar system_data: Role configured on ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar connection_string: Activation key of the MEC.
    :vartype connection_string: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
    :ivar controller_endpoint: Controller Endpoint.
    :vartype controller_endpoint: str
    :ivar resource_unique_id: Unique Id of the Resource.
    :vartype resource_unique_id: str
    :ivar role_status: Role status. Known values are: "Enabled" and "Disabled".
    :vartype role_status: str or ~azure.mgmt.databoxedge.models.RoleStatus
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "connection_string": {"key": "properties.connectionString", "type": "AsymmetricEncryptedSecret"},
        "controller_endpoint": {"key": "properties.controllerEndpoint", "type": "str"},
        "resource_unique_id": {"key": "properties.resourceUniqueId", "type": "str"},
        "role_status": {"key": "properties.roleStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        connection_string: Optional["_models.AsymmetricEncryptedSecret"] = None,
        controller_endpoint: Optional[str] = None,
        resource_unique_id: Optional[str] = None,
        role_status: Optional[Union[str, "_models.RoleStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword connection_string: Activation key of the MEC.
        :paramtype connection_string: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
        :keyword controller_endpoint: Controller Endpoint.
        :paramtype controller_endpoint: str
        :keyword resource_unique_id: Unique Id of the Resource.
        :paramtype resource_unique_id: str
        :keyword role_status: Role status. Known values are: "Enabled" and "Disabled".
        :paramtype role_status: str or ~azure.mgmt.databoxedge.models.RoleStatus
        """
        super().__init__(**kwargs)
        self.kind: str = "MEC"
        self.connection_string = connection_string
        self.controller_endpoint = controller_endpoint
        self.resource_unique_id = resource_unique_id
        self.role_status = role_status


class MetricConfiguration(_serialization.Model):
    """Metric configuration.

    All required parameters must be populated in order to send to server.

    :ivar resource_id: The Resource ID on which the metrics should be pushed. Required.
    :vartype resource_id: str
    :ivar mdm_account: The MDM account to which the counters should be pushed.
    :vartype mdm_account: str
    :ivar metric_name_space: The MDM namespace to which the counters should be pushed. This is
     required if MDMAccount is specified.
    :vartype metric_name_space: str
    :ivar counter_sets: Host name for the IoT hub associated to the device. Required.
    :vartype counter_sets: list[~azure.mgmt.databoxedge.models.MetricCounterSet]
    """

    _validation = {
        "resource_id": {"required": True},
        "counter_sets": {"required": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "mdm_account": {"key": "mdmAccount", "type": "str"},
        "metric_name_space": {"key": "metricNameSpace", "type": "str"},
        "counter_sets": {"key": "counterSets", "type": "[MetricCounterSet]"},
    }

    def __init__(
        self,
        *,
        resource_id: str,
        counter_sets: List["_models.MetricCounterSet"],
        mdm_account: Optional[str] = None,
        metric_name_space: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The Resource ID on which the metrics should be pushed. Required.
        :paramtype resource_id: str
        :keyword mdm_account: The MDM account to which the counters should be pushed.
        :paramtype mdm_account: str
        :keyword metric_name_space: The MDM namespace to which the counters should be pushed. This is
         required if MDMAccount is specified.
        :paramtype metric_name_space: str
        :keyword counter_sets: Host name for the IoT hub associated to the device. Required.
        :paramtype counter_sets: list[~azure.mgmt.databoxedge.models.MetricCounterSet]
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.mdm_account = mdm_account
        self.metric_name_space = metric_name_space
        self.counter_sets = counter_sets


class MetricCounter(_serialization.Model):
    """The metric counter.

    All required parameters must be populated in order to send to server.

    :ivar name: The counter name. Required.
    :vartype name: str
    :ivar instance: The instance from which counter should be collected.
    :vartype instance: str
    :ivar dimension_filter: The dimension filter.
    :vartype dimension_filter: list[~azure.mgmt.databoxedge.models.MetricDimension]
    :ivar additional_dimensions: The additional dimensions to be added to metric.
    :vartype additional_dimensions: list[~azure.mgmt.databoxedge.models.MetricDimension]
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "instance": {"key": "instance", "type": "str"},
        "dimension_filter": {"key": "dimensionFilter", "type": "[MetricDimension]"},
        "additional_dimensions": {"key": "additionalDimensions", "type": "[MetricDimension]"},
    }

    def __init__(
        self,
        *,
        name: str,
        instance: Optional[str] = None,
        dimension_filter: Optional[List["_models.MetricDimension"]] = None,
        additional_dimensions: Optional[List["_models.MetricDimension"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The counter name. Required.
        :paramtype name: str
        :keyword instance: The instance from which counter should be collected.
        :paramtype instance: str
        :keyword dimension_filter: The dimension filter.
        :paramtype dimension_filter: list[~azure.mgmt.databoxedge.models.MetricDimension]
        :keyword additional_dimensions: The additional dimensions to be added to metric.
        :paramtype additional_dimensions: list[~azure.mgmt.databoxedge.models.MetricDimension]
        """
        super().__init__(**kwargs)
        self.name = name
        self.instance = instance
        self.dimension_filter = dimension_filter
        self.additional_dimensions = additional_dimensions


class MetricCounterSet(_serialization.Model):
    """The metric counter set.

    All required parameters must be populated in order to send to server.

    :ivar counters: The counters that should be collected in this set. Required.
    :vartype counters: list[~azure.mgmt.databoxedge.models.MetricCounter]
    """

    _validation = {
        "counters": {"required": True},
    }

    _attribute_map = {
        "counters": {"key": "counters", "type": "[MetricCounter]"},
    }

    def __init__(self, *, counters: List["_models.MetricCounter"], **kwargs: Any) -> None:
        """
        :keyword counters: The counters that should be collected in this set. Required.
        :paramtype counters: list[~azure.mgmt.databoxedge.models.MetricCounter]
        """
        super().__init__(**kwargs)
        self.counters = counters


class MetricDimension(_serialization.Model):
    """The metric dimension.

    All required parameters must be populated in order to send to server.

    :ivar source_type: The dimension type. Required.
    :vartype source_type: str
    :ivar source_name: The dimension value. Required.
    :vartype source_name: str
    """

    _validation = {
        "source_type": {"required": True},
        "source_name": {"required": True},
    }

    _attribute_map = {
        "source_type": {"key": "sourceType", "type": "str"},
        "source_name": {"key": "sourceName", "type": "str"},
    }

    def __init__(self, *, source_type: str, source_name: str, **kwargs: Any) -> None:
        """
        :keyword source_type: The dimension type. Required.
        :paramtype source_type: str
        :keyword source_name: The dimension value. Required.
        :paramtype source_name: str
        """
        super().__init__(**kwargs)
        self.source_type = source_type
        self.source_name = source_name


class MetricDimensionV1(_serialization.Model):
    """Metric Dimension v1.

    :ivar name: Name of the metrics dimension.
    :vartype name: str
    :ivar display_name: Display name of the metrics dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: To be exported to shoe box.
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the metrics dimension.
        :paramtype name: str
        :keyword display_name: Display name of the metrics dimension.
        :paramtype display_name: str
        :keyword to_be_exported_for_shoebox: To be exported to shoe box.
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class MetricSpecificationV1(_serialization.Model):
    """Metric specification version 1.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar display_name: Display name of the metric.
    :vartype display_name: str
    :ivar display_description: Description of the metric to be displayed.
    :vartype display_description: str
    :ivar unit: Metric units. Known values are: "NotSpecified", "Percent", "Count", "Seconds",
     "Milliseconds", "Bytes", "BytesPerSecond", and "CountPerSecond".
    :vartype unit: str or ~azure.mgmt.databoxedge.models.MetricUnit
    :ivar aggregation_type: Metric aggregation type. Known values are: "NotSpecified", "None",
     "Average", "Minimum", "Maximum", "Total", and "Count".
    :vartype aggregation_type: str or ~azure.mgmt.databoxedge.models.MetricAggregationType
    :ivar dimensions: Metric dimensions, other than default dimension which is resource.
    :vartype dimensions: list[~azure.mgmt.databoxedge.models.MetricDimensionV1]
    :ivar fill_gap_with_zero: Set true to fill the gaps with zero.
    :vartype fill_gap_with_zero: bool
    :ivar category: Metric category. Known values are: "Capacity" and "Transaction".
    :vartype category: str or ~azure.mgmt.databoxedge.models.MetricCategory
    :ivar resource_id_dimension_name_override: Resource name override.
    :vartype resource_id_dimension_name_override: str
    :ivar supported_time_grain_types: Support granularity of metrics.
    :vartype supported_time_grain_types: list[str or ~azure.mgmt.databoxedge.models.TimeGrain]
    :ivar supported_aggregation_types: Support metric aggregation type.
    :vartype supported_aggregation_types: list[str or
     ~azure.mgmt.databoxedge.models.MetricAggregationType]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimensionV1]"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "category": {"key": "category", "type": "str"},
        "resource_id_dimension_name_override": {"key": "resourceIdDimensionNameOverride", "type": "str"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[Union[str, "_models.MetricUnit"]] = None,
        aggregation_type: Optional[Union[str, "_models.MetricAggregationType"]] = None,
        dimensions: Optional[List["_models.MetricDimensionV1"]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        category: Optional[Union[str, "_models.MetricCategory"]] = None,
        resource_id_dimension_name_override: Optional[str] = None,
        supported_time_grain_types: Optional[List[Union[str, "_models.TimeGrain"]]] = None,
        supported_aggregation_types: Optional[List[Union[str, "_models.MetricAggregationType"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the metric.
        :paramtype name: str
        :keyword display_name: Display name of the metric.
        :paramtype display_name: str
        :keyword display_description: Description of the metric to be displayed.
        :paramtype display_description: str
        :keyword unit: Metric units. Known values are: "NotSpecified", "Percent", "Count", "Seconds",
         "Milliseconds", "Bytes", "BytesPerSecond", and "CountPerSecond".
        :paramtype unit: str or ~azure.mgmt.databoxedge.models.MetricUnit
        :keyword aggregation_type: Metric aggregation type. Known values are: "NotSpecified", "None",
         "Average", "Minimum", "Maximum", "Total", and "Count".
        :paramtype aggregation_type: str or ~azure.mgmt.databoxedge.models.MetricAggregationType
        :keyword dimensions: Metric dimensions, other than default dimension which is resource.
        :paramtype dimensions: list[~azure.mgmt.databoxedge.models.MetricDimensionV1]
        :keyword fill_gap_with_zero: Set true to fill the gaps with zero.
        :paramtype fill_gap_with_zero: bool
        :keyword category: Metric category. Known values are: "Capacity" and "Transaction".
        :paramtype category: str or ~azure.mgmt.databoxedge.models.MetricCategory
        :keyword resource_id_dimension_name_override: Resource name override.
        :paramtype resource_id_dimension_name_override: str
        :keyword supported_time_grain_types: Support granularity of metrics.
        :paramtype supported_time_grain_types: list[str or ~azure.mgmt.databoxedge.models.TimeGrain]
        :keyword supported_aggregation_types: Support metric aggregation type.
        :paramtype supported_aggregation_types: list[str or
         ~azure.mgmt.databoxedge.models.MetricAggregationType]
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.dimensions = dimensions
        self.fill_gap_with_zero = fill_gap_with_zero
        self.category = category
        self.resource_id_dimension_name_override = resource_id_dimension_name_override
        self.supported_time_grain_types = supported_time_grain_types
        self.supported_aggregation_types = supported_aggregation_types


class MonitoringMetricConfiguration(ARMBaseModel):
    """The metric setting details for the role.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: MonitoringConfiguration on ASE device.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar metric_configurations: The metrics configuration details. Required.
    :vartype metric_configurations: list[~azure.mgmt.databoxedge.models.MetricConfiguration]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "metric_configurations": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "metric_configurations": {"key": "properties.metricConfigurations", "type": "[MetricConfiguration]"},
    }

    def __init__(self, *, metric_configurations: List["_models.MetricConfiguration"], **kwargs: Any) -> None:
        """
        :keyword metric_configurations: The metrics configuration details. Required.
        :paramtype metric_configurations: list[~azure.mgmt.databoxedge.models.MetricConfiguration]
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.metric_configurations = metric_configurations


class MonitoringMetricConfigurationList(_serialization.Model):
    """Collection of metric configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of metric configurations.
    :vartype value: list[~azure.mgmt.databoxedge.models.MonitoringMetricConfiguration]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MonitoringMetricConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.MonitoringMetricConfiguration"]] = None
        self.next_link: Optional[str] = None


class MountPointMap(_serialization.Model):
    """The share mount point.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar share_id: ID of the share mounted to the role VM. Required.
    :vartype share_id: str
    :ivar role_id: ID of the role to which share is mounted.
    :vartype role_id: str
    :ivar mount_point: Mount point for the share.
    :vartype mount_point: str
    :ivar mount_type: Mounting type. Known values are: "Volume" and "HostPath".
    :vartype mount_type: str or ~azure.mgmt.databoxedge.models.MountType
    :ivar role_type: Role type. Known values are: "IOT", "ASA", "Functions", "Cognitive", "MEC",
     "CloudEdgeManagement", and "Kubernetes".
    :vartype role_type: str or ~azure.mgmt.databoxedge.models.RoleTypes
    """

    _validation = {
        "share_id": {"required": True},
        "role_id": {"readonly": True},
        "mount_point": {"readonly": True},
        "mount_type": {"readonly": True},
        "role_type": {"readonly": True},
    }

    _attribute_map = {
        "share_id": {"key": "shareId", "type": "str"},
        "role_id": {"key": "roleId", "type": "str"},
        "mount_point": {"key": "mountPoint", "type": "str"},
        "mount_type": {"key": "mountType", "type": "str"},
        "role_type": {"key": "roleType", "type": "str"},
    }

    def __init__(self, *, share_id: str, **kwargs: Any) -> None:
        """
        :keyword share_id: ID of the share mounted to the role VM. Required.
        :paramtype share_id: str
        """
        super().__init__(**kwargs)
        self.share_id = share_id
        self.role_id: Optional[str] = None
        self.mount_point: Optional[str] = None
        self.mount_type: Optional[Union[str, "_models.MountType"]] = None
        self.role_type: Optional[Union[str, "_models.RoleTypes"]] = None


class NetworkAdapter(_serialization.Model):
    """Represents the networkAdapter on a device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar adapter_id: Instance ID of network adapter.
    :vartype adapter_id: str
    :ivar adapter_position: Hardware position of network adapter.
    :vartype adapter_position: ~azure.mgmt.databoxedge.models.NetworkAdapterPosition
    :ivar index: Logical index of the adapter.
    :vartype index: int
    :ivar node_id: Node ID of the network adapter.
    :vartype node_id: str
    :ivar network_adapter_name: Network adapter name.
    :vartype network_adapter_name: str
    :ivar label: Hardware label for the adapter.
    :vartype label: str
    :ivar mac_address: MAC address.
    :vartype mac_address: str
    :ivar link_speed: Link speed.
    :vartype link_speed: int
    :ivar status: Value indicating whether this adapter is valid. Known values are: "Inactive" and
     "Active".
    :vartype status: str or ~azure.mgmt.databoxedge.models.NetworkAdapterStatus
    :ivar rdma_status: Value indicating whether this adapter is RDMA capable. Known values are:
     "Incapable" and "Capable".
    :vartype rdma_status: str or ~azure.mgmt.databoxedge.models.NetworkAdapterRDMAStatus
    :ivar dhcp_status: Value indicating whether this adapter has DHCP enabled. Known values are:
     "Disabled" and "Enabled".
    :vartype dhcp_status: str or ~azure.mgmt.databoxedge.models.NetworkAdapterDHCPStatus
    :ivar ipv4_configuration: The IPv4 configuration of the network adapter.
    :vartype ipv4_configuration: ~azure.mgmt.databoxedge.models.Ipv4Config
    :ivar ipv6_configuration: The IPv6 configuration of the network adapter.
    :vartype ipv6_configuration: ~azure.mgmt.databoxedge.models.Ipv6Config
    :ivar ipv6_link_local_address: The IPv6 local address.
    :vartype ipv6_link_local_address: str
    :ivar dns_servers: The list of DNS Servers of the device.
    :vartype dns_servers: list[str]
    """

    _validation = {
        "adapter_id": {"readonly": True},
        "adapter_position": {"readonly": True},
        "index": {"readonly": True},
        "node_id": {"readonly": True},
        "network_adapter_name": {"readonly": True},
        "label": {"readonly": True},
        "mac_address": {"readonly": True},
        "link_speed": {"readonly": True},
        "status": {"readonly": True},
        "ipv4_configuration": {"readonly": True},
        "ipv6_configuration": {"readonly": True},
        "ipv6_link_local_address": {"readonly": True},
        "dns_servers": {"readonly": True},
    }

    _attribute_map = {
        "adapter_id": {"key": "adapterId", "type": "str"},
        "adapter_position": {"key": "adapterPosition", "type": "NetworkAdapterPosition"},
        "index": {"key": "index", "type": "int"},
        "node_id": {"key": "nodeId", "type": "str"},
        "network_adapter_name": {"key": "networkAdapterName", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
        "link_speed": {"key": "linkSpeed", "type": "int"},
        "status": {"key": "status", "type": "str"},
        "rdma_status": {"key": "rdmaStatus", "type": "str"},
        "dhcp_status": {"key": "dhcpStatus", "type": "str"},
        "ipv4_configuration": {"key": "ipv4Configuration", "type": "Ipv4Config"},
        "ipv6_configuration": {"key": "ipv6Configuration", "type": "Ipv6Config"},
        "ipv6_link_local_address": {"key": "ipv6LinkLocalAddress", "type": "str"},
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        rdma_status: Optional[Union[str, "_models.NetworkAdapterRDMAStatus"]] = None,
        dhcp_status: Optional[Union[str, "_models.NetworkAdapterDHCPStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rdma_status: Value indicating whether this adapter is RDMA capable. Known values are:
         "Incapable" and "Capable".
        :paramtype rdma_status: str or ~azure.mgmt.databoxedge.models.NetworkAdapterRDMAStatus
        :keyword dhcp_status: Value indicating whether this adapter has DHCP enabled. Known values are:
         "Disabled" and "Enabled".
        :paramtype dhcp_status: str or ~azure.mgmt.databoxedge.models.NetworkAdapterDHCPStatus
        """
        super().__init__(**kwargs)
        self.adapter_id: Optional[str] = None
        self.adapter_position: Optional["_models.NetworkAdapterPosition"] = None
        self.index: Optional[int] = None
        self.node_id: Optional[str] = None
        self.network_adapter_name: Optional[str] = None
        self.label: Optional[str] = None
        self.mac_address: Optional[str] = None
        self.link_speed: Optional[int] = None
        self.status: Optional[Union[str, "_models.NetworkAdapterStatus"]] = None
        self.rdma_status = rdma_status
        self.dhcp_status = dhcp_status
        self.ipv4_configuration: Optional["_models.Ipv4Config"] = None
        self.ipv6_configuration: Optional["_models.Ipv6Config"] = None
        self.ipv6_link_local_address: Optional[str] = None
        self.dns_servers: Optional[List[str]] = None


class NetworkAdapterPosition(_serialization.Model):
    """The network adapter position.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar network_group: The network group. Known values are: "None", "NonRDMA", and "RDMA".
    :vartype network_group: str or ~azure.mgmt.databoxedge.models.NetworkGroup
    :ivar port: The port.
    :vartype port: int
    """

    _validation = {
        "network_group": {"readonly": True},
        "port": {"readonly": True},
    }

    _attribute_map = {
        "network_group": {"key": "networkGroup", "type": "str"},
        "port": {"key": "port", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.network_group: Optional[Union[str, "_models.NetworkGroup"]] = None
        self.port: Optional[int] = None


class NetworkSettings(ARMBaseModel):
    """The network settings of a device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: NetworkSettings on ASE device.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar network_adapters: The network adapter list on the device.
    :vartype network_adapters: list[~azure.mgmt.databoxedge.models.NetworkAdapter]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "network_adapters": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "network_adapters": {"key": "properties.networkAdapters", "type": "[NetworkAdapter]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.network_adapters: Optional[List["_models.NetworkAdapter"]] = None


class Node(ARMBaseModel):
    """Represents a single node in a Data box Edge/Gateway device
    Gateway devices, standalone Edge devices and a single node cluster Edge device will all have 1
    node
    Multi-node Edge devices will have more than 1 nodes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar node_status: The current status of the individual node. Known values are: "Unknown",
     "Up", "Down", "Rebooting", and "ShuttingDown".
    :vartype node_status: str or ~azure.mgmt.databoxedge.models.NodeStatus
    :ivar node_chassis_serial_number: Serial number of the Chassis.
    :vartype node_chassis_serial_number: str
    :ivar node_serial_number: Serial number of the individual node.
    :vartype node_serial_number: str
    :ivar node_display_name: Display Name of the individual node.
    :vartype node_display_name: str
    :ivar node_friendly_software_version: Friendly software version name that is currently
     installed on the node.
    :vartype node_friendly_software_version: str
    :ivar node_hcs_version: HCS version that is currently installed on the node.
    :vartype node_hcs_version: str
    :ivar node_instance_id: Guid instance id of the node.
    :vartype node_instance_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "node_status": {"readonly": True},
        "node_chassis_serial_number": {"readonly": True},
        "node_serial_number": {"readonly": True},
        "node_display_name": {"readonly": True},
        "node_friendly_software_version": {"readonly": True},
        "node_hcs_version": {"readonly": True},
        "node_instance_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "node_status": {"key": "properties.nodeStatus", "type": "str"},
        "node_chassis_serial_number": {"key": "properties.nodeChassisSerialNumber", "type": "str"},
        "node_serial_number": {"key": "properties.nodeSerialNumber", "type": "str"},
        "node_display_name": {"key": "properties.nodeDisplayName", "type": "str"},
        "node_friendly_software_version": {"key": "properties.nodeFriendlySoftwareVersion", "type": "str"},
        "node_hcs_version": {"key": "properties.nodeHcsVersion", "type": "str"},
        "node_instance_id": {"key": "properties.nodeInstanceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.node_status: Optional[Union[str, "_models.NodeStatus"]] = None
        self.node_chassis_serial_number: Optional[str] = None
        self.node_serial_number: Optional[str] = None
        self.node_display_name: Optional[str] = None
        self.node_friendly_software_version: Optional[str] = None
        self.node_hcs_version: Optional[str] = None
        self.node_instance_id: Optional[str] = None


class NodeInfo(_serialization.Model):
    """Kubernetes node info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Node name.
    :vartype name: str
    :ivar type: Node type - Master/Worker. Known values are: "Invalid", "Master", and "Worker".
    :vartype type: str or ~azure.mgmt.databoxedge.models.KubernetesNodeType
    :ivar ip_configuration: IP Configuration of the Kubernetes node.
    :vartype ip_configuration: list[~azure.mgmt.databoxedge.models.KubernetesIPConfiguration]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "ip_configuration": {"key": "ipConfiguration", "type": "[KubernetesIPConfiguration]"},
    }

    def __init__(
        self, *, ip_configuration: Optional[List["_models.KubernetesIPConfiguration"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword ip_configuration: IP Configuration of the Kubernetes node.
        :paramtype ip_configuration: list[~azure.mgmt.databoxedge.models.KubernetesIPConfiguration]
        """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.type: Optional[Union[str, "_models.KubernetesNodeType"]] = None
        self.ip_configuration = ip_configuration


class NodeList(_serialization.Model):
    """Collection of Nodes.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of Nodes.
    :vartype value: list[~azure.mgmt.databoxedge.models.Node]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Node]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Link to the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Node"]] = None
        self.next_link = next_link


class Operation(_serialization.Model):
    """Operations.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar display: Properties displayed for the operation.
    :vartype display: ~azure.mgmt.databoxedge.models.OperationDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar service_specification: Service specification.
    :vartype service_specification: ~azure.mgmt.databoxedge.models.ServiceSpecification
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "service_specification": {"key": "properties.serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        service_specification: Optional["_models.ServiceSpecification"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword display: Properties displayed for the operation.
        :paramtype display: ~azure.mgmt.databoxedge.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword service_specification: Service specification.
        :paramtype service_specification: ~azure.mgmt.databoxedge.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.is_data_action = is_data_action
        self.service_specification = service_specification


class OperationDisplay(_serialization.Model):
    """Operation display properties.

    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: The type of resource in which the operation is performed.
    :vartype resource: str
    :ivar operation: Operation to be performed on the resource.
    :vartype operation: str
    :ivar description: Description of the operation to be performed.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Provider name.
        :paramtype provider: str
        :keyword resource: The type of resource in which the operation is performed.
        :paramtype resource: str
        :keyword operation: Operation to be performed on the resource.
        :paramtype operation: str
        :keyword description: Description of the operation to be performed.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsList(_serialization.Model):
    """The list of operations used for the discovery of available provider operations.

    All required parameters must be populated in order to send to server.

    :ivar value: The value. Required.
    :vartype value: list[~azure.mgmt.databoxedge.models.Operation]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.Operation"], next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The value. Required.
        :paramtype value: list[~azure.mgmt.databoxedge.models.Operation]
        :keyword next_link: Link to the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Order(ARMBaseModel):
    """The order details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Order configured on ASE resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar contact_information: The contact details.
    :vartype contact_information: ~azure.mgmt.databoxedge.models.ContactDetails
    :ivar shipping_address: The shipping address.
    :vartype shipping_address: ~azure.mgmt.databoxedge.models.Address
    :ivar current_status: Current status of the order.
    :vartype current_status: ~azure.mgmt.databoxedge.models.OrderStatus
    :ivar order_history: List of status changes in the order.
    :vartype order_history: list[~azure.mgmt.databoxedge.models.OrderStatus]
    :ivar serial_number: Serial number of the device.
    :vartype serial_number: str
    :ivar delivery_tracking_info: Tracking information for the package delivered to the customer
     whether it has an original or a replacement device.
    :vartype delivery_tracking_info: list[~azure.mgmt.databoxedge.models.TrackingInfo]
    :ivar return_tracking_info: Tracking information for the package returned from the customer
     whether it has an original or a replacement device.
    :vartype return_tracking_info: list[~azure.mgmt.databoxedge.models.TrackingInfo]
    :ivar shipment_type: ShipmentType of the order. Known values are: "NotApplicable",
     "ShippedToCustomer", and "SelfPickup".
    :vartype shipment_type: str or ~azure.mgmt.databoxedge.models.ShipmentType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "current_status": {"readonly": True},
        "order_history": {"readonly": True},
        "serial_number": {"readonly": True},
        "delivery_tracking_info": {"readonly": True},
        "return_tracking_info": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "contact_information": {"key": "properties.contactInformation", "type": "ContactDetails"},
        "shipping_address": {"key": "properties.shippingAddress", "type": "Address"},
        "current_status": {"key": "properties.currentStatus", "type": "OrderStatus"},
        "order_history": {"key": "properties.orderHistory", "type": "[OrderStatus]"},
        "serial_number": {"key": "properties.serialNumber", "type": "str"},
        "delivery_tracking_info": {"key": "properties.deliveryTrackingInfo", "type": "[TrackingInfo]"},
        "return_tracking_info": {"key": "properties.returnTrackingInfo", "type": "[TrackingInfo]"},
        "shipment_type": {"key": "properties.shipmentType", "type": "str"},
    }

    def __init__(
        self,
        *,
        contact_information: Optional["_models.ContactDetails"] = None,
        shipping_address: Optional["_models.Address"] = None,
        shipment_type: Optional[Union[str, "_models.ShipmentType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_information: The contact details.
        :paramtype contact_information: ~azure.mgmt.databoxedge.models.ContactDetails
        :keyword shipping_address: The shipping address.
        :paramtype shipping_address: ~azure.mgmt.databoxedge.models.Address
        :keyword shipment_type: ShipmentType of the order. Known values are: "NotApplicable",
         "ShippedToCustomer", and "SelfPickup".
        :paramtype shipment_type: str or ~azure.mgmt.databoxedge.models.ShipmentType
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.contact_information = contact_information
        self.shipping_address = shipping_address
        self.current_status: Optional["_models.OrderStatus"] = None
        self.order_history: Optional[List["_models.OrderStatus"]] = None
        self.serial_number: Optional[str] = None
        self.delivery_tracking_info: Optional[List["_models.TrackingInfo"]] = None
        self.return_tracking_info: Optional[List["_models.TrackingInfo"]] = None
        self.shipment_type = shipment_type


class OrderList(_serialization.Model):
    """List of order entities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of orders.
    :vartype value: list[~azure.mgmt.databoxedge.models.Order]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Order]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Order"]] = None
        self.next_link: Optional[str] = None


class OrderStatus(_serialization.Model):
    """Represents a single status change.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar status: Status of the order as per the allowed status types. Required. Known values are:
     "Untracked", "AwaitingFulfillment", "AwaitingPreparation", "AwaitingShipment", "Shipped",
     "Arriving", "Delivered", "ReplacementRequested", "LostDevice", "Declined", "ReturnInitiated",
     "AwaitingReturnShipment", "ShippedBack", "CollectedAtMicrosoft", "AwaitingPickup",
     "PickupCompleted", and "AwaitingDrop".
    :vartype status: str or ~azure.mgmt.databoxedge.models.OrderState
    :ivar update_date_time: Time of status update.
    :vartype update_date_time: ~datetime.datetime
    :ivar comments: Comments related to this status change.
    :vartype comments: str
    :ivar tracking_information: Tracking information related to the state in the ordering flow.
    :vartype tracking_information: ~azure.mgmt.databoxedge.models.TrackingInfo
    :ivar additional_order_details: Dictionary to hold generic information which is not stored
     by the already existing properties.
    :vartype additional_order_details: dict[str, str]
    """

    _validation = {
        "status": {"required": True},
        "update_date_time": {"readonly": True},
        "tracking_information": {"readonly": True},
        "additional_order_details": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "update_date_time": {"key": "updateDateTime", "type": "iso-8601"},
        "comments": {"key": "comments", "type": "str"},
        "tracking_information": {"key": "trackingInformation", "type": "TrackingInfo"},
        "additional_order_details": {"key": "additionalOrderDetails", "type": "{str}"},
    }

    def __init__(
        self, *, status: Union[str, "_models.OrderState"], comments: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the order as per the allowed status types. Required. Known values
         are: "Untracked", "AwaitingFulfillment", "AwaitingPreparation", "AwaitingShipment", "Shipped",
         "Arriving", "Delivered", "ReplacementRequested", "LostDevice", "Declined", "ReturnInitiated",
         "AwaitingReturnShipment", "ShippedBack", "CollectedAtMicrosoft", "AwaitingPickup",
         "PickupCompleted", and "AwaitingDrop".
        :paramtype status: str or ~azure.mgmt.databoxedge.models.OrderState
        :keyword comments: Comments related to this status change.
        :paramtype comments: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.update_date_time: Optional[datetime.datetime] = None
        self.comments = comments
        self.tracking_information: Optional["_models.TrackingInfo"] = None
        self.additional_order_details: Optional[Dict[str, str]] = None


class PeriodicTimerEventTrigger(Trigger):
    """Trigger details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Trigger in DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar kind: Trigger Kind. Required. Known values are: "FileEvent" and "PeriodicTimerEvent".
    :vartype kind: str or ~azure.mgmt.databoxedge.models.TriggerEventType
    :ivar source_info: Periodic timer details. Required.
    :vartype source_info: ~azure.mgmt.databoxedge.models.PeriodicTimerSourceInfo
    :ivar sink_info: Role Sink information. Required.
    :vartype sink_info: ~azure.mgmt.databoxedge.models.RoleSinkInfo
    :ivar custom_context_tag: A custom context tag typically used to correlate the trigger against
     its usage. For example, if a periodic timer trigger is intended for certain specific IoT
     modules in the device, the tag can be the name or the image URL of the module.
    :vartype custom_context_tag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "kind": {"required": True},
        "source_info": {"required": True},
        "sink_info": {"required": True},
        "custom_context_tag": {"max_length": 192},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "kind": {"key": "kind", "type": "str"},
        "source_info": {"key": "properties.sourceInfo", "type": "PeriodicTimerSourceInfo"},
        "sink_info": {"key": "properties.sinkInfo", "type": "RoleSinkInfo"},
        "custom_context_tag": {"key": "properties.customContextTag", "type": "str"},
    }

    def __init__(
        self,
        *,
        source_info: "_models.PeriodicTimerSourceInfo",
        sink_info: "_models.RoleSinkInfo",
        custom_context_tag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source_info: Periodic timer details. Required.
        :paramtype source_info: ~azure.mgmt.databoxedge.models.PeriodicTimerSourceInfo
        :keyword sink_info: Role Sink information. Required.
        :paramtype sink_info: ~azure.mgmt.databoxedge.models.RoleSinkInfo
        :keyword custom_context_tag: A custom context tag typically used to correlate the trigger
         against its usage. For example, if a periodic timer trigger is intended for certain specific
         IoT modules in the device, the tag can be the name or the image URL of the module.
        :paramtype custom_context_tag: str
        """
        super().__init__(**kwargs)
        self.kind: str = "PeriodicTimerEvent"
        self.source_info = source_info
        self.sink_info = sink_info
        self.custom_context_tag = custom_context_tag


class PeriodicTimerSourceInfo(_serialization.Model):
    """Periodic timer event source.

    All required parameters must be populated in order to send to server.

    :ivar start_time: The time of the day that results in a valid trigger. Schedule is computed
     with reference to the time specified upto seconds. If timezone is not specified the time will
     considered to be in device timezone. The value will always be returned as UTC time. Required.
    :vartype start_time: ~datetime.datetime
    :ivar schedule: Periodic frequency at which timer event needs to be raised. Supports daily,
     hourly, minutes, and seconds. Required.
    :vartype schedule: str
    :ivar topic: Topic where periodic events are published to IoT device.
    :vartype topic: str
    """

    _validation = {
        "start_time": {"required": True},
        "schedule": {"required": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "schedule": {"key": "schedule", "type": "str"},
        "topic": {"key": "topic", "type": "str"},
    }

    def __init__(
        self, *, start_time: datetime.datetime, schedule: str, topic: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword start_time: The time of the day that results in a valid trigger. Schedule is computed
         with reference to the time specified upto seconds. If timezone is not specified the time will
         considered to be in device timezone. The value will always be returned as UTC time. Required.
        :paramtype start_time: ~datetime.datetime
        :keyword schedule: Periodic frequency at which timer event needs to be raised. Supports daily,
         hourly, minutes, and seconds. Required.
        :paramtype schedule: str
        :keyword topic: Topic where periodic events are published to IoT device.
        :paramtype topic: str
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.schedule = schedule
        self.topic = topic


class RefreshDetails(_serialization.Model):
    """Fields for tracking refresh job on the share or container.

    :ivar in_progress_refresh_job_id: If a refresh job is currently in progress on this share or
     container, this field indicates the ARM resource ID of that job. The field is empty if no job
     is in progress.
    :vartype in_progress_refresh_job_id: str
    :ivar last_completed_refresh_job_time_in_utc: Indicates the completed time for the last refresh
     job on this particular share or container, if any.This could be a failed job or a successful
     job.
    :vartype last_completed_refresh_job_time_in_utc: ~datetime.datetime
    :ivar error_manifest_file: Indicates the relative path of the error xml for the last refresh
     job on this particular share or container, if any. This could be a failed job or a successful
     job.
    :vartype error_manifest_file: str
    :ivar last_job: Indicates the id of the last refresh job on this particular share or
     container,if any. This could be a failed job or a successful job.
    :vartype last_job: str
    """

    _attribute_map = {
        "in_progress_refresh_job_id": {"key": "inProgressRefreshJobId", "type": "str"},
        "last_completed_refresh_job_time_in_utc": {"key": "lastCompletedRefreshJobTimeInUTC", "type": "iso-8601"},
        "error_manifest_file": {"key": "errorManifestFile", "type": "str"},
        "last_job": {"key": "lastJob", "type": "str"},
    }

    def __init__(
        self,
        *,
        in_progress_refresh_job_id: Optional[str] = None,
        last_completed_refresh_job_time_in_utc: Optional[datetime.datetime] = None,
        error_manifest_file: Optional[str] = None,
        last_job: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword in_progress_refresh_job_id: If a refresh job is currently in progress on this share or
         container, this field indicates the ARM resource ID of that job. The field is empty if no job
         is in progress.
        :paramtype in_progress_refresh_job_id: str
        :keyword last_completed_refresh_job_time_in_utc: Indicates the completed time for the last
         refresh job on this particular share or container, if any.This could be a failed job or a
         successful job.
        :paramtype last_completed_refresh_job_time_in_utc: ~datetime.datetime
        :keyword error_manifest_file: Indicates the relative path of the error xml for the last refresh
         job on this particular share or container, if any. This could be a failed job or a successful
         job.
        :paramtype error_manifest_file: str
        :keyword last_job: Indicates the id of the last refresh job on this particular share or
         container,if any. This could be a failed job or a successful job.
        :paramtype last_job: str
        """
        super().__init__(**kwargs)
        self.in_progress_refresh_job_id = in_progress_refresh_job_id
        self.last_completed_refresh_job_time_in_utc = last_completed_refresh_job_time_in_utc
        self.error_manifest_file = error_manifest_file
        self.last_job = last_job


class ResourceIdentity(_serialization.Model):
    """Msi identity details of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Identity type. Known values are: "None", "SystemAssigned", and "UserAssigned".
    :vartype type: str or ~azure.mgmt.databoxedge.models.MsiIdentityType
    :ivar principal_id: Service Principal Id backing the Msi.
    :vartype principal_id: str
    :ivar tenant_id: Home Tenant Id.
    :vartype tenant_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.MsiIdentityType"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: Identity type. Known values are: "None", "SystemAssigned", and "UserAssigned".
        :paramtype type: str or ~azure.mgmt.databoxedge.models.MsiIdentityType
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None


class ResourceMoveDetails(_serialization.Model):
    """Fields for tracking resource move.

    :ivar operation_in_progress: Denotes whether move operation is in progress. Known values are:
     "None", "ResourceMoveInProgress", and "ResourceMoveFailed".
    :vartype operation_in_progress: str or ~azure.mgmt.databoxedge.models.ResourceMoveStatus
    :ivar operation_in_progress_lock_timeout_in_utc: Denotes the timeout of the operation to
     finish.
    :vartype operation_in_progress_lock_timeout_in_utc: ~datetime.datetime
    """

    _attribute_map = {
        "operation_in_progress": {"key": "operationInProgress", "type": "str"},
        "operation_in_progress_lock_timeout_in_utc": {"key": "operationInProgressLockTimeoutInUTC", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        operation_in_progress: Optional[Union[str, "_models.ResourceMoveStatus"]] = None,
        operation_in_progress_lock_timeout_in_utc: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword operation_in_progress: Denotes whether move operation is in progress. Known values
         are: "None", "ResourceMoveInProgress", and "ResourceMoveFailed".
        :paramtype operation_in_progress: str or ~azure.mgmt.databoxedge.models.ResourceMoveStatus
        :keyword operation_in_progress_lock_timeout_in_utc: Denotes the timeout of the operation to
         finish.
        :paramtype operation_in_progress_lock_timeout_in_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.operation_in_progress = operation_in_progress
        self.operation_in_progress_lock_timeout_in_utc = operation_in_progress_lock_timeout_in_utc


class ResourceTypeSku(_serialization.Model):
    """Resource type Sku object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The resource type.
    :vartype resource_type: str
    :ivar skus: The skus.
    :vartype skus: list[~azure.mgmt.databoxedge.models.SkuInformation]
    """

    _validation = {
        "resource_type": {"readonly": True},
        "skus": {"readonly": True},
    }

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "skus": {"key": "skus", "type": "[SkuInformation]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_type: Optional[str] = None
        self.skus: Optional[List["_models.SkuInformation"]] = None


class RoleList(_serialization.Model):
    """Collection of all the roles on the Data Box Edge device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The Value.
    :vartype value: list[~azure.mgmt.databoxedge.models.Role]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Role]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Role"]] = None
        self.next_link: Optional[str] = None


class RoleSinkInfo(_serialization.Model):
    """Compute role against which events will be raised.

    All required parameters must be populated in order to send to server.

    :ivar role_id: Compute role ID. Required.
    :vartype role_id: str
    """

    _validation = {
        "role_id": {"required": True},
    }

    _attribute_map = {
        "role_id": {"key": "roleId", "type": "str"},
    }

    def __init__(self, *, role_id: str, **kwargs: Any) -> None:
        """
        :keyword role_id: Compute role ID. Required.
        :paramtype role_id: str
        """
        super().__init__(**kwargs)
        self.role_id = role_id


class Secret(_serialization.Model):
    """Holds device secret either as a KeyVault reference or as an encrypted value.

    :ivar encrypted_secret: Encrypted (using device public key) secret value.
    :vartype encrypted_secret: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
    :ivar key_vault_id: Id of the Key-Vault where secret is stored (ex:
     secrets/AuthClientSecret/82ef4346187a4033a10d629cde07d740).
    :vartype key_vault_id: str
    """

    _attribute_map = {
        "encrypted_secret": {"key": "encryptedSecret", "type": "AsymmetricEncryptedSecret"},
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
    }

    def __init__(
        self,
        *,
        encrypted_secret: Optional["_models.AsymmetricEncryptedSecret"] = None,
        key_vault_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encrypted_secret: Encrypted (using device public key) secret value.
        :paramtype encrypted_secret: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
        :keyword key_vault_id: Id of the Key-Vault where secret is stored (ex:
         secrets/AuthClientSecret/82ef4346187a4033a10d629cde07d740).
        :paramtype key_vault_id: str
        """
        super().__init__(**kwargs)
        self.encrypted_secret = encrypted_secret
        self.key_vault_id = key_vault_id


class SecuritySettings(ARMBaseModel):
    """The security settings of a device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar device_admin_password: Device administrator password as an encrypted string (encrypted
     using RSA PKCS #1) is used to sign into the  local web UI of the device. The Actual password
     should have at least 8 characters that are a combination of  uppercase, lowercase, numeric, and
     special characters. Required.
    :vartype device_admin_password: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "device_admin_password": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "device_admin_password": {"key": "properties.deviceAdminPassword", "type": "AsymmetricEncryptedSecret"},
    }

    def __init__(self, *, device_admin_password: "_models.AsymmetricEncryptedSecret", **kwargs: Any) -> None:
        """
        :keyword device_admin_password: Device administrator password as an encrypted string (encrypted
         using RSA PKCS #1) is used to sign into the  local web UI of the device. The Actual password
         should have at least 8 characters that are a combination of  uppercase, lowercase, numeric, and
         special characters. Required.
        :paramtype device_admin_password: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
        """
        super().__init__(**kwargs)
        self.device_admin_password = device_admin_password


class ServiceSpecification(_serialization.Model):
    """Service specification.

    :ivar metric_specifications: Metric specification as defined by shoebox.
    :vartype metric_specifications: list[~azure.mgmt.databoxedge.models.MetricSpecificationV1]
    """

    _attribute_map = {
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecificationV1]"},
    }

    def __init__(
        self, *, metric_specifications: Optional[List["_models.MetricSpecificationV1"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword metric_specifications: Metric specification as defined by shoebox.
        :paramtype metric_specifications: list[~azure.mgmt.databoxedge.models.MetricSpecificationV1]
        """
        super().__init__(**kwargs)
        self.metric_specifications = metric_specifications


class Share(ARMBaseModel):
    """Represents a share on the  Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: Share on ASE device.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar description: Description for the share.
    :vartype description: str
    :ivar share_status: Current status of the share. Required. Known values are: "Offline",
     "Unknown", "OK", "Updating", and "NeedsAttention".
    :vartype share_status: str or ~azure.mgmt.databoxedge.models.ShareStatus
    :ivar monitoring_status: Current monitoring status of the share. Required. Known values are:
     "Enabled" and "Disabled".
    :vartype monitoring_status: str or ~azure.mgmt.databoxedge.models.MonitoringStatus
    :ivar azure_container_info: Azure container mapping for the share.
    :vartype azure_container_info: ~azure.mgmt.databoxedge.models.AzureContainerInfo
    :ivar access_protocol: Access protocol to be used by the share. Required. Known values are:
     "SMB" and "NFS".
    :vartype access_protocol: str or ~azure.mgmt.databoxedge.models.ShareAccessProtocol
    :ivar user_access_rights: Mapping of users and corresponding access rights on the share
     (required for SMB protocol).
    :vartype user_access_rights: list[~azure.mgmt.databoxedge.models.UserAccessRight]
    :ivar client_access_rights: List of IP addresses and corresponding access rights on the
     share(required for NFS protocol).
    :vartype client_access_rights: list[~azure.mgmt.databoxedge.models.ClientAccessRight]
    :ivar refresh_details: Details of the refresh job on this share.
    :vartype refresh_details: ~azure.mgmt.databoxedge.models.RefreshDetails
    :ivar share_mappings: Share mount point to the role.
    :vartype share_mappings: list[~azure.mgmt.databoxedge.models.MountPointMap]
    :ivar data_policy: Data policy of the share. Known values are: "Cloud" and "Local".
    :vartype data_policy: str or ~azure.mgmt.databoxedge.models.DataPolicy
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "share_status": {"required": True},
        "monitoring_status": {"required": True},
        "access_protocol": {"required": True},
        "share_mappings": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "share_status": {"key": "properties.shareStatus", "type": "str"},
        "monitoring_status": {"key": "properties.monitoringStatus", "type": "str"},
        "azure_container_info": {"key": "properties.azureContainerInfo", "type": "AzureContainerInfo"},
        "access_protocol": {"key": "properties.accessProtocol", "type": "str"},
        "user_access_rights": {"key": "properties.userAccessRights", "type": "[UserAccessRight]"},
        "client_access_rights": {"key": "properties.clientAccessRights", "type": "[ClientAccessRight]"},
        "refresh_details": {"key": "properties.refreshDetails", "type": "RefreshDetails"},
        "share_mappings": {"key": "properties.shareMappings", "type": "[MountPointMap]"},
        "data_policy": {"key": "properties.dataPolicy", "type": "str"},
    }

    def __init__(
        self,
        *,
        share_status: Union[str, "_models.ShareStatus"],
        monitoring_status: Union[str, "_models.MonitoringStatus"],
        access_protocol: Union[str, "_models.ShareAccessProtocol"],
        description: Optional[str] = None,
        azure_container_info: Optional["_models.AzureContainerInfo"] = None,
        user_access_rights: Optional[List["_models.UserAccessRight"]] = None,
        client_access_rights: Optional[List["_models.ClientAccessRight"]] = None,
        refresh_details: Optional["_models.RefreshDetails"] = None,
        data_policy: Optional[Union[str, "_models.DataPolicy"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the share.
        :paramtype description: str
        :keyword share_status: Current status of the share. Required. Known values are: "Offline",
         "Unknown", "OK", "Updating", and "NeedsAttention".
        :paramtype share_status: str or ~azure.mgmt.databoxedge.models.ShareStatus
        :keyword monitoring_status: Current monitoring status of the share. Required. Known values are:
         "Enabled" and "Disabled".
        :paramtype monitoring_status: str or ~azure.mgmt.databoxedge.models.MonitoringStatus
        :keyword azure_container_info: Azure container mapping for the share.
        :paramtype azure_container_info: ~azure.mgmt.databoxedge.models.AzureContainerInfo
        :keyword access_protocol: Access protocol to be used by the share. Required. Known values are:
         "SMB" and "NFS".
        :paramtype access_protocol: str or ~azure.mgmt.databoxedge.models.ShareAccessProtocol
        :keyword user_access_rights: Mapping of users and corresponding access rights on the share
         (required for SMB protocol).
        :paramtype user_access_rights: list[~azure.mgmt.databoxedge.models.UserAccessRight]
        :keyword client_access_rights: List of IP addresses and corresponding access rights on the
         share(required for NFS protocol).
        :paramtype client_access_rights: list[~azure.mgmt.databoxedge.models.ClientAccessRight]
        :keyword refresh_details: Details of the refresh job on this share.
        :paramtype refresh_details: ~azure.mgmt.databoxedge.models.RefreshDetails
        :keyword data_policy: Data policy of the share. Known values are: "Cloud" and "Local".
        :paramtype data_policy: str or ~azure.mgmt.databoxedge.models.DataPolicy
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.description = description
        self.share_status = share_status
        self.monitoring_status = monitoring_status
        self.azure_container_info = azure_container_info
        self.access_protocol = access_protocol
        self.user_access_rights = user_access_rights
        self.client_access_rights = client_access_rights
        self.refresh_details = refresh_details
        self.share_mappings: Optional[List["_models.MountPointMap"]] = None
        self.data_policy = data_policy


class ShareAccessRight(_serialization.Model):
    """Specifies the mapping between this particular user and the type of access he has on shares on
    this device.

    All required parameters must be populated in order to send to server.

    :ivar share_id: The share ID. Required.
    :vartype share_id: str
    :ivar access_type: Type of access to be allowed on the share for this user. Required. Known
     values are: "Change", "Read", and "Custom".
    :vartype access_type: str or ~azure.mgmt.databoxedge.models.ShareAccessType
    """

    _validation = {
        "share_id": {"required": True},
        "access_type": {"required": True},
    }

    _attribute_map = {
        "share_id": {"key": "shareId", "type": "str"},
        "access_type": {"key": "accessType", "type": "str"},
    }

    def __init__(self, *, share_id: str, access_type: Union[str, "_models.ShareAccessType"], **kwargs: Any) -> None:
        """
        :keyword share_id: The share ID. Required.
        :paramtype share_id: str
        :keyword access_type: Type of access to be allowed on the share for this user. Required. Known
         values are: "Change", "Read", and "Custom".
        :paramtype access_type: str or ~azure.mgmt.databoxedge.models.ShareAccessType
        """
        super().__init__(**kwargs)
        self.share_id = share_id
        self.access_type = access_type


class ShareList(_serialization.Model):
    """Collection of all the shares on the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of shares.
    :vartype value: list[~azure.mgmt.databoxedge.models.Share]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Share]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Share"]] = None
        self.next_link: Optional[str] = None


class Sku(_serialization.Model):
    """The SKU type.

    :ivar name: SKU name. Known values are: "Gateway", "Edge", "TEA_1Node", "TEA_1Node_UPS",
     "TEA_1Node_Heater", "TEA_1Node_UPS_Heater", "TEA_4Node_Heater", "TEA_4Node_UPS_Heater", "TMA",
     "TDC", "TCA_Small", "GPU", "TCA_Large", "EdgeP_Base", "EdgeP_High", "EdgePR_Base",
     "EdgePR_Base_UPS", "EP2_64_1VPU_W", "EP2_128_1T4_Mx1_W", "EP2_256_2T4_W", "EdgeMR_Mini",
     "RCA_Small", "RCA_Large", "RDC", and "Management".
    :vartype name: str or ~azure.mgmt.databoxedge.models.SkuName
    :ivar tier: The SKU tier. This is based on the SKU name. "Standard"
    :vartype tier: str or ~azure.mgmt.databoxedge.models.SkuTier
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.SkuName"]] = None,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: SKU name. Known values are: "Gateway", "Edge", "TEA_1Node", "TEA_1Node_UPS",
         "TEA_1Node_Heater", "TEA_1Node_UPS_Heater", "TEA_4Node_Heater", "TEA_4Node_UPS_Heater", "TMA",
         "TDC", "TCA_Small", "GPU", "TCA_Large", "EdgeP_Base", "EdgeP_High", "EdgePR_Base",
         "EdgePR_Base_UPS", "EP2_64_1VPU_W", "EP2_128_1T4_Mx1_W", "EP2_256_2T4_W", "EdgeMR_Mini",
         "RCA_Small", "RCA_Large", "RDC", and "Management".
        :paramtype name: str or ~azure.mgmt.databoxedge.models.SkuName
        :keyword tier: The SKU tier. This is based on the SKU name. "Standard"
        :paramtype tier: str or ~azure.mgmt.databoxedge.models.SkuTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class SkuCapability(_serialization.Model):
    """The metadata to describe the capability.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: An invariant to describe the feature.
    :vartype name: str
    :ivar value: An invariant if the feature is measured by quantity.
    :vartype value: str
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.value: Optional[str] = None


class SkuCost(_serialization.Model):
    """The metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Used for querying price from commerce.
    :vartype meter_id: str
    :ivar quantity: The cost quantity.
    :vartype quantity: int
    :ivar extended_unit: The extended unit.
    :vartype extended_unit: str
    """

    _validation = {
        "meter_id": {"readonly": True},
        "quantity": {"readonly": True},
        "extended_unit": {"readonly": True},
    }

    _attribute_map = {
        "meter_id": {"key": "meterId", "type": "str"},
        "quantity": {"key": "quantity", "type": "int"},
        "extended_unit": {"key": "extendedUnit", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.meter_id: Optional[str] = None
        self.quantity: Optional[int] = None
        self.extended_unit: Optional[str] = None


class SkuInformation(_serialization.Model):
    """Sku information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: The sku tier.
    :vartype tier: str
    :ivar kind: The sku kind.
    :vartype kind: str
    :ivar family: The Sku family.
    :vartype family: str
    :ivar costs: The pricing info of the Sku.
    :vartype costs: list[~azure.mgmt.databoxedge.models.SkuCost]
    :ivar locations: The locations where Sku is available.
    :vartype locations: list[str]
    :ivar location_info: The locations where Sku is available with zones and sites info.
    :vartype location_info: list[~azure.mgmt.databoxedge.models.SkuLocationInfo]
    :ivar required_quota_ids: The required quotaIds for the sku to be available.
    :vartype required_quota_ids: list[str]
    :ivar required_features: The required features for the sku to be available.
    :vartype required_features: list[str]
    """

    _validation = {
        "name": {"readonly": True},
        "tier": {"readonly": True},
        "kind": {"readonly": True},
        "family": {"readonly": True},
        "costs": {"readonly": True},
        "locations": {"readonly": True},
        "location_info": {"readonly": True},
        "required_quota_ids": {"readonly": True},
        "required_features": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "costs": {"key": "costs", "type": "[SkuCost]"},
        "locations": {"key": "locations", "type": "[str]"},
        "location_info": {"key": "locationInfo", "type": "[SkuLocationInfo]"},
        "required_quota_ids": {"key": "requiredQuotaIds", "type": "[str]"},
        "required_features": {"key": "requiredFeatures", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name: Optional[str] = None
        self.tier: Optional[str] = None
        self.kind: Optional[str] = None
        self.family: Optional[str] = None
        self.costs: Optional[List["_models.SkuCost"]] = None
        self.locations: Optional[List[str]] = None
        self.location_info: Optional[List["_models.SkuLocationInfo"]] = None
        self.required_quota_ids: Optional[List[str]] = None
        self.required_features: Optional[List[str]] = None


class SkuInformationList(_serialization.Model):
    """List of SKU Information objects.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of ResourceTypeSku objects.
    :vartype value: list[~azure.mgmt.databoxedge.models.ResourceTypeSku]
    :ivar next_link: Links to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceTypeSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.ResourceTypeSku"]] = None
        self.next_link: Optional[str] = None


class SkuLocationInfo(_serialization.Model):
    """The location info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: The location.
    :vartype location: str
    :ivar zones: The zones.
    :vartype zones: list[str]
    :ivar sites: The sites.
    :vartype sites: list[str]
    """

    _validation = {
        "location": {"readonly": True},
        "zones": {"readonly": True},
        "sites": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "sites": {"key": "sites", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location: Optional[str] = None
        self.zones: Optional[List[str]] = None
        self.sites: Optional[List[str]] = None


class StorageAccount(ARMBaseModel):
    """Represents a Storage Account on the  Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: StorageAccount object on ASE device.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar description: Description for the storage Account.
    :vartype description: str
    :ivar storage_account_status: Current status of the storage account. Known values are: "OK",
     "Offline", "Unknown", "Updating", and "NeedsAttention".
    :vartype storage_account_status: str or ~azure.mgmt.databoxedge.models.StorageAccountStatus
    :ivar data_policy: Data policy of the storage Account. Required. Known values are: "Cloud" and
     "Local".
    :vartype data_policy: str or ~azure.mgmt.databoxedge.models.DataPolicy
    :ivar storage_account_credential_id: Storage Account Credential Id.
    :vartype storage_account_credential_id: str
    :ivar blob_endpoint: BlobEndpoint of Storage Account.
    :vartype blob_endpoint: str
    :ivar container_count: The Container Count. Present only for Storage Accounts with DataPolicy
     set to Cloud.
    :vartype container_count: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "data_policy": {"required": True},
        "blob_endpoint": {"readonly": True},
        "container_count": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "description": {"key": "properties.description", "type": "str"},
        "storage_account_status": {"key": "properties.storageAccountStatus", "type": "str"},
        "data_policy": {"key": "properties.dataPolicy", "type": "str"},
        "storage_account_credential_id": {"key": "properties.storageAccountCredentialId", "type": "str"},
        "blob_endpoint": {"key": "properties.blobEndpoint", "type": "str"},
        "container_count": {"key": "properties.containerCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        data_policy: Union[str, "_models.DataPolicy"],
        description: Optional[str] = None,
        storage_account_status: Optional[Union[str, "_models.StorageAccountStatus"]] = None,
        storage_account_credential_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword description: Description for the storage Account.
        :paramtype description: str
        :keyword storage_account_status: Current status of the storage account. Known values are: "OK",
         "Offline", "Unknown", "Updating", and "NeedsAttention".
        :paramtype storage_account_status: str or ~azure.mgmt.databoxedge.models.StorageAccountStatus
        :keyword data_policy: Data policy of the storage Account. Required. Known values are: "Cloud"
         and "Local".
        :paramtype data_policy: str or ~azure.mgmt.databoxedge.models.DataPolicy
        :keyword storage_account_credential_id: Storage Account Credential Id.
        :paramtype storage_account_credential_id: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.description = description
        self.storage_account_status = storage_account_status
        self.data_policy = data_policy
        self.storage_account_credential_id = storage_account_credential_id
        self.blob_endpoint: Optional[str] = None
        self.container_count: Optional[int] = None


class StorageAccountCredential(ARMBaseModel):
    """The storage account credential.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: StorageAccountCredential object.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar alias: Alias for the storage account. Required.
    :vartype alias: str
    :ivar user_name: Username for the storage account.
    :vartype user_name: str
    :ivar account_key: Encrypted storage key.
    :vartype account_key: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
    :ivar connection_string: Connection string for the storage account. Use this string if username
     and account key are not specified.
    :vartype connection_string: str
    :ivar ssl_status: Signifies whether SSL needs to be enabled or not. Required. Known values are:
     "Enabled" and "Disabled".
    :vartype ssl_status: str or ~azure.mgmt.databoxedge.models.SSLStatus
    :ivar blob_domain_name: Blob end point for private clouds.
    :vartype blob_domain_name: str
    :ivar account_type: Type of storage accessed on the storage account. Required. Known values
     are: "GeneralPurposeStorage" and "BlobStorage".
    :vartype account_type: str or ~azure.mgmt.databoxedge.models.AccountType
    :ivar storage_account_id: Id of the storage account.
    :vartype storage_account_id: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "alias": {"required": True},
        "ssl_status": {"required": True},
        "account_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "alias": {"key": "properties.alias", "type": "str"},
        "user_name": {"key": "properties.userName", "type": "str"},
        "account_key": {"key": "properties.accountKey", "type": "AsymmetricEncryptedSecret"},
        "connection_string": {"key": "properties.connectionString", "type": "str"},
        "ssl_status": {"key": "properties.sslStatus", "type": "str"},
        "blob_domain_name": {"key": "properties.blobDomainName", "type": "str"},
        "account_type": {"key": "properties.accountType", "type": "str"},
        "storage_account_id": {"key": "properties.storageAccountId", "type": "str"},
    }

    def __init__(
        self,
        *,
        alias: str,
        ssl_status: Union[str, "_models.SSLStatus"],
        account_type: Union[str, "_models.AccountType"],
        user_name: Optional[str] = None,
        account_key: Optional["_models.AsymmetricEncryptedSecret"] = None,
        connection_string: Optional[str] = None,
        blob_domain_name: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword alias: Alias for the storage account. Required.
        :paramtype alias: str
        :keyword user_name: Username for the storage account.
        :paramtype user_name: str
        :keyword account_key: Encrypted storage key.
        :paramtype account_key: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
        :keyword connection_string: Connection string for the storage account. Use this string if
         username and account key are not specified.
        :paramtype connection_string: str
        :keyword ssl_status: Signifies whether SSL needs to be enabled or not. Required. Known values
         are: "Enabled" and "Disabled".
        :paramtype ssl_status: str or ~azure.mgmt.databoxedge.models.SSLStatus
        :keyword blob_domain_name: Blob end point for private clouds.
        :paramtype blob_domain_name: str
        :keyword account_type: Type of storage accessed on the storage account. Required. Known values
         are: "GeneralPurposeStorage" and "BlobStorage".
        :paramtype account_type: str or ~azure.mgmt.databoxedge.models.AccountType
        :keyword storage_account_id: Id of the storage account.
        :paramtype storage_account_id: str
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.alias = alias
        self.user_name = user_name
        self.account_key = account_key
        self.connection_string = connection_string
        self.ssl_status = ssl_status
        self.blob_domain_name = blob_domain_name
        self.account_type = account_type
        self.storage_account_id = storage_account_id


class StorageAccountCredentialList(_serialization.Model):
    """The collection of storage account credentials.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The value.
    :vartype value: list[~azure.mgmt.databoxedge.models.StorageAccountCredential]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageAccountCredential]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.StorageAccountCredential"]] = None
        self.next_link: Optional[str] = None


class StorageAccountList(_serialization.Model):
    """Collection of all the Storage Accounts on the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of storageAccounts.
    :vartype value: list[~azure.mgmt.databoxedge.models.StorageAccount]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[StorageAccount]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.StorageAccount"]] = None
        self.next_link: Optional[str] = None


class SubscriptionRegisteredFeatures(_serialization.Model):
    """SubscriptionRegisteredFeatures.

    :ivar name:
    :vartype name: str
    :ivar state:
    :vartype state: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "state": {"key": "state", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, state: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name:
        :paramtype name: str
        :keyword state:
        :paramtype state: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.state = state


class SymmetricKey(_serialization.Model):
    """Symmetric key for authentication.

    :ivar connection_string: Connection string based on the symmetric key.
    :vartype connection_string: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
    """

    _attribute_map = {
        "connection_string": {"key": "connectionString", "type": "AsymmetricEncryptedSecret"},
    }

    def __init__(
        self, *, connection_string: Optional["_models.AsymmetricEncryptedSecret"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword connection_string: Connection string based on the symmetric key.
        :paramtype connection_string: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
        """
        super().__init__(**kwargs)
        self.connection_string = connection_string


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.databoxedge.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.databoxedge.models.CreatedByType
    :ivar last_modified_at: The type of identity that last modified the resource.
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.databoxedge.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.databoxedge.models.CreatedByType
        :keyword last_modified_at: The type of identity that last modified the resource.
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TrackingInfo(_serialization.Model):
    """Tracking courier information.

    :ivar serial_number: Serial number of the device being tracked.
    :vartype serial_number: str
    :ivar carrier_name: Name of the carrier used in the delivery.
    :vartype carrier_name: str
    :ivar tracking_id: Tracking ID of the shipment.
    :vartype tracking_id: str
    :ivar tracking_url: Tracking URL of the shipment.
    :vartype tracking_url: str
    """

    _attribute_map = {
        "serial_number": {"key": "serialNumber", "type": "str"},
        "carrier_name": {"key": "carrierName", "type": "str"},
        "tracking_id": {"key": "trackingId", "type": "str"},
        "tracking_url": {"key": "trackingUrl", "type": "str"},
    }

    def __init__(
        self,
        *,
        serial_number: Optional[str] = None,
        carrier_name: Optional[str] = None,
        tracking_id: Optional[str] = None,
        tracking_url: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword serial_number: Serial number of the device being tracked.
        :paramtype serial_number: str
        :keyword carrier_name: Name of the carrier used in the delivery.
        :paramtype carrier_name: str
        :keyword tracking_id: Tracking ID of the shipment.
        :paramtype tracking_id: str
        :keyword tracking_url: Tracking URL of the shipment.
        :paramtype tracking_url: str
        """
        super().__init__(**kwargs)
        self.serial_number = serial_number
        self.carrier_name = carrier_name
        self.tracking_id = tracking_id
        self.tracking_url = tracking_url


class TriggerList(_serialization.Model):
    """Collection of all trigger on the data box edge device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of triggers.
    :vartype value: list[~azure.mgmt.databoxedge.models.Trigger]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Trigger]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.Trigger"]] = None
        self.next_link: Optional[str] = None


class UpdateDetails(_serialization.Model):
    """Update Specific attributes.

    :ivar update_title: Title of the Update.
    :vartype update_title: str
    :ivar update_size: Size of the update(In Bytes).
    :vartype update_size: float
    :ivar update_type: Type of the Update. Known values are: "Software", "Kubernetes", and
     "Firmware".
    :vartype update_type: str or ~azure.mgmt.databoxedge.models.UpdateType
    :ivar target_version: Target Version number.
    :vartype target_version: str
    :ivar estimated_install_time_in_mins: Estimated Install Time for the update.
    :vartype estimated_install_time_in_mins: int
    :ivar reboot_behavior: Indicates if updates are available and at least one of the updates needs
     a reboot. Known values are: "NeverReboots", "RequiresReboot", and "RequestReboot".
    :vartype reboot_behavior: str or ~azure.mgmt.databoxedge.models.InstallRebootBehavior
    :ivar status: Status of the update. Known values are: "DownloadPending", "DownloadStarted",
     "DownloadCompleted", "InstallStarted", and "InstallCompleted".
    :vartype status: str or ~azure.mgmt.databoxedge.models.UpdateStatus
    """

    _attribute_map = {
        "update_title": {"key": "updateTitle", "type": "str"},
        "update_size": {"key": "updateSize", "type": "float"},
        "update_type": {"key": "updateType", "type": "str"},
        "target_version": {"key": "targetVersion", "type": "str"},
        "estimated_install_time_in_mins": {"key": "estimatedInstallTimeInMins", "type": "int"},
        "reboot_behavior": {"key": "rebootBehavior", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        update_title: Optional[str] = None,
        update_size: Optional[float] = None,
        update_type: Optional[Union[str, "_models.UpdateType"]] = None,
        target_version: Optional[str] = None,
        estimated_install_time_in_mins: Optional[int] = None,
        reboot_behavior: Optional[Union[str, "_models.InstallRebootBehavior"]] = None,
        status: Optional[Union[str, "_models.UpdateStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword update_title: Title of the Update.
        :paramtype update_title: str
        :keyword update_size: Size of the update(In Bytes).
        :paramtype update_size: float
        :keyword update_type: Type of the Update. Known values are: "Software", "Kubernetes", and
         "Firmware".
        :paramtype update_type: str or ~azure.mgmt.databoxedge.models.UpdateType
        :keyword target_version: Target Version number.
        :paramtype target_version: str
        :keyword estimated_install_time_in_mins: Estimated Install Time for the update.
        :paramtype estimated_install_time_in_mins: int
        :keyword reboot_behavior: Indicates if updates are available and at least one of the updates
         needs a reboot. Known values are: "NeverReboots", "RequiresReboot", and "RequestReboot".
        :paramtype reboot_behavior: str or ~azure.mgmt.databoxedge.models.InstallRebootBehavior
        :keyword status: Status of the update. Known values are: "DownloadPending", "DownloadStarted",
         "DownloadCompleted", "InstallStarted", and "InstallCompleted".
        :paramtype status: str or ~azure.mgmt.databoxedge.models.UpdateStatus
        """
        super().__init__(**kwargs)
        self.update_title = update_title
        self.update_size = update_size
        self.update_type = update_type
        self.target_version = target_version
        self.estimated_install_time_in_mins = estimated_install_time_in_mins
        self.reboot_behavior = reboot_behavior
        self.status = status


class UpdateDownloadProgress(_serialization.Model):
    """Details about the download progress of update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar download_phase: The download phase. Known values are: "Unknown", "Initializing",
     "Downloading", and "Verifying".
    :vartype download_phase: str or ~azure.mgmt.databoxedge.models.DownloadPhase
    :ivar percent_complete: Percentage of completion.
    :vartype percent_complete: int
    :ivar total_bytes_to_download: Total bytes to download.
    :vartype total_bytes_to_download: float
    :ivar total_bytes_downloaded: Total bytes downloaded.
    :vartype total_bytes_downloaded: float
    :ivar number_of_updates_to_download: Number of updates to download.
    :vartype number_of_updates_to_download: int
    :ivar number_of_updates_downloaded: Number of updates downloaded.
    :vartype number_of_updates_downloaded: int
    """

    _validation = {
        "download_phase": {"readonly": True},
        "percent_complete": {"readonly": True},
        "total_bytes_to_download": {"readonly": True},
        "total_bytes_downloaded": {"readonly": True},
        "number_of_updates_to_download": {"readonly": True},
        "number_of_updates_downloaded": {"readonly": True},
    }

    _attribute_map = {
        "download_phase": {"key": "downloadPhase", "type": "str"},
        "percent_complete": {"key": "percentComplete", "type": "int"},
        "total_bytes_to_download": {"key": "totalBytesToDownload", "type": "float"},
        "total_bytes_downloaded": {"key": "totalBytesDownloaded", "type": "float"},
        "number_of_updates_to_download": {"key": "numberOfUpdatesToDownload", "type": "int"},
        "number_of_updates_downloaded": {"key": "numberOfUpdatesDownloaded", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.download_phase: Optional[Union[str, "_models.DownloadPhase"]] = None
        self.percent_complete: Optional[int] = None
        self.total_bytes_to_download: Optional[float] = None
        self.total_bytes_downloaded: Optional[float] = None
        self.number_of_updates_to_download: Optional[int] = None
        self.number_of_updates_downloaded: Optional[int] = None


class UpdateInstallProgress(_serialization.Model):
    """Progress details during installation of updates.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar percent_complete: Percentage completed.
    :vartype percent_complete: int
    :ivar number_of_updates_to_install: Number of updates to install.
    :vartype number_of_updates_to_install: int
    :ivar number_of_updates_installed: Number of updates installed.
    :vartype number_of_updates_installed: int
    """

    _validation = {
        "percent_complete": {"readonly": True},
        "number_of_updates_to_install": {"readonly": True},
        "number_of_updates_installed": {"readonly": True},
    }

    _attribute_map = {
        "percent_complete": {"key": "percentComplete", "type": "int"},
        "number_of_updates_to_install": {"key": "numberOfUpdatesToInstall", "type": "int"},
        "number_of_updates_installed": {"key": "numberOfUpdatesInstalled", "type": "int"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.percent_complete: Optional[int] = None
        self.number_of_updates_to_install: Optional[int] = None
        self.number_of_updates_installed: Optional[int] = None


class UpdateSummary(ARMBaseModel):
    """Details about ongoing updates and availability of updates on the device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: UpdateSummary Result.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar device_version_number: The current version of the device in format: 1.2.17312.13.",.
    :vartype device_version_number: str
    :ivar friendly_device_version_name: The current version of the device in text format.
    :vartype friendly_device_version_name: str
    :ivar device_last_scanned_date_time: The last time when a scan was done on the device.
    :vartype device_last_scanned_date_time: ~datetime.datetime
    :ivar last_completed_scan_job_date_time: The time when the last scan job was completed
     (success/cancelled/failed) on the appliance.
    :vartype last_completed_scan_job_date_time: ~datetime.datetime
    :ivar last_completed_download_job_date_time: The time when the last Download job was completed
     (success/cancelled/failed) on the appliance.
    :vartype last_completed_download_job_date_time: ~datetime.datetime
    :ivar last_completed_download_job_id: JobId of the last ran download job.(Can be
     success/cancelled/failed).
    :vartype last_completed_download_job_id: str
    :ivar last_download_job_status: JobStatus of the last ran download job. Known values are:
     "Invalid", "Running", "Succeeded", "Failed", "Canceled", "Paused", and "Scheduled".
    :vartype last_download_job_status: str or ~azure.mgmt.databoxedge.models.JobStatus
    :ivar last_completed_install_job_date_time: The time when the last Install job was completed
     (success/cancelled/failed) on the appliance.
    :vartype last_completed_install_job_date_time: ~datetime.datetime
    :ivar last_completed_install_job_id: JobId of the last ran install job.(Can be
     success/cancelled/failed).
    :vartype last_completed_install_job_id: str
    :ivar last_install_job_status: JobStatus of the last ran install job. Known values are:
     "Invalid", "Running", "Succeeded", "Failed", "Canceled", "Paused", and "Scheduled".
    :vartype last_install_job_status: str or ~azure.mgmt.databoxedge.models.JobStatus
    :ivar total_number_of_updates_available: The number of updates available for the current device
     version as per the last device scan.
    :vartype total_number_of_updates_available: int
    :ivar total_number_of_updates_pending_download: The total number of items pending download.
    :vartype total_number_of_updates_pending_download: int
    :ivar total_number_of_updates_pending_install: The total number of items pending install.
    :vartype total_number_of_updates_pending_install: int
    :ivar reboot_behavior: Indicates if updates are available and at least one of the updates needs
     a reboot. Known values are: "NeverReboots", "RequiresReboot", and "RequestReboot".
    :vartype reboot_behavior: str or ~azure.mgmt.databoxedge.models.InstallRebootBehavior
    :ivar ongoing_update_operation: The current update operation. Known values are: "None", "Scan",
     "Download", and "Install".
    :vartype ongoing_update_operation: str or ~azure.mgmt.databoxedge.models.UpdateOperation
    :ivar in_progress_download_job_id: The job ID of the download job in progress.
    :vartype in_progress_download_job_id: str
    :ivar in_progress_install_job_id: The job ID of the install job in progress.
    :vartype in_progress_install_job_id: str
    :ivar in_progress_download_job_started_date_time: The time when the currently running download
     (if any) started.
    :vartype in_progress_download_job_started_date_time: ~datetime.datetime
    :ivar in_progress_install_job_started_date_time: The time when the currently running install
     (if any) started.
    :vartype in_progress_install_job_started_date_time: ~datetime.datetime
    :ivar update_titles: The list of updates available for install.
    :vartype update_titles: list[str]
    :ivar updates: The list of updates available for install.
    :vartype updates: list[~azure.mgmt.databoxedge.models.UpdateDetails]
    :ivar total_update_size_in_bytes: The total size of updates available for download in bytes.
    :vartype total_update_size_in_bytes: float
    :ivar total_time_in_minutes: The total time in Minutes.
    :vartype total_time_in_minutes: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "last_completed_download_job_date_time": {"readonly": True},
        "last_completed_download_job_id": {"readonly": True},
        "last_download_job_status": {"readonly": True},
        "last_completed_install_job_date_time": {"readonly": True},
        "last_completed_install_job_id": {"readonly": True},
        "last_install_job_status": {"readonly": True},
        "total_number_of_updates_available": {"readonly": True},
        "total_number_of_updates_pending_download": {"readonly": True},
        "total_number_of_updates_pending_install": {"readonly": True},
        "reboot_behavior": {"readonly": True},
        "ongoing_update_operation": {"readonly": True},
        "in_progress_download_job_id": {"readonly": True},
        "in_progress_install_job_id": {"readonly": True},
        "in_progress_download_job_started_date_time": {"readonly": True},
        "in_progress_install_job_started_date_time": {"readonly": True},
        "update_titles": {"readonly": True},
        "updates": {"readonly": True},
        "total_update_size_in_bytes": {"readonly": True},
        "total_time_in_minutes": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "device_version_number": {"key": "properties.deviceVersionNumber", "type": "str"},
        "friendly_device_version_name": {"key": "properties.friendlyDeviceVersionName", "type": "str"},
        "device_last_scanned_date_time": {"key": "properties.deviceLastScannedDateTime", "type": "iso-8601"},
        "last_completed_scan_job_date_time": {"key": "properties.lastCompletedScanJobDateTime", "type": "iso-8601"},
        "last_completed_download_job_date_time": {
            "key": "properties.lastCompletedDownloadJobDateTime",
            "type": "iso-8601",
        },
        "last_completed_download_job_id": {"key": "properties.lastCompletedDownloadJobId", "type": "str"},
        "last_download_job_status": {"key": "properties.lastDownloadJobStatus", "type": "str"},
        "last_completed_install_job_date_time": {
            "key": "properties.lastCompletedInstallJobDateTime",
            "type": "iso-8601",
        },
        "last_completed_install_job_id": {"key": "properties.lastCompletedInstallJobId", "type": "str"},
        "last_install_job_status": {"key": "properties.lastInstallJobStatus", "type": "str"},
        "total_number_of_updates_available": {"key": "properties.totalNumberOfUpdatesAvailable", "type": "int"},
        "total_number_of_updates_pending_download": {
            "key": "properties.totalNumberOfUpdatesPendingDownload",
            "type": "int",
        },
        "total_number_of_updates_pending_install": {
            "key": "properties.totalNumberOfUpdatesPendingInstall",
            "type": "int",
        },
        "reboot_behavior": {"key": "properties.rebootBehavior", "type": "str"},
        "ongoing_update_operation": {"key": "properties.ongoingUpdateOperation", "type": "str"},
        "in_progress_download_job_id": {"key": "properties.inProgressDownloadJobId", "type": "str"},
        "in_progress_install_job_id": {"key": "properties.inProgressInstallJobId", "type": "str"},
        "in_progress_download_job_started_date_time": {
            "key": "properties.inProgressDownloadJobStartedDateTime",
            "type": "iso-8601",
        },
        "in_progress_install_job_started_date_time": {
            "key": "properties.inProgressInstallJobStartedDateTime",
            "type": "iso-8601",
        },
        "update_titles": {"key": "properties.updateTitles", "type": "[str]"},
        "updates": {"key": "properties.updates", "type": "[UpdateDetails]"},
        "total_update_size_in_bytes": {"key": "properties.totalUpdateSizeInBytes", "type": "float"},
        "total_time_in_minutes": {"key": "properties.totalTimeInMinutes", "type": "int"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        device_version_number: Optional[str] = None,
        friendly_device_version_name: Optional[str] = None,
        device_last_scanned_date_time: Optional[datetime.datetime] = None,
        last_completed_scan_job_date_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword device_version_number: The current version of the device in format: 1.2.17312.13.",.
        :paramtype device_version_number: str
        :keyword friendly_device_version_name: The current version of the device in text format.
        :paramtype friendly_device_version_name: str
        :keyword device_last_scanned_date_time: The last time when a scan was done on the device.
        :paramtype device_last_scanned_date_time: ~datetime.datetime
        :keyword last_completed_scan_job_date_time: The time when the last scan job was completed
         (success/cancelled/failed) on the appliance.
        :paramtype last_completed_scan_job_date_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.device_version_number = device_version_number
        self.friendly_device_version_name = friendly_device_version_name
        self.device_last_scanned_date_time = device_last_scanned_date_time
        self.last_completed_scan_job_date_time = last_completed_scan_job_date_time
        self.last_completed_download_job_date_time: Optional[datetime.datetime] = None
        self.last_completed_download_job_id: Optional[str] = None
        self.last_download_job_status: Optional[Union[str, "_models.JobStatus"]] = None
        self.last_completed_install_job_date_time: Optional[datetime.datetime] = None
        self.last_completed_install_job_id: Optional[str] = None
        self.last_install_job_status: Optional[Union[str, "_models.JobStatus"]] = None
        self.total_number_of_updates_available: Optional[int] = None
        self.total_number_of_updates_pending_download: Optional[int] = None
        self.total_number_of_updates_pending_install: Optional[int] = None
        self.reboot_behavior: Optional[Union[str, "_models.InstallRebootBehavior"]] = None
        self.ongoing_update_operation: Optional[Union[str, "_models.UpdateOperation"]] = None
        self.in_progress_download_job_id: Optional[str] = None
        self.in_progress_install_job_id: Optional[str] = None
        self.in_progress_download_job_started_date_time: Optional[datetime.datetime] = None
        self.in_progress_install_job_started_date_time: Optional[datetime.datetime] = None
        self.update_titles: Optional[List[str]] = None
        self.updates: Optional[List["_models.UpdateDetails"]] = None
        self.total_update_size_in_bytes: Optional[float] = None
        self.total_time_in_minutes: Optional[int] = None


class UploadCertificateRequest(_serialization.Model):
    """The upload certificate request.

    All required parameters must be populated in order to send to server.

    :ivar authentication_type: The authentication type. Known values are: "Invalid" and
     "AzureActiveDirectory".
    :vartype authentication_type: str or ~azure.mgmt.databoxedge.models.AuthenticationType
    :ivar certificate: The base64 encoded certificate raw data. Required.
    :vartype certificate: str
    """

    _validation = {
        "certificate": {"required": True},
    }

    _attribute_map = {
        "authentication_type": {"key": "properties.authenticationType", "type": "str"},
        "certificate": {"key": "properties.certificate", "type": "str"},
    }

    def __init__(
        self,
        *,
        certificate: str,
        authentication_type: Optional[Union[str, "_models.AuthenticationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authentication_type: The authentication type. Known values are: "Invalid" and
         "AzureActiveDirectory".
        :paramtype authentication_type: str or ~azure.mgmt.databoxedge.models.AuthenticationType
        :keyword certificate: The base64 encoded certificate raw data. Required.
        :paramtype certificate: str
        """
        super().__init__(**kwargs)
        self.authentication_type = authentication_type
        self.certificate = certificate


class UploadCertificateResponse(_serialization.Model):
    """The upload registration certificate response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar auth_type: Specifies authentication type. Known values are: "Invalid" and
     "AzureActiveDirectory".
    :vartype auth_type: str or ~azure.mgmt.databoxedge.models.AuthenticationType
    :ivar resource_id: The resource ID of the Data Box Edge/Gateway device.
    :vartype resource_id: str
    :ivar aad_authority: Azure Active Directory tenant authority.
    :vartype aad_authority: str
    :ivar aad_tenant_id: Azure Active Directory tenant ID.
    :vartype aad_tenant_id: str
    :ivar service_principal_client_id: Azure Active Directory service principal client ID.
    :vartype service_principal_client_id: str
    :ivar service_principal_object_id: Azure Active Directory service principal object ID.
    :vartype service_principal_object_id: str
    :ivar azure_management_endpoint_audience: The azure management endpoint audience.
    :vartype azure_management_endpoint_audience: str
    :ivar aad_audience: Identifier of the target resource that is the recipient of the requested
     token.
    :vartype aad_audience: str
    """

    _validation = {
        "resource_id": {"readonly": True},
        "aad_authority": {"readonly": True},
        "aad_tenant_id": {"readonly": True},
        "service_principal_client_id": {"readonly": True},
        "service_principal_object_id": {"readonly": True},
        "azure_management_endpoint_audience": {"readonly": True},
        "aad_audience": {"readonly": True},
    }

    _attribute_map = {
        "auth_type": {"key": "authType", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "aad_authority": {"key": "aadAuthority", "type": "str"},
        "aad_tenant_id": {"key": "aadTenantId", "type": "str"},
        "service_principal_client_id": {"key": "servicePrincipalClientId", "type": "str"},
        "service_principal_object_id": {"key": "servicePrincipalObjectId", "type": "str"},
        "azure_management_endpoint_audience": {"key": "azureManagementEndpointAudience", "type": "str"},
        "aad_audience": {"key": "aadAudience", "type": "str"},
    }

    def __init__(self, *, auth_type: Optional[Union[str, "_models.AuthenticationType"]] = None, **kwargs: Any) -> None:
        """
        :keyword auth_type: Specifies authentication type. Known values are: "Invalid" and
         "AzureActiveDirectory".
        :paramtype auth_type: str or ~azure.mgmt.databoxedge.models.AuthenticationType
        """
        super().__init__(**kwargs)
        self.auth_type = auth_type
        self.resource_id: Optional[str] = None
        self.aad_authority: Optional[str] = None
        self.aad_tenant_id: Optional[str] = None
        self.service_principal_client_id: Optional[str] = None
        self.service_principal_object_id: Optional[str] = None
        self.azure_management_endpoint_audience: Optional[str] = None
        self.aad_audience: Optional[str] = None


class User(ARMBaseModel):
    """Represents a user who has access to one or more shares on the Data Box Edge/Gateway device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The path ID that uniquely identifies the object.
    :vartype id: str
    :ivar name: The object name.
    :vartype name: str
    :ivar type: The hierarchical type of the object.
    :vartype type: str
    :ivar system_data: User in DataBoxEdge Resource.
    :vartype system_data: ~azure.mgmt.databoxedge.models.SystemData
    :ivar encrypted_password: The password details.
    :vartype encrypted_password: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
    :ivar share_access_rights: List of shares that the user has rights on. This field should not be
     specified during user creation.
    :vartype share_access_rights: list[~azure.mgmt.databoxedge.models.ShareAccessRight]
    :ivar user_type: Type of the user. Known values are: "Share", "LocalManagement", and "ARM".
    :vartype user_type: str or ~azure.mgmt.databoxedge.models.UserType
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "share_access_rights": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "encrypted_password": {"key": "properties.encryptedPassword", "type": "AsymmetricEncryptedSecret"},
        "share_access_rights": {"key": "properties.shareAccessRights", "type": "[ShareAccessRight]"},
        "user_type": {"key": "properties.userType", "type": "str"},
    }

    def __init__(
        self,
        *,
        encrypted_password: Optional["_models.AsymmetricEncryptedSecret"] = None,
        user_type: Optional[Union[str, "_models.UserType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encrypted_password: The password details.
        :paramtype encrypted_password: ~azure.mgmt.databoxedge.models.AsymmetricEncryptedSecret
        :keyword user_type: Type of the user. Known values are: "Share", "LocalManagement", and "ARM".
        :paramtype user_type: str or ~azure.mgmt.databoxedge.models.UserType
        """
        super().__init__(**kwargs)
        self.system_data: Optional["_models.SystemData"] = None
        self.encrypted_password = encrypted_password
        self.share_access_rights: Optional[List["_models.ShareAccessRight"]] = None
        self.user_type = user_type


class UserAccessRight(_serialization.Model):
    """The mapping between a particular user and the access type on the SMB share.

    All required parameters must be populated in order to send to server.

    :ivar user_id: User ID (already existing in the device). Required.
    :vartype user_id: str
    :ivar access_type: Type of access to be allowed for the user. Required. Known values are:
     "Change", "Read", and "Custom".
    :vartype access_type: str or ~azure.mgmt.databoxedge.models.ShareAccessType
    """

    _validation = {
        "user_id": {"required": True},
        "access_type": {"required": True},
    }

    _attribute_map = {
        "user_id": {"key": "userId", "type": "str"},
        "access_type": {"key": "accessType", "type": "str"},
    }

    def __init__(self, *, user_id: str, access_type: Union[str, "_models.ShareAccessType"], **kwargs: Any) -> None:
        """
        :keyword user_id: User ID (already existing in the device). Required.
        :paramtype user_id: str
        :keyword access_type: Type of access to be allowed for the user. Required. Known values are:
         "Change", "Read", and "Custom".
        :paramtype access_type: str or ~azure.mgmt.databoxedge.models.ShareAccessType
        """
        super().__init__(**kwargs)
        self.user_id = user_id
        self.access_type = access_type


class UserList(_serialization.Model):
    """Collection of users.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of users.
    :vartype value: list[~azure.mgmt.databoxedge.models.User]
    :ivar next_link: Link to the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[User]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value: Optional[List["_models.User"]] = None
        self.next_link: Optional[str] = None
